local M = {}

-- Define identifiers for the backfire audio events
local backfireAudioID = "backfireSound"
local backfireAudioID2 = "backfireSound2"

-- Sound files for each backfire function
local soundFiles = {
    "art/sound/engine/GTMKIV_BACKFIRE/BrightPoppy_Backfire_01.wav",
    "art/sound/engine/GTMKIV_BACKFIRE/BrightPoppy_Backfire_02.wav",
    "art/sound/engine/GTMKIV_BACKFIRE/BrightPoppy_Backfire_03.wav",
    "art/sound/engine/GTMKIV_BACKFIRE/BrightPoppy_Backfire_04.wav",
    "art/sound/engine/GTMKIV_BACKFIRE/BrightPoppy_Backfire_05.wav",
    "art/sound/engine/GTMKIV_BACKFIRE/BrightPoppy_Backfire_06.wav",
    "art/sound/engine/GTMKIV_BACKFIRE/BrightPoppy_Backfire_07.wav",
    "art/sound/engine/GTMKIV_BACKFIRE/BrightPoppy_Backfire_08.wav"
}

local soundFiles2 = {
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_01.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_02.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_03.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_04.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_05.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_06.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_07.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_08.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_09.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_10.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_11.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_13.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_14.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_15.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_16.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_17.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_18.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_20.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_21.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_22.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_23.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_24.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_25.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_26.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_27.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_30.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_31.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_32.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_35.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character01_36.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_01.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_02.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_03.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_04.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_06.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_07.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_08.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_09.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_10.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_11.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_12.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_13.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_14.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_15.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_16.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_18.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_20.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_21.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_22.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_23.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_24.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_26.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_27.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_28.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_29.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_30.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_31.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_32.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_33.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_34.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_35.wav",
    "art/sound/engine/GTMKIV_LOWDET/BrightPoppy_LOWDET_Character02_36.wav"
}

-- Function to play a random backfire sound from soundFiles
local function playBackfireSound()
    -- Select a random backfire sound file
    local randomIndex = math.random(1, #soundFiles)
    local selectedSoundFile = soundFiles[randomIndex]
    
    -- Generate a unique ID for each playback instance
    local uniqueID = backfireAudioID .. "_" .. tostring(math.random(1, 100000))

    -- Create and play the SFX source for the selected sound file with a unique ID
    obj:createSFXSource(selectedSoundFile, "AudioClosest3D", uniqueID, -1)
    obj:playSFXOnce(uniqueID, 0, 4, 1) -- Increased volume to 6, pitch remains 1
end

local function playBackfireSound2()
    -- Select a random backfire sound file
    local randomIndex = math.random(1, #soundFiles2)
    local selectedSoundFile2 = soundFiles2[randomIndex]
    
    -- Generate a unique ID for each playback instance
    local uniqueID = backfireAudioID2 .. "_" .. tostring(math.random(1, 100000))


    -- Create and play the SFX source for the selected sound file with a unique ID
    obj:createSFXSource(selectedSoundFile2, "AudioClosest3D", uniqueID, -1)
    obj:playSFXOnce(uniqueID, 0, 4, 1) -- Increased volume to 6, pitch remains 1
end


-- Function to reset the triggers
local function resetBackfireTrigger()
    backfireTriggered = false
    backfireTriggered2 = false
end

-- Initialize function
local function onInit(jbeamData)
    -- Initialize the backfire script
end

-- Update function to trigger backfire sound based on RPM and afterFire states
local function updateGFX(dt)
    local rpm = electrics.values.rpm

    if electrics.values.afterFire2 == 1 and rpm > 4000 then
        if not backfireTriggered then
            playBackfireSound()
            backfireTriggered = true
        end
    elseif electrics.values.afterFire == 1 then
        if not backfireTriggered2 then
            playBackfireSound2()
            backfireTriggered2 = true
        end
    else
        resetBackfireTrigger() -- Reset triggers if conditions are not met
    end
end

-- Public interface
M.onInit = onInit
M.updateGFX = updateGFX
M.playBackfireSound = playBackfireSound
M.playBackfireSound2 = playBackfireSound2
M.resetBackfireTrigger = resetBackfireTrigger

return M
