local M = {}
local lastErrorLeanManualSteer  = 0 -- the TAS Delta ( the value of TAS - TargetTAS) of the last sample time, 
local lastErrorAISteer  = 0
local IntegralSumManualSteer = 0 --Integral sum, 
local IntegralSumAISteer = 0
local minimumLoggingInterval =  0.125 -- 8 times per second by default
local runningTimer = 0
local timeSinceLastLog = 0
local logFile = nil
local enableLogToFile = 0
local enableLogSteering = 0
local enableAILog = 0
local wheelingMeasure = 0
local kickstand_kicked = 0

local Kp_base = 0.025
local Ki_base = 0.0
local Kd_base = 0.045


local throttleArray = nil
local clutchArray = nil
local steerArray = nil
local posArray = nil

local gearIndexArray = nil
local current_AI_index = 0
local recorded_AI_index = 0
local current_AI_state = 0
local currentGear = 0
local lastPosition = 0
local AI_STATE_STOPPED = 0
local AI_STATE_RECORDING = 1
local AI_STATE_PLAYING = 2
local MAX_AI_ELEMS = 2000000

local prev_keyb_steering = 0
local computed_steering = 0
local KEYB_STEER_INC = 0.005
local KEYB_INPUT = 0
local WHEEL_INPUT = 1
local inputMethod = KEYB_METHOD


local particleType = 96 --BLOOD
local particleDuration = 200

local beamsNodesData = {}
local brokenBeams = {}


local HEAD = 1
local ARM_L = 2
local ARM_R = 3
local HIP_H = 4
local HIP_L = 5
local LEG_L = 6
local LEG_R = 7
local LAST_PART = 7

local GROUP = 1
local NODE = 2
local NODE_ID = 3
local COUNTER = 4
local BROKEN = 5

local AutoThrottle
local THROTTLE_ALGO_START_SPEED = 3.0
local STOPPED = 0
local STARTED = 1
local throttleState
local THROTTLE_INC = 0.001
local throttle
local MAX_LEAN = 60
local MAX_LEAN_SPEED = 120
local MIN_LEAN = 30
local MAX_SPEED = 400
local MIN_SPEED = 40




local function brokeBeamsCheck()
    
	for _, b in pairs(v.data.beams) do
		if obj:beamIsBroken(b.cid) and b.breakGroup == "fall" then return true
		end
	end
	return false
	
end




local function logLine(...)
    local args = {...}

  for k,v in ipairs(args) do
      logFile:write(tostring(v))
  
      if k ~= #args then
          logFile:write("+")    
      end
  end
  
  logFile:write("\r\n")
end

local function initLogFile()
	if enableLogToFile == 1 then
 
		if logFile then
			logFile:close()
			logFile = nil
		end

		local logFileName = "datalog"
		local timestamp = os.date("%Y%m%d_%H%M%S")
		local filename = logFileName .. "_" .. timestamp .. ".csv"
		runningTimer = 0

		logFile =  io.open(filename, "w")
		-- Write header:
		-- logLine("time", "throttle", "throttle_input", "engineThrottle", "clutch", "clutch_input", "clutchRatio", "isShifting", "gear", "gearIndex")
		logLine("time", "speed", "steering_input", "throttle", "targetLean", "trueLean", "errorLean", "lastErrorLeanManualSteer", "PID_P", "PID_D", "steeringBike")
		
	end
end

-- BeamNG Controller Functions

local function init_AI()
	electrics.values.AI_rec = 0
	electrics.values.AI_play = 0
	electrics.values.AI_stop = 0
	lastErrorAISteer = 0	
	throttleArray = {}
	steerArray = {}
	posArray = {}	
	clutchArray = {}
	gearIndexArray = {}
	current_AI_index = 0
	recorded_AI_index = 0
	currentGear = 0
	current_AI_state = AI_STATE_STOPPED
end


local function init(jbeamData)

	electrics.values["crouch_pose_req"] = 0
	electrics.values["rpmWarning"] = 0
	electrics.values["steeringBike"] = 0
	electrics.values["currentWheelingDistance"] = 0
	electrics.values["kickstand_retract"] = 0
	lastErrorLeanManualSteer  = 0 -- the TAS Delta ( the value of TAS - TargetTAS) of the last sample time, 
	IntegralSumManualSteer = 0 --Integral sum, 
	IntegralSumAISteer = 0
	lastPosition = 0
	timeSinceLastLog = 0
	prev_keyb_steering = 0
	computed_steering = 0
	kickstand_kicked = 0	
	particleDuration = (jbeamData.particleDuration / 0.05 ) or particleDuration
	MIN_SPEED = jbeamData.minSpeed or MIN_SPEED
	AutoThrottle = jbeamData.AutoThrottle or false
	throttleState = STOPPED
	throttle = 0
	
	initLogFile()
	init_AI()

	
	for k, v in pairs(v.data.activeParts) do
		local partName = k
		if partName == "KeybInput" then
			inputMethod = KEYB_INPUT
		else
			if partName == "WheelInput" then
				inputMethod = WHEEL_INPUT
			else
				if partName == "cyborg" then
					particleType = 1  --Electric 
				end
			end
		end	
	end
		
	
	brokenBeams = {}

	beamsNodesData[HEAD] = {"bleeding", "tor_r11", 0, particleDuration, false}
	beamsNodesData[ARM_L] = {"bleeding", "l_a_h_3", 0, particleDuration, false}
	beamsNodesData[ARM_R] = {"bleeding", "r_a_h_3", 0, particleDuration, false}
	beamsNodesData[HIP_H] = {"bleeding", "tor_r6", 0, particleDuration, false}
	beamsNodesData[HIP_L] = {"bleeding", "hyp_h_r4", 0, particleDuration, false}
	beamsNodesData[LEG_L] = {"bleeding", "l_l_h_5", 0, particleDuration, false}
	beamsNodesData[LEG_R] = {"bleeding", "r_l_h_5", 0, particleDuration, false}
	

	for i=1,LAST_PART do
		if beamsNodesData[i] ~= nil then
			for _, node in pairs(v.data.nodes) do 
				if node.name == beamsNodesData[i][NODE] then
					beamsNodesData[i][NODE_ID] = node.cid
				end
			end
		end
	end
		
end



local function manageRiderParticles()
	for _, beam in pairs(v.data.beams) do 
		local beamBroken = obj:beamIsBroken(beam.cid)
		if beamBroken and brokenBeams[beam.cid] == nil then
			brokenBeams[beam.cid] = true
			
			if type(beam.breakGroup) == 'table' then
				for _, group in pairs(beam.breakGroup) do
					local stop = false
					for i=1,LAST_PART do
						if beamsNodesData[i][GROUP] == group and beamsNodesData[i][BROKEN] == false then
							beamsNodesData[i][BROKEN] = true
						end
					end
				end
			else				
				for i=1,LAST_PART do
					if beamsNodesData[i][GROUP] == beam.breakGroup and beamsNodesData[i][BROKEN] == false then
						beamsNodesData[i][BROKEN] = true
					end
				end
			end
		end
	end
		
	for i=1,LAST_PART do		
		if beamsNodesData[i][BROKEN] and beamsNodesData[i][COUNTER] > 0 then
			beamsNodesData[i][COUNTER] = beamsNodesData[i][COUNTER] - 1
			obj:addParticleByNodes(beamsNodesData[i][NODE_ID], beamsNodesData[i][NODE_ID], -1, particleType, 0.01, 5)
			print("node " .. beamsNodesData[i][NODE] .. " bleeds")
		end
	end
end



local function getSpeedKmh()

return obj:getVelocity():length()*3.6

end


local function limitMAXSpeed()

	local speed = getSpeedKmh()

	if speed > MAX_SPEED then
		electrics.values["throttle"] = 0
	end
end



local function limitMINSpeed()

	local speed = getSpeedKmh()
	
	if throttleState == STOPPED then
		if speed > THROTTLE_ALGO_START_SPEED then
			throttleState = STARTED
			throttle = 0
		end
	else
		if speed < MIN_SPEED and electrics.values["gear"] > 0 then
			throttle = throttle + (((MIN_SPEED - speed)/(MIN_SPEED/2)) * THROTTLE_INC)
			electrics.values["throttle"] = throttle
		else
			if throttle > 0.0 then
				throttle = throttle - (((MIN_SPEED - speed)/(MIN_SPEED/2)) * THROTTLE_INC)
			end
		end
	end
	
end


local function compute_steering_input_with_PID(savedPosA, savedPosB, dt)

	local curPos = obj:getPosition()
	
	local positionSign = 1
	
	local errorDistance = math.sqrt( (curPos.x - savedPosB.x) * (curPos.x - savedPosB.x) + (curPos.y - savedPosB.y) * (curPos.y - savedPosB.y))
	
	if ((savedPosB.x - savedPosA.x)*(curPos.y - savedPosA.y) - (savedPosB.y - savedPosA.y)*(curPos.x - savedPosA.x)) > 0 then
		positionSign = -1
	end
		

	--Integral controller
	
	local auto_Kp = 0.02
    local auto_Ki = 0.001
    local auto_Kd = 0.001
	
	local PID_P = auto_Kp * errorDistance   -- calculate the P part
    IntegralSumAISteer = IntegralSumAISteer + errorDistance * dt
    if math.abs(IntegralSumAISteer) > 1000 then
        if IntegralSumAISteer > 0 then
            IntegralSumAISteer = 1000 
        elseif IntegralSumAISteer < 0 then
            IntegralSumAISteer = -1000
        end
    end


    local PID_I = auto_Ki * IntegralSumAISteer
    local PID_D = auto_Kd * (errorDistance - lastErrorAISteer) / dt
    local steering_output = (PID_P + PID_I + PID_D)* positionSign
	
	lastErrorAISteer = errorDistance
	
	timeSinceLastLog = timeSinceLastLog + dt
	if timeSinceLastLog >= minimumLoggingInterval then
		timeSinceLastLog = 0
		print("curPos.x: " .. tonumber(string.format("%.3f", curPos.x)) .. " savedPosB.x: " .. tonumber(string.format("%.3f", savedPosB.x)) .. 
				" curPos.y: " .. tonumber(string.format("%.3f", curPos.y)) .. " savedPosB.y: " .. tonumber(string.format("%.3f", savedPosB.y)) .. 
				" positionSign: " .. positionSign .. "steering_output" .. steering_output)
	end

			
	return steering_output
	
end
	
	
local function manageAIRecording(dt)
	
	if electrics.values.AI_rec == 1 then
		electrics.values.AI_rec = 0
		electrics.values.AI_stop = 0
		current_AI_state = AI_STATE_RECORDING
		recorded_AI_index = 0
		gui.message("RECORDING")
		print("--------------------RECORDING--------------------")
	end
	if electrics.values.AI_play == 1 then
		electrics.values.AI_stop = 0
		electrics.values.AI_play = 0
		current_AI_state = AI_STATE_PLAYING
		current_AI_index = 0
		currentGear = 0
		gui.message("PLAYING")		
		print("--------------------PLAYING--------------------")
	end
	if electrics.values.AI_stop == 1 then
		electrics.values.AI_stop = 0
		current_AI_state = AI_STATE_STOPPED
		gui.message("STOPPED")		
		print("--------------------STOPPED--------------------")
	end
	


	
	if current_AI_state == AI_STATE_PLAYING then
		if current_AI_index < recorded_AI_index then
		
			if electrics.values["isShifting"] == false then
				electrics.values["throttle"] = throttleArray[current_AI_index]
				electrics.values["clutch"] = clutchArray[current_AI_index]
				electrics.values["clutchRatio"] = 1 - clutchArray[current_AI_index]
			else
				gui.message("SHIFTING")	
			end
			
		--	if current_AI_index > 0 then
		--		electrics.values["steering_input"] = 
		--		compute_steering_input_with_PID(posArray[current_AI_index - 1], posArray[current_AI_index], dt) 
		--	else
		--		electrics.values["steering_input"] = steerArray[current_AI_index]
		--	end
			electrics.values["steering_input"] = steerArray[current_AI_index]

			if gearIndexArray[current_AI_index] ~= 0 then
				if gearIndexArray[current_AI_index] > currentGear then
					controller.mainController.shiftUp()
					currentGear = currentGear + 1
				else
					if gearIndexArray[current_AI_index] < currentGear then
						controller.mainController.shiftDown()
						currentGear = currentGear - 1
					end
				end
			else
				if currentGear == 1 then
					controller.mainController.shiftDown()
					currentGear = 0
				end
			end
			
			current_AI_index = current_AI_index + 1
			if current_AI_index > MAX_AI_ELEMS or current_AI_index > recorded_AI_index then
				current_AI_state = AI_STATE_STOPPED
				gui.message("reached MAX_AI_ELEMS during PLAY")				
			end
		end
	end
	if current_AI_state == AI_STATE_RECORDING then
		throttleArray[recorded_AI_index] = electrics.values["throttle"]
		clutchArray[recorded_AI_index] = electrics.values["clutch"]
		steerArray[recorded_AI_index] = electrics.values["steering_input"]
		posArray[recorded_AI_index] = obj:getPosition()
		gearIndexArray[recorded_AI_index] = electrics.values["gear_M"]
		recorded_AI_index = recorded_AI_index + 1
		if recorded_AI_index > MAX_AI_ELEMS then
			current_AI_state = AI_STATE_STOPPED
			gui.message("reached MAX_AI_ELEMS during REC")
		end
	end
	
	
	
	if enableAILog == 1 then
		timeSinceLastLog = timeSinceLastLog + dt
		runningTimer = runningTimer + dt
		
		if timeSinceLastLog >= minimumLoggingInterval then
			timeSinceLastLog = 0
			
			logLine(
			 tonumber(string.format("%.3f", runningTimer)),
			 electrics.values["throttle"],
			 electrics.values["throttle_input"],
			 electrics.values["engineThrottle"],
			 electrics.values["clutch"],
			 electrics.values["clutch_input"],
			 electrics.values["clutchRatio"],
			 tostring(electrics.values["isShifting"]),
			 tostring(electrics.values["gear"]),
			 tostring(electrics.values["gearIndex"])
			)
			-- print("throttle: " .. electrics.values["throttle"])
			-- print("throttle_input: " .. electrics.values["throttle_input"])
			-- print("engineThrottle: " .. electrics.values["engineThrottle"])
			-- print("clutch: " .. electrics.values["clutch"])
			-- print("clutch_input: " .. electrics.values["clutch_input"])
			-- print("clutchRatio: " .. electrics.values["clutchRatio"])
			-- print("isShifting: " .. tostring(electrics.values["isShifting"]))
			-- print("gear: " .. tostring(electrics.values["gear"]))
			--print("gear_A: " .. tostring(electrics.values["gear_A"]))
			--print("gear_M: " .. tostring(electrics.values["gear_M"]))
			--print("gearIndex: " .. tostring(electrics.values["gearIndex"]))
		end
	end
	
end



local function manageWheeling(dt)

	if electrics.values["wheeling_count"] == 1 then
		if wheelingMeasure == 0 then
			wheelingMeasure = 1 
			gui.message("Start measuring wheeling ...")
		end
	
		local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
		local dirVectorRight = obj:getDirectionVectorRight()	--unit vector dir of ref->left
		local wheeling = -dirVectorUp.y * dirVectorRight.x + dirVectorUp.x * dirVectorRight.y 	--cross product, only care about pitch, no x terms
		local trueWheeling = math.deg(math.asin(wheeling))
	
	
		if trueWheeling > 10 then
			local newPosition = obj:getPosition()
			local distance = math.sqrt( (newPosition.x - lastPosition.x) * (newPosition.x - lastPosition.x) + (newPosition.y - lastPosition.y) * (newPosition.y - lastPosition.y))
			local currentWheelingDistance = electrics.values["currentWheelingDistance"] + distance
			electrics.values["currentWheelingDistance"] = currentWheelingDistance
			lastPosition = obj:getPosition()
		else
			lastPosition = obj:getPosition()
		end
	end
	
	if electrics.values["wheeling_count"] == 0 then
		if wheelingMeasure == 1 then
			wheelingMeasure = 0 
			gui.message("Stop measuring wheeling ...")
		end
	end		
		
end


local function computeKeybInputSteering(dt)
	
	local cur_keyb_steering = electrics.values["steering_input"]
	
	if (cur_keyb_steering > computed_steering) then
		computed_steering = computed_steering + KEYB_STEER_INC
		if computed_steering > 1 then
			computed_steering = 1
		end
	else
		if (cur_keyb_steering < computed_steering) then
			computed_steering = computed_steering - KEYB_STEER_INC
			if computed_steering < -1 then
				computed_steering = -1
			end
		end
	end
	
	if math.abs(computed_steering) < KEYB_STEER_INC then
		computed_steering = 0
	end
	
--	timeSinceLastLog = timeSinceLastLog + dt
--	runningTimer = runningTimer + dt
		  
--	if timeSinceLastLog >= minimumLoggingInterval then
--		timeSinceLastLog = 0
--		print("cur_keyb_steering:" .. cur_keyb_steering .. " prev_keyb_steering:" .. prev_keyb_steering .. " computed_steering:" .. computed_steering)
--	end
	
	
--	prev_keyb_steering = cur_keyb_steering
	
	return computed_steering
end

local function manageSteering(speed, steering, dt)

	local steering_output = 0

	if speed > 10 then

		local targetLean
		if speed > 50 then
			targetLean = -steering*(MIN_LEAN + math.min((speed/MAX_LEAN_SPEED)*(MAX_LEAN - MIN_LEAN), (MAX_LEAN - MIN_LEAN))) --max lean angle is MAX_LEAN degrees
		else
			targetLean = -steering*MIN_LEAN
		end
		local dirVector = obj:getDirectionVector()		--unit vector direction of ref->back
		local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
		local lean = dirVectorUp.x * -dirVector.y + dirVectorUp.y * dirVector.x 	--cross product, only care about roll, no z terms
		
		--pitch is between -1 (down) and 1 (pointing up), with 0 point at the horizon
		--roll is also between -1 and 1, with 0 being level, and -1 & 1 being opposing sides of the horizon 
		
		local trueLean = math.deg(math.asin(lean))
		local errorLean = targetLean - trueLean
		

		--Integral controller
		-- good at low speed	Kp_base = 0.025
		-- good at high speed 	Kp_base = 0.015

		-- good at high speed 	Kd_base = 0.00035
		-- good at low speed 	Kd_base = 0.045
				
		local Kd_adjusted = Kd_base - math.min(speed/10000, 0.01) --100/10000 = 0.01
		local Kp_adjusted = Kp_base - math.min(speed/10000, 0.01) --100/10000 = 0.01
		
		
		-- the P part 
		local PID_P = Kp_adjusted * errorLean   

		-- the I part 
		local PID_I = 0
		if Ki_base > 0 then
			IntegralSumManualSteer = IntegralSumManualSteer + errorLean  -- * dt
			-- integral  saturation
			if math.abs(IntegralSumManualSteer) > 1000000 then
				if IntegralSumManualSteer > 0 then
					IntegralSumManualSteer = 1000000 
				elseif IntegralSumManualSteer < 0 then
					IntegralSumManualSteer = -1000000
				end
			end
			PID_I = Ki_base * IntegralSumManualSteer
		end
	   
		-- the D part 
		local PID_D = (Kd_adjusted * (errorLean - lastErrorLeanManualSteer))  -- / dt
		-- P+I+D
		-- map the PID value to Thrust position value [ -1, 1] , -1 is the max throttle,
		steering_output = PID_P + PID_I + PID_D
		
		lastErrorLeanManualSteer = errorLean
			
		--log('I', "controller.lua", string.format('vec3(%s,%s,%s)', V.x, V.y, V.z))
		--log('I', "controller.lua", "true_lean: " .. tostring(trueLean) .. "steering_out: " .. tostring(steering_output))

		if enableLogSteering == 1  then 
			timeSinceLastLog = timeSinceLastLog + dt
			--runningTimer = runningTimer + dt
		  
			if timeSinceLastLog >= minimumLoggingInterval then
				timeSinceLastLog = 0
				print("wanted angle " .. tostring(targetLean) .. " real angle " .. tostring(trueLean) .. " at " .. tostring(speed))
			 
				 --[[
				 --local pos = obj:getPosition()
				 
				 logLine(
					 tonumber(string.format("%.5f", runningTimer)),
					 tonumber(string.format("%.5f", speed)),
					 tonumber(string.format("%.5f", electrics.values["steering_input"])),
					 tonumber(string.format("%.5f", input.throttle)),
					 tonumber(string.format("%.5f", targetLean)),
					 tonumber(string.format("%.5f", trueLean)),
					 tonumber(string.format("%.5f", errorLean)),
					 tonumber(string.format("%.5f", lastErrorLeanManualSteer)),
					 tonumber(string.format("%.5f", PID_P)),
					 tonumber(string.format("%.5f", PID_D)),				 
					 tonumber(string.format("%.5f", electrics.values["steeringBike"]))
				 )
				 ]]--
			end
		end
		
	else
		steering_output = steering
	end
	
	return steering_output

end



local function updateGFX(dt)

	local speed = getSpeedKmh()
	
	if electrics.values["rpmTacho"] > 10000	then
		electrics.values["rpmWarning"] = 1
	else
		electrics.values["rpmWarning"] = 0
	end

	---------------
	if AutoThrottle == true then
		limitMINSpeed()
	end
	---------------

	----------
	limitMAXSpeed()
	----------
	
	----------
	manageAIRecording(dt)
	----------
	
		
	-------------
	manageWheeling(dt)
	-------------
	
	--------------
	manageRiderParticles()
	--------------


	--------------------
	--manage steering aid
	if 	inputMethod == KEYB_INPUT then
		-- Keyboard/Controller steering
		local steering = computeKeybInputSteering(dt) 
		local steeringOutput = manageSteering(speed, steering, dt)

		electrics.values["steeringBikeKeyb"] = steeringOutput

	else
		-- Steering Wheel steering
		local steering = electrics.values["steering_input"]
		local steeringOutput = manageSteering(speed, steering, dt)

		electrics.values["steeringBikeWheel"] = steeringOutput
	end
	-------------	



	-------------
	--manage pose
	local pose = electrics.values["steering_input"] * 1.2
	if pose > 1 then
		pose=1
	else if pose < -1 then
		pose = -1
		end
	end
   
	electrics.values["driverPose"] = pose
	-------------	
	
	

	-------------	
	--Kickstand
	if kickstand_kicked == 0 then
		if speed > 30 or electrics.values.kickstand == 1 then 
			electrics.values["kickstand_retract"] = 1
			kickstand_kicked = 1
			for _, beam in pairs(v.data.beams) do 
				if beam.breakGroup == "back_stand_holder" then
					obj:breakBeam(beam.cid)
				end 
			end
		end
	end
	
	--------------
	--manage throttle if rider fell
	if brokeBeamsCheck() then
		electrics.values["throttle"] = 0
		electrics.values["steeringBikeKeyb"] = 0
		electrics.values["steeringBikeWheel"] = 0
	end 
	--------------
	
	
	--------------	
	--Crouch
	if electrics.values["crouch_pose_req"] == 0 then
		if electrics.values["clutch_input"] == 1 then
			electrics.values["crouch_pose"] = 1
		else
			electrics.values["crouch_pose"] = 0
		end
	else
		electrics.values["crouch_pose"] = 1
	end
	--------------	


end


M.init      = init
M.updateGFX = updateGFX

return M