local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local onTime = 10000000000000000000000000000000000000000000000000000000000000000000000 -- On time interval in seconds
local offTime = 0 -- Off time interval in seconds
local CELo2lightFlashTimer = 0
local isFlashOn = false

local function updateGFX(dt)
  if electrics.values.ignitionLevel == 2 then
    CELo2lightFlashTimer = CELo2lightFlashTimer + dt
    if isFlashOn and CELo2lightFlashTimer >= onTime then
      isFlashOn = false
      electrics.values.noexhaustCEL = 0
      CELo2lightFlashTimer = CELo2lightFlashTimer - onTime
    elseif not isFlashOn and CELo2lightFlashTimer >= offTime then
      isFlashOn = true
      electrics.values.noexhaustCEL = 1
      CELo2lightFlashTimer = CELo2lightFlashTimer - offTime
    end
  else
    electrics.values.noexhaustCEL = 0 -- Turn off CELo2 light when ignition is not 2
    CELo2lightFlashTimer = 0
    isFlashOn = false
  end
end

local function init()
  M.updateGFX = updateGFX
end

M.init = init
M.updateGFX = updateGFX

return M