local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local onTime = 10000000000000000000000000000000000000000000000000000000000000000000000 -- On time interval in seconds
local offTime = 0 -- Off time interval in seconds
local airwlightFlashTimer = 0
local isFlashOn = false

local function updateGFX(dt)
  if electrics.values.ignitionLevel == 2 then
    airwlightFlashTimer = airwlightFlashTimer + dt
    if isFlashOn and airwlightFlashTimer >= onTime then
      isFlashOn = false
      electrics.values.airwarn = 0
      airwlightFlashTimer = airwlightFlashTimer - onTime
    elseif not isFlashOn and airwlightFlashTimer >= offTime then
      isFlashOn = true
      electrics.values.airwarn = 1
      airwlightFlashTimer = airwlightFlashTimer - offTime
    end
  else
    electrics.values.airwarn = 0 -- Turn off airw light when ignition is not 2
    airwlightFlashTimer = 0
    isFlashOn = false
  end
end

local function init()
  M.updateGFX = updateGFX
end

M.init = init
M.updateGFX = updateGFX

return M