local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local onTime = 10000000000000000000000000000000000000000000000000000000000000000000000 -- On time interval in seconds
local offTime = 0 -- Off time interval in seconds
local abslightFlashTimer = 0
local isFlashOn = false

local function updateGFX(dt)
  if electrics.values.ignitionLevel == 2 then
    abslightFlashTimer = abslightFlashTimer + dt
    if isFlashOn and abslightFlashTimer >= onTime then
      isFlashOn = false
      electrics.values.mustangabslight = 0
      abslightFlashTimer = abslightFlashTimer - onTime
    elseif not isFlashOn and abslightFlashTimer >= offTime then
      isFlashOn = true
      electrics.values.mustangabslight = 1
      abslightFlashTimer = abslightFlashTimer - offTime
    end
  else
    electrics.values.mustangabslight = 0 -- Turn off abs light when ignition is not 2
    abslightFlashTimer = 0
    isFlashOn = false
  end
end

local function init()
  M.updateGFX = updateGFX
end

M.init = init
M.updateGFX = updateGFX

return M