local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local onTime = 0.2 -- On time interval in seconds
local offTime = 3 -- Off time interval in seconds
local theftlightFlashTimer = 0
local isFlashOn = false

local function updateGFX(dt)
  if electrics.values.ignitionLevel == 0 then
    theftlightFlashTimer = theftlightFlashTimer + dt
    if isFlashOn and theftlightFlashTimer >= onTime then
      isFlashOn = false
      electrics.values.mustangtheftlight = 0
      theftlightFlashTimer = theftlightFlashTimer - onTime
    elseif not isFlashOn and theftlightFlashTimer >= offTime then
      isFlashOn = true
      electrics.values.mustangtheftlight = 1
      theftlightFlashTimer = theftlightFlashTimer - offTime
    end
  else
    electrics.values.mustangtheftlight = 0 -- Turn off theft light when ignition is not 0
    theftlightFlashTimer = 0
    isFlashOn = false
  end
end

local function init()
  M.updateGFX = updateGFX
end

M.init = init
M.updateGFX = updateGFX

return M