local M = {}

local function init()
   electrics.values.gaugeneedlesoff = 0
   electrics.values.mustanglighttest = 0
   electrics.values.oilwarn = 0
   electrics.values.waterwarn = 0
   electrics.values.SN95NEYBCsystemscheck = 0
end

local function reset()
   init()
end

local timer = 0 -- initialize the timer variable

local function updateGFX(dt)
   if electrics.values.ignitionLevel == 1 then
      electrics.values.watertemp = 0
      electrics.values.fuel = 0
   end

   if electrics.values.ignitionLevel == 2 then
      if timer < 2 then
         timer = timer + dt -- increment the timer variable by delta time
         electrics.values.mustanglighttestabs = 1 -- turn on guage lights
      else
         electrics.values.mustanglighttestabs = 0 -- turn off guage lights permanently
      end
   else
      timer = 0 -- reset the timer when ignition level is not 2
      electrics.values.mustanglighttestabs = 0
   end


   if electrics.values.ignitionLevel == 2 then
      if timer < 4 then
         timer = timer + dt -- increment the timer variable by delta time
         electrics.values.mustanglighttestmp = 1 -- turn on guage lights
      else
         electrics.values.mustanglighttestmp = 0 -- turn off guage lights permanently
      end
   else
      timer = 0 -- reset the timer when ignition level is not 2
      electrics.values.mustanglighttestmp = 0
   end


   if electrics.values.ignitionLevel == 2 then
      if timer < 6 then
         timer = timer + dt -- increment the timer variable by delta time
         electrics.values.mustanglighttestair = 1 -- turn on guage lights
      else
         electrics.values.mustanglighttestair = 0 -- turn off guage lights permanently
      end
   else
      timer = 0 -- reset the timer when ignition level is not 2
      electrics.values.mustanglighttestair = 0
   end
      

   if electrics.values.oiltemp >= 126.667 then
      electrics.values.oilwarn = 1
   else
      electrics.values.oilwarn = 0
   end

   if electrics.values.watertemp > 105 then
      electrics.values.waterwarn = 1
   else
      electrics.values.waterwarn = 0
   end

   if electrics.values.rpm >= 0 and electrics.values.rpm <= 500 then
      if electrics.values.ignitionLevel >= 0 and electrics.values.ignitionLevel <= 1 then
         electrics.values.SN95NEYBCsystemscheck = 0
      else
         electrics.values.SN95NEYBCsystemscheck = 1
      end
   else
      electrics.values.SN95NEYBCsystemscheck = 0
   end
end

M.onInit = init
M.onReset = init
M.updateGFX = updateGFX

return M