'use strict';
angular.module('beamng.apps')
  .directive('sgrProCamSpeedo', ['$log', '$timeout', '$interval', function ($log, $timeout, $interval) {
    return {
      template:
        '<div style="width: 100%; height: 100%; position: relative;">' +
          '<canvas style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 0;" id="tachometerCanvas"></canvas>' +
          '<object style="width:100%; height:100%; position: absolute; top: 0; left: 0; z-index: 1;" type="image/svg+xml" data="/ui/modules/apps/sgrprocamspeedo/sgrprocamspeedo.svg" id="tachometerSvg"></object>' +
          '<canvas style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 2;" id="circleCanvas"></canvas>' +
        '</div>',
      replace: true,
      restrict: 'EA',
      scope: true,
      link: function (scope, element, attrs) {
        const canvas = element.find('canvas')[0];
        const ctx = canvas.getContext('2d');

        const circleCanvas = element.find('canvas')[1];
        const circleCtx = circleCanvas.getContext('2d');

        canvas.width = 350;
        canvas.height = 350;
        circleCanvas.width = 350;
        circleCanvas.height = 350;

        const streamsList = ['electrics', 'sensors'];
        StreamsManager.add(streamsList);

        const svgObject = element.find('object')[0];
        svgObject.addEventListener('load', function () {
          const svgDoc = svgObject.contentDocument;

          const speedIndicator = svgDoc.getElementById('speed-indicator');
          const speedIndicator1 = svgDoc.getElementById('speed-indicator-shadow');
          const absIndicator = svgDoc.getElementById('abs-indicator');
          const rotationElement = svgDoc.getElementById('rotation'); // Element to display rotation
          const arrowElement = svgDoc.getElementById('arrow'); // Arrow element in the SVG

          let yawDegrees = 0;
          let lastSpeed = 0;

          scope.$on('streamsUpdate', function (event, data) {
            const maxSize = Math.min(canvas.width, canvas.height);
            const maxRadius = maxSize / 2;

            const needleLength = 0.91;
            const needleOffset = maxRadius * .825;

            const speed = UiUnits.speed(data.electrics.airspeed).val;
            const smoothedSpeed = lastSpeed + (speed - lastSpeed) * 0.1; // Smooth transition
            lastSpeed = smoothedSpeed;
            const value = Math.min(smoothedSpeed / 240, 1.0);

            const startAngle = Math.PI / 2;
            const sweepAngle = (5 * Math.PI) / 3;
            const angle = startAngle + sweepAngle * value;

            ctx.clearRect(0, 0, canvas.width, canvas.height);

            // Draw the arc representing the speed
            ctx.beginPath();
            ctx.arc(canvas.width / 2, canvas.height / 2, maxRadius * 0.85, startAngle, angle, false);
            ctx.arc(canvas.width / 2, canvas.height / 2, maxRadius * 0.80, angle, startAngle, true);
            ctx.closePath();
            ctx.fillStyle = '#0a83c2';
            ctx.fill();

            // Draw fixed thinner gray circle rotated 90 degrees to the left
            const fixedStartAngle = Math.PI / 2;
            const fixedEndAngle = Math.PI / 6;
            ctx.beginPath();
            ctx.arc(canvas.width / 2, canvas.height / 2, maxRadius * 0.44, fixedStartAngle, fixedEndAngle, false);
            ctx.lineWidth = maxSize * 0.006;
            ctx.strokeStyle = 'rgba(128, 128, 128, 0.5)';
            ctx.stroke();

            // Clear the circle canvas before drawing
            circleCtx.clearRect(0, 0, circleCanvas.width, circleCanvas.height);

            // Draw small light blue circle with white outline on top of SVG
            const circleX = circleCanvas.width / 2 + needleOffset * Math.cos(angle);
            const circleY = circleCanvas.height / 2 + needleOffset * Math.sin(angle);
            const circleRadius = maxSize * 0.02;

            circleCtx.beginPath();
            circleCtx.arc(circleX, circleY, circleRadius, 0, 2 * Math.PI);
            circleCtx.fillStyle = '#0a83c2';
            circleCtx.fill();
            circleCtx.lineWidth = maxSize * 0.005;
            circleCtx.strokeStyle = 'rgba(255, 255, 255, 1)';
            circleCtx.stroke();

            // Update arrow rotation (compass needle)
            if (data.sensors) {
              yawDegrees = -(data.sensors.yaw * 180 / Math.PI) + 180; // Corrected rotation direction
            }

            if (arrowElement) {
              arrowElement.setAttribute('transform', `rotate(${yawDegrees}, 200, 200)`); // Rotate around center of the SVG element
            }

            // Update rotation element in the SVG
            if (rotationElement) {
              rotationElement.textContent = `${yawDegrees.toFixed(0)}°`;
            }

            // Update the speed indicator text in the SVG
            if (speedIndicator) {
              speedIndicator.textContent = `${Math.round(smoothedSpeed)}`;
              speedIndicator1.textContent = `${Math.round(smoothedSpeed)}`;
            }

            // Update ABS indicator visibility based on electrics data
            if (absIndicator) {
              if (data.electrics.abs) {
                absIndicator.style.display = 'block';
              } else {
                absIndicator.style.display = 'none';
              }
            }
          });

          scope.$on('$destroy', function () {
            StreamsManager.remove(streamsList);
          });
        });
      }
    };
  }]);
