'use strict';
angular.module('beamng.apps')
.directive('sgrProCamGforce', ['$timeout', function ($timeout) {
  return {
    template: `
      <div style="width: 100%; height: 100%; position: relative;">
        <object style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/sgrprocamgforce/sgrprocamgforce.svg"></object>
      </div>
    `,
    replace: true,
    restrict: 'E',
    scope: {},
    link: function (scope, element) {
      let svg;
      const streamsList = ['sensors'];
      StreamsManager.add(streamsList);

      // Wait for the SVG object to load
      element[0].querySelector('object').addEventListener('load', function () {
        $timeout(function () {
          svg = element[0].querySelector('object').contentDocument;
          if (!svg) return;

          // Listen for sensor data updates
          scope.$on('streamsUpdate', function (event, data) {
            if (data.sensors && svg) {
              // Read sensor values for g-force
              const gx2 = data.sensors.gx2 || 0;
              const gy2 = data.sensors.gy2 || 0;
              const gravity = 9.81;
              let normX = gx2 / gravity;
              let normY = gy2 / gravity;
              let magnitude = Math.sqrt(normX * normX + normY * normY);
              // Limit maximum g-force to avoid excessive displacement
              if (magnitude > 3) {
                normX *= 3 / magnitude;
                normY *= 3 / magnitude;
                magnitude = 3;
              }
              // Base position of the orb (adjust these values as needed)
              const baseX = 90;
              const baseY = 75;
              const offsetScale = 25;
              const offsetX = normX * offsetScale;
              const offsetY = -normY * offsetScale;

              // Update the gforce orb position
              const gforceOrb = svg.getElementById('gforceorb');
              if (gforceOrb) {
                gforceOrb.setAttribute('cx', baseX + offsetX);
                gforceOrb.setAttribute('cy', baseY + offsetY);
              }

              // Update the g number in the SVG in x.x format
              const gNumberEl = svg.getElementById('gNumber');
              if (gNumberEl) {
                gNumberEl.textContent = magnitude.toFixed(1);
              }
            }
          });
        }, 500);
      });

      scope.$on('$destroy', function () {
        StreamsManager.remove(streamsList);
      });
    }
  };
}]);
