'use strict';
angular.module('beamng.apps')
.directive('sgrThreestep', ['$timeout', function ($timeout) {
  return {
    template: `<div style="width:100%; height:100%; position:relative;"><object id="svgObj" style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/sgrthreestep/sgrthreestep.svg"></object></div>`,
    replace: true, restrict: 'EA', scope: true,
    link(scope, element) {
      const streamsList = ['engineInfo', 'electrics'];
      StreamsManager.add(streamsList);
      const objEl  = element[0].querySelector('#svgObj');
      let svgDoc = null;
      const driveModes = ['2STEP TARGET','3STEP TARGET','BURNOUT RPM','BUMP TIME','3-STEP MODE','RAMP TIME','PRESET SLOT'];
      let modeIndex = Number(localStorage.getItem('sgr3stepLastMenu')) || 0,
          presetSlot = Number(localStorage.getItem('sgr3stepLastPreset')) || 0;
      const settingsArr = ['COLOR', 'SENSITIVITY', 'RESET PRESETS'];
      let settIndex = 0, inSettings = false, resetPresetCounter = 0, resetMessageTimer = null;
      let threeStepIdx = 0, boostTargetEnabled = false, brakeTargetEnabled = false;
      let lastTwoStep = null, showingSysMsg = false, revertPromise = null;
      let lastTwoStepRPM = '', lastThreeStepRPM = '', currentRPM = 0, burnoutRPM = 3500, bumpTime = 0, rampTime = 0.25, lastTargetSens = 100, targetBoostPsi = 0, liveBoostPsi = 0;
      const bgSchemes = ['#ffffff', '#00ffe7','#00b7ff','#78ff00','#fffb00','#ff9f00','#ff00d4','#ff006b','#9b00ff','#00ff55','#ff4949'];
      let colorIdx = 0, presetStatusMsg = '', presetStatusTimer = null;
      const darker = (hex, k=0.35) => {const n = parseInt(hex.slice(1),16);const r = ((n>>16)&0xff)*(1-k), g = ((n>>8)&0xff)*(1-k), b = (n&0xff)*(1-k);return `rgb(${r|0},${g|0},${b|0})`;};
      function getPresetKey(n){ return `sgr3stepPreset${n}`; }
      function getLuaDefaults(){ return {twoStepRPM:4200,threeStepRPM:5000,burnoutRPM:3500,bumpTime:0.05,rampTime:0.25,sensitivity:15,boostTargetPsi:10,colorIdx:0,threeStepMode:0}; }
      function getCurrentSettings(){ return {twoStepRPM:lastTwoStepRPM,threeStepRPM:lastThreeStepRPM,burnoutRPM,bumpTime,rampTime,sensitivity:lastTargetSens,boostTargetPsi:targetBoostPsi,colorIdx,threeStepMode:threeStepIdx}; }
      function setWorkingSettings(obj){
        if(!obj) return;
        if(typeof obj.twoStepRPM==='number')lastTwoStepRPM=obj.twoStepRPM;
        if(typeof obj.threeStepRPM==='number')lastThreeStepRPM=obj.threeStepRPM;
        if(typeof obj.burnoutRPM==='number')burnoutRPM=obj.burnoutRPM;
        if(typeof obj.bumpTime==='number')bumpTime=obj.bumpTime;
        if(typeof obj.rampTime==='number')rampTime=obj.rampTime;
        if(typeof obj.sensitivity==='number')lastTargetSens=obj.sensitivity;
        if(typeof obj.boostTargetPsi==='number')targetBoostPsi=obj.boostTargetPsi;
        if(typeof obj.colorIdx==='number')colorIdx=obj.colorIdx;
        if(typeof obj.threeStepMode==='number')threeStepIdx=obj.threeStepMode;
        applyColourScheme(); updateDisplays();
        localStorage.setItem('sgr3stepcurrentsettings', JSON.stringify(getCurrentSettings()));
      }
      function saveWorkingSettings(){ localStorage.setItem('sgr3stepcurrentsettings', JSON.stringify(getCurrentSettings())); }
      function loadWorkingSettings(){ let obj=null; try{obj=JSON.parse(localStorage.getItem('sgr3stepcurrentsettings'));}catch(e){} return obj||getLuaDefaults(); }
      function saveCurrentToPreset(n){ if(n<0||n>9)return; localStorage.setItem(getPresetKey(n), JSON.stringify(getCurrentSettings())); localStorage.setItem('sgr3stepLastPreset', n);}
      function loadPreset(n){ if(n<0||n>9)return null; let preset=null; try{preset=JSON.parse(localStorage.getItem(getPresetKey(n)));}catch(e){} return preset;}
      // ---- UPDATED: Send deltas using change... functions (works with default Lua) ----
      function setSettingsFromPreset(preset){
        if(!preset) return;
        // TwoStepRPM (delta)
        if(typeof preset.twoStepRPM === 'number') {
          const delta = preset.twoStepRPM - lastTwoStepRPM;
          if(delta !== 0) bngApi.activeObjectLua(`controller.getControllerSafe("twoStepLaunch").changeTwoStepRPM(${delta})`);
        }
        // ThreeStepRPM (delta)
        if(typeof preset.threeStepRPM === 'number') {
          const delta = preset.threeStepRPM - lastThreeStepRPM;
          if(delta !== 0) bngApi.activeObjectLua(`controller.getControllerSafe("twoStepLaunch").changeThreeStepRPM(${delta})`);
        }
        // BurnoutRPM (delta)
        if(typeof preset.burnoutRPM === 'number') {
          const delta = preset.burnoutRPM - burnoutRPM;
          if(delta !== 0) bngApi.activeObjectLua(`controller.getControllerSafe("twoStepLaunch").changeBurnoutStepRPM(${delta})`);
        }
        // BumpTime (set directly)
        if(typeof preset.bumpTime === 'number')
          bngApi.activeObjectLua(`controller.getControllerSafe("transbrake").changeBumpTime(${preset.bumpTime.toFixed(2)})`);
        // RampTime (set directly)
        if(typeof preset.rampTime === 'number')
          bngApi.activeObjectLua(`controller.getControllerSafe("twoStepLaunch").setRampTime(${preset.rampTime.toFixed(2)})`);
        // Sensitivity (step)
        if(typeof preset.sensitivity === 'number') {
          const delta = preset.sensitivity - lastTargetSens;
          if(delta !== 0) {
            const dir = delta > 0 ? 1 : -1;
            for(let i=0; i<Math.abs(delta); i++) {
              bngApi.activeObjectLua(`controller.getControllerSafe("twoStepLaunch").changeTargetSens(${dir})`);
            }
          }
        }
        // BoostTargetPsi (delta)
        if(typeof preset.boostTargetPsi === 'number') {
          const delta = preset.boostTargetPsi - targetBoostPsi;
          if(delta !== 0) bngApi.activeObjectLua(`controller.getControllerSafe("twoStepLaunch").changeBoostTarget(${delta})`);
        }
        // Color
        if(typeof preset.colorIdx==='number') {
          colorIdx = preset.colorIdx % bgSchemes.length;
          applyColourScheme();
        }
        // StepMode (cycle)
        if(typeof preset.threeStepMode === 'number') {
          let cycles = ((preset.threeStepMode - threeStepIdx) + 4) % 4;
          if(cycles !== 0) {
            for(let i=0; i<Math.abs(cycles); i++) {
              bngApi.activeObjectLua(`controller.getControllerSafe("twoStepLaunch").${cycles>0?"cycleStepModeUp()":"cycleStepModeDown()"}`);
            }
          }
        }
        // Now update UI state to match preset for instant feedback
        setWorkingSettings(preset);
        saveWorkingSettings();
      }
      // ---------------------------------------------------------------------
      function resetAllPresets(){
        const defaults=getLuaDefaults();
        for(let i=0;i<10;i++){localStorage.setItem(getPresetKey(i),JSON.stringify(defaults));}
        localStorage.setItem('sgr3stepLastPreset',0); setWorkingSettings(defaults); presetSlot=0;
      }
      const isThreeStep=()=>threeStepIdx!==0;
      const validMode=i=>!(driveModes[i]==='3STEP TARGET'&&!isThreeStep());
      const stepModeIdx=(idx,dir)=>{const len=driveModes.length;let nxt=(idx+dir+len)%len;while(!validMode(nxt))nxt=(nxt+dir+len)%len;return nxt;};
      const limiterArmed=()=>{const close=(a,b)=>Math.abs(a-b)<300;return(lastTwoStep&&close(currentRPM,lastTwoStepRPM))||(isThreeStep()&&close(currentRPM,lastThreeStepRPM));};
      function applyColourScheme(){
        if(!svgDoc)return;
        const alt=svgDoc.getElementById('altdisplay'),main=svgDoc.getElementById('maindisplay'),bump=svgDoc.getElementById('bumptimedisplay'),bgElm=svgDoc.getElementById('lcdBG');
        if(!alt||!main)return;
        const bg=bgSchemes[colorIdx],fg=darker(bg);
        alt.style.fill=fg;main.style.fill=fg;if(bump)bump.style.fill=fg;if(bgElm)bgElm.setAttribute('fill',bg);
      }
      function getCurrentSettingValue(){
        switch(settingsArr[settIndex]){
          case 'COLOR':return(colorIdx+1)+'/11';
          case 'SENSITIVITY':return lastTargetSens+'%';
          case 'RESET PRESETS':return resetPresetCounter===0?'UP x5':(resetPresetCounter<5?`UP x${resetPresetCounter}/5`:'RESET!');
          default:return'';
        }
      }
      function bumpTimeLabel(val){if(Math.abs(val)<0.00001)return'FAST PWM';if(Math.abs(val+0.01)<0.00001)return'SLOW PWM';return`${val.toFixed(2)}s`;}
      function updateDisplays(){
        if(!svgDoc)return;
        const alt=svgDoc.getElementById('altdisplay'),main=svgDoc.getElementById('maindisplay'),bump=svgDoc.getElementById('bumptimedisplay'),rpmLabel=svgDoc.getElementById('rpmlabel'),saveLabel=svgDoc.getElementById('savelabel');
        if(!alt||!main||showingSysMsg)return;
        if(saveLabel){saveLabel.style.visibility='hidden';saveLabel.style.pointerEvents='none';}
        if(rpmLabel){rpmLabel.textContent='';rpmLabel.style.pointerEvents='';}
        if(inSettings){
          alt.textContent=settingsArr[settIndex]; main.textContent=getCurrentSettingValue();
          if(rpmLabel)rpmLabel.textContent='';if(bump)bump.textContent=bumpTimeLabel(bumpTime); return;
        }
        const mode=driveModes[modeIndex];
        switch(mode){
          case'2STEP TARGET':if(rpmLabel)rpmLabel.textContent='RPM';main.textContent=limiterArmed()?currentRPM:(lastTwoStepRPM??'');break;
          case'3STEP TARGET':if(threeStepIdx===2){if(rpmLabel)rpmLabel.textContent='PSI';main.textContent=(typeof targetBoostPsi==='number')?targetBoostPsi.toFixed(1):(typeof liveBoostPsi==='number'?liveBoostPsi.toFixed(1):'0');}
            else{if(rpmLabel)rpmLabel.textContent='RPM';main.textContent=limiterArmed()?currentRPM:(lastThreeStepRPM??'');}break;
          case'BURNOUT RPM':if(rpmLabel)rpmLabel.textContent='RPM';main.textContent=burnoutRPM;break;
          case'BUMP TIME':{const label=bumpTimeLabel(bumpTime);if(rpmLabel)rpmLabel.textContent=(label==='FAST PWM'||label==='SLOW PWM')?'':'SEC';main.textContent=label;break;}
          case'3-STEP MODE':if(rpmLabel)rpmLabel.textContent='';switch(threeStepIdx){case 0:main.textContent='OFF';break;case 1:main.textContent='RPM';break;case 2:main.textContent='BOOST';break;case 3:main.textContent='BRAKE';break;}break;
          case'RAMP TIME':if(rpmLabel)rpmLabel.textContent='SEC';main.textContent=`${rampTime.toFixed(2)}s`;break;
          case'PRESET SLOT':
            if(rpmLabel){rpmLabel.textContent='LOAD';rpmLabel.style.cursor='pointer';rpmLabel.style.pointerEvents='';}
            if(saveLabel){saveLabel.style.visibility='visible';saveLabel.style.pointerEvents='';saveLabel.style.cursor='pointer';}
            alt.textContent='PRESET SLOT';
            if(presetStatusMsg){main.textContent=presetStatusMsg;}else{main.textContent=`${presetSlot+1}/10`;}
            if(bump)bump.textContent='';return;
        }
        if(mode!=='PRESET SLOT'){alt.textContent=mode;}
        if(bump)bump.textContent=bumpTimeLabel(bumpTime);
        if(svgDoc){
          const gearBtn=svgDoc.getElementById('btn-gear');
          if(gearBtn){
            if(mode==='PRESET SLOT'){gearBtn.style.pointerEvents='none';gearBtn.style.opacity='0.4';}
            else{gearBtn.style.pointerEvents='';gearBtn.style.opacity='';}
          }
        }
      }
      objEl.addEventListener('load',function(){
        svgDoc=this.contentDocument;if(!svgDoc)return;
        const q=id=>svgDoc.getElementById(id);
        const btns={left:q('btn-left'),right:q('btn-right'),up:q('btn-up'),down:q('btn-down'),onoff:q('onoff'),gear:q('btn-gear')};
        const rpmLabel=q('rpmlabel'),saveLabel=q('savelabel');
        if(rpmLabel){
          rpmLabel.addEventListener('click',function(){
            if(driveModes[modeIndex]==='PRESET SLOT'){
              const preset=loadPreset(presetSlot); if(preset){ setSettingsFromPreset(preset); presetStatusMsg='LOADED'; updateDisplays();
                if(presetStatusTimer)$timeout.cancel(presetStatusTimer); presetStatusTimer=$timeout(()=>{presetStatusMsg='';updateDisplays();},1500);}
            }
          });
        }
        if(saveLabel){
          saveLabel.addEventListener('click',function(){
            if(driveModes[modeIndex]==='PRESET SLOT'){
              saveCurrentToPreset(presetSlot); presetStatusMsg='SAVED'; updateDisplays();
              if(presetStatusTimer)$timeout.cancel(presetStatusTimer); presetStatusTimer=$timeout(()=>{presetStatusMsg='';updateDisplays();},1500);
            }
          });
        }
        btns.left?.addEventListener('click',()=>{
          if(inSettings){settIndex=(settIndex-1+settingsArr.length)%settingsArr.length;resetPresetCounter=0;}
          else{modeIndex=stepModeIdx(modeIndex,-1);localStorage.setItem('sgr3stepLastMenu', modeIndex);}
          updateDisplays();
        });
        btns.right?.addEventListener('click',()=>{
          if(inSettings){settIndex=(settIndex+1)%settingsArr.length;resetPresetCounter=0;}
          else{modeIndex=stepModeIdx(modeIndex,1);localStorage.setItem('sgr3stepLastMenu', modeIndex);}
          updateDisplays();
        });
        btns.up?.addEventListener('click',()=>{
          if(inSettings){
            if(settingsArr[settIndex]==='SENSITIVITY'){
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").changeTargetSens(1)');
              lastTargetSens+=1;
            }else if(settingsArr[settIndex]==='COLOR'){
              colorIdx=(colorIdx+1)%bgSchemes.length;applyColourScheme();
            }else if(settingsArr[settIndex]==='RESET PRESETS'){
              resetPresetCounter++; if(resetPresetCounter>=5){
                resetAllPresets(); resetPresetCounter=0;
                const alt=svgDoc?.getElementById('altdisplay'),main=svgDoc?.getElementById('maindisplay');
                if(alt&&main){alt.textContent='RESET PRESETS';main.textContent='DONE!';}
                if(resetMessageTimer)$timeout.cancel(resetMessageTimer);
                resetMessageTimer=$timeout(updateDisplays,1500); return;
              }
            }
            saveWorkingSettings();
          }else{adjustDriveValue(+1);}
          updateDisplays();
        });
        btns.down?.addEventListener('click',()=>{
          if(inSettings){
            if(settingsArr[settIndex]==='SENSITIVITY'){
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").changeTargetSens(-1)');
              lastTargetSens-=1;
            }else if(settingsArr[settIndex]==='COLOR'){
              colorIdx=(colorIdx-1+bgSchemes.length)%bgSchemes.length;applyColourScheme();
            }
            resetPresetCounter=0; saveWorkingSettings();
          }else{adjustDriveValue(-1);}
          updateDisplays();
        });
        function adjustDriveValue(dir){
          const tsApi='controller.getControllerSafe("twoStepLaunch").',tbApi='controller.getControllerSafe("transbrake").',mode=driveModes[modeIndex];
          if(mode==='2STEP TARGET'){lastTwoStepRPM+=dir*100;bngApi.activeObjectLua(`${tsApi}changeTwoStepRPM(${dir*100})`);}
          else if(mode==='3STEP TARGET'){if(threeStepIdx===2){targetBoostPsi+=dir;bngApi.activeObjectLua(`${tsApi}changeBoostTarget(${dir})`);}
            else{lastThreeStepRPM+=dir*100;bngApi.activeObjectLua(`${tsApi}changeThreeStepRPM(${dir*100})`);}}
          else if(mode==='BURNOUT RPM'){burnoutRPM+=dir*100;bngApi.activeObjectLua(`${tsApi}changeBurnoutStepRPM(${dir*100})`);}
          else if(mode==='BUMP TIME'){bumpTime=Math.max(-0.01,bumpTime+dir*0.01);bngApi.activeObjectLua(`${tbApi}changeBumpTime(${bumpTime.toFixed(2)})`);}
          else if(mode==='3-STEP MODE'){
            if(dir>0){threeStepIdx=(threeStepIdx+1)%4;bngApi.activeObjectLua(`${tsApi}cycleStepModeUp()`);}
            else{threeStepIdx=(threeStepIdx+3)%4;bngApi.activeObjectLua(`${tsApi}cycleStepModeDown()`);}
          }else if(mode==='RAMP TIME'){rampTime=Math.max(0.05,rampTime+dir*0.05);bngApi.activeObjectLua(`${tsApi}setRampTime(${rampTime.toFixed(2)})`);}
          else if(mode==='PRESET SLOT'){presetSlot=(presetSlot+dir+10)%10;localStorage.setItem('sgr3stepLastPreset',presetSlot);updateDisplays();return;}
          saveWorkingSettings();
        }
        btns.onoff?.addEventListener('mousedown',()=>bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").toggleTwoStep()'));
        btns.gear?.addEventListener('click',()=>{
          const mode=driveModes[modeIndex];
          if(mode!=='PRESET SLOT'){inSettings=!inSettings;resetPresetCounter=0;updateDisplays();}
        });
        Object.values(btns).forEach(b=>{if(b)b.style.cursor='pointer';});
        applyColourScheme(); setWorkingSettings(loadWorkingSettings()); updateDisplays();
      });
      scope.$on('streamsUpdate',(evt,streams)=>{
        if(!svgDoc)return;
        if(streams.engineInfo){currentRPM=Math.max(0,Math.min(99999,Math.floor(streams.engineInfo[4])));}
        const twoStep=streams.electrics?.twoStep,linelock=streams.electrics?.linelock===1;
        if(typeof streams.electrics?.bumpTime==='number'){bumpTime=streams.electrics.bumpTime;}
        if(typeof streams.electrics?.rampTime==='number'){rampTime=streams.electrics.rampTime;}
        if(lastTwoStep!==null&&twoStep!==lastTwoStep){
          if(twoStep&&modeIndex!==2&&!linelock){
            showingSysMsg=true;
            const alt=svgDoc.getElementById('altdisplay');
            if(alt)alt.textContent='SYSTEM ON';
            if(revertPromise)$timeout.cancel(revertPromise);
            revertPromise=$timeout(()=>{showingSysMsg=false;updateDisplays();},3000);
          }else if(!twoStep&&modeIndex!==2&&!linelock){
            const alt=svgDoc.getElementById('altdisplay'); if(alt)alt.textContent='SYSTEM OFF';
          }
        }
        lastTwoStep=twoStep;
        lastTwoStepRPM=streams.electrics?.twoStepRPM??lastTwoStepRPM;
        lastThreeStepRPM=streams.electrics?.threeStepRPM??lastThreeStepRPM;
        if(typeof streams.electrics?.targetSens==='number')lastTargetSens=Math.round(streams.electrics.targetSens);
        if(typeof streams.electrics?.boostTargetPsi==='number')targetBoostPsi=streams.electrics.boostTargetPsi; else targetBoostPsi=0;
        if(typeof streams.electrics?.boost==='number')liveBoostPsi=streams.electrics.boost; else liveBoostPsi=0;
        const external3=!!streams.electrics?.isThreeStepMode,externalBoost=!!streams.electrics?.boostTarget,externalBrake=!!streams.electrics?.brakeTarget;
        if(!external3){threeStepIdx=0;boostTargetEnabled=false;brakeTargetEnabled=false;}
        else{if(externalBoost){threeStepIdx=2;boostTargetEnabled=true;brakeTargetEnabled=false;}
          else if(externalBrake){threeStepIdx=3;brakeTargetEnabled=true;boostTargetEnabled=false;}
          else{threeStepIdx=1;boostTargetEnabled=false;brakeTargetEnabled=false;}
        }
        updateDisplays();
      });
      scope.$on('$destroy',()=>{
        StreamsManager.remove(streamsList);
        if(revertPromise)$timeout.cancel(revertPromise);
        if(resetMessageTimer)$timeout.cancel(resetMessageTimer);
        if(presetStatusTimer)$timeout.cancel(presetStatusTimer);
      });
    }
  };
}]);
