local M = {}
M.type = "auxiliary"
local rpm2av = 0.104719755
local engine, electricsName = nil, "twoStep"
local stepModes = { "off", "rpm", "boost", "brake" }
local currentStepMode = 1
local selectedSystem = "2step"
local boostTargetEnabled, brakeTargetEnabled = false, false
local idleRPM, sensitivity = 800, 15
local linelockAutoOffLatched = false
local boostTargetPsi, boostDeadband, lastBoost = 10, 0.3, 0

local two = { state="deactivated", rpm=0, av=0 }
local function disp2()
  local tag = two.state=="armed" and "Armed" or two.state~="deactivated" and "Active" or "Inactive"
  guihooks.message(string.format("2-Step: %s (%d RPM)", tag, two.rpm),2,"vehicle.twoStep.status")
end
local function setTwo(on)
  if not engine then return end
  two.state = on and "idle" or "deactivated"
  if not on then engine:resetTempRevLimiter() end
  disp2()
end
local function setTwoRPM(r) two.rpm = math.max(idleRPM, r) two.av = two.rpm * rpm2av disp2() end
local function changeTwoRPM(d) setTwoRPM(two.rpm + d) end
local function updateTwo(dt)
  if two.state=="idle" then
    local kbd = input.state.throttle.filter==FILTER_KBD or input.state.throttle.filter==FILTER_KBD2
    local okS = (kbd and electrics.values.wheelspeed<=2) or (electrics.values.wheelspeed<=0.5)
    local okT = (kbd and electrics.values.throttle>=0.1) or (electrics.values.throttle>=0.3)
    local hold = (kbd and electrics.values.parkingbrake>=0.2 or electrics.values.parkingbrake>=0.3)
      or (kbd and electrics.values.brake>=0.2 or electrics.values.brake>=0.3)
      or (kbd and electrics.values.clutch>=0.2 or electrics.values.clutch>=0.3)
      or (electrics.values.transbrake or false)
    if okS and okT and hold then
      two.state = "armed"
      disp2()
    end
  elseif two.state=="armed" then
    engine:setTempRevLimiter(two.av)
    local quit = electrics.values.throttle<=0
      or electrics.values.wheelspeed>=0.5
      or ((electrics.values.transbrake==false) and electrics.values.brake<=0.1 and electrics.values.parkingbrake<=0.1)
      or ((electrics.values.transbrake==nil) and electrics.values.brake<=0.1 and electrics.values.parkingbrake<=0.1 and electrics.values.clutch<=0.1)
    if quit then
      engine:resetTempRevLimiter()
      two.state = "idle"
      disp2()
    end
  end
  electrics.values[electricsName] = (two.state~="deactivated")
  electrics.values.twoStepRPM = two.rpm
  electrics.values.isThreeStepMode = false
end
local function resetTwo() if engine then engine:resetTempRevLimiter() end two.state = "idle" end
local function initTwo(jd)
  electricsName = jd.electricsName or "twoStep"
  engine = powertrain.getDevice(jd.engineName or "mainEngine")
  two.state = "deactivated"
  setTwoRPM(jd.twoStepRpm or jd.rpmLimit or 4200)
end

local three = { state="idle", highT=0, cur=0, rampT=0.25, armedT=0, lowering=false, idleCD=0, boostActive=true, metLowRPM=false, stickyCooldown=1 }
local function disp3()
  local t = three
  local msg
  if t.state=="deactivated" then msg = "3-Step: Off (Adjust in 3-Step UI App)"
  elseif t.state=="idle" then msg = "3-Step: Active (Adjust in 3-Step UI App)"
  else msg = "3-Step: Armed (Adjust in 3-Step UI App)" end
  guihooks.message(msg,2,"vehicle.twoStep.status")
end
local function setThree(on)
  if not engine then return end
  three.state = on and "idle" or "deactivated"
  if not on then engine:resetTempRevLimiter() end
  disp3()
end
local function changeThreeRPM(d)
  if three.state=="idle" then
    three.highT = math.max(idleRPM, three.highT + d)
    three.cur = three.highT
    disp3()
  else
    disp3()
  end
end
local function changeBoostTarget(d) boostTargetPsi = math.max(0, boostTargetPsi + d) end
M.changeBoostTarget = changeBoostTarget
local function getBrakeTargetRPM()
  if (electrics.values.brake or 0) > 0.2 then
    return three.highT
  elseif (electrics.values.transbrake or false)
      or (electrics.values.handbrake or 0) > 0.2
      or (electrics.values.clutch or 0) > 0.2 then
    return two.rpm
  else
    return nil
  end
end
local function updateThree(dt)
  local t = three
  local boost = electrics.values.boost or 0
  lastBoost = boost
  if t.state=="idle" then
    t.idleCD = t.idleCD + dt
    if t.idleCD >= t.stickyCooldown then t.metLowRPM = false end
    local kbd = input.state.throttle.filter==FILTER_KBD or input.state.throttle.filter==FILTER_KBD2
    local okS = (kbd and electrics.values.wheelspeed<=2) or (electrics.values.wheelspeed<=0.5)
    local okT = (kbd and electrics.values.throttle>=0.1) or (electrics.values.throttle>=0.3)
    local hold = (kbd and electrics.values.parkingbrake>=0.2 or electrics.values.parkingbrake>=0.3)
      or (kbd and electrics.values.brake>=0.2 or electrics.values.brake>=0.3)
      or (kbd and electrics.values.clutch>=0.2 or electrics.values.clutch>=0.3)
      or (electrics.values.transbrake or false)
    if okS and okT and hold then
      t.state = "armed"
      t.armedT = 0
      t.lowering = false
      t.idleCD = 0
      if t.metLowRPM then t.cur = two.rpm else t.cur = t.highT end
      t.boostActive = boostTargetEnabled and true or false
      disp3()
    end
  elseif t.state=="armed" then
    if boostTargetEnabled then
      engine:resetTempRevLimiter()
      if t.boostActive then
        if boost >= boostTargetPsi - boostDeadband then
          t.boostActive = false
          t.cur = two.rpm
          engine:setTempRevLimiter(t.cur * rpm2av)
          disp3()
        end
      end
      if not t.boostActive then
        t.cur = two.rpm
        engine:setTempRevLimiter(t.cur * rpm2av)
        t.metLowRPM = true
      end
    elseif brakeTargetEnabled then
      local target = getBrakeTargetRPM()
      if target then
        t.cur = target
        engine:setTempRevLimiter(t.cur * rpm2av)
        if target == two.rpm then t.metLowRPM = true end
      else
        engine:resetTempRevLimiter()
      end
    else
      local threshold = t.highT * (sensitivity * 0.01)
      if electrics.values.rpm and electrics.values.rpm >= (t.highT - threshold) then t.armedT = t.armedT + dt else t.armedT = 0 end
      if not t.lowering and t.armedT > 1 then t.lowering = true end
      if t.lowering then
        local target2 = two.rpm
        local span = target2 - t.highT
        local rate = math.abs(span) / t.rampT
        local dir = span >= 0 and 1 or -1
        t.cur = t.cur + dir * rate * dt
        if (dir == 1 and t.cur >= target2) or (dir == -1 and t.cur <= target2) then t.cur = target2 end
        t.cur = math.max(t.cur, idleRPM)
        disp3()
        if t.cur == two.rpm then t.metLowRPM = true end
      end
      engine:setTempRevLimiter(t.cur * rpm2av)
    end
    local quit = electrics.values.throttle<=0
      or electrics.values.wheelspeed>=0.5
      or ((electrics.values.transbrake==false) and electrics.values.brake<=0.1 and electrics.values.parkingbrake<=0.1)
      or ((electrics.values.transbrake==nil) and electrics.values.brake<=0.1 and electrics.values.parkingbrake<=0.1 and electrics.values.clutch<=0.1)
    if quit then
      engine:resetTempRevLimiter()
      t.state = "idle"; t.cur = t.highT; t.lowering = false; t.boostActive = boostTargetEnabled and true or false
      t.idleCD = 0
      disp3()
    end
  end
  electrics.values[electricsName] = (three.state~="deactivated")
  electrics.values.threeStepRPM = math.floor(three.cur + 0.5)
  electrics.values.isThreeStepMode = (selectedSystem ~= "2step")
  electrics.values.twoStepRPM = two.rpm
  electrics.values.boostTarget = boostTargetEnabled
  electrics.values.brakeTarget = brakeTargetEnabled
  electrics.values.currentStepMode = stepModes[currentStepMode]
  electrics.values.boostTargetPsi = boostTargetPsi
  electrics.values.currentBoost = lastBoost
  electrics.values.rampTime = three.rampT
end
local function initThree(jd)
  engine = powertrain.getDevice(jd.engineName or "mainEngine")
  idleRPM = engine and (engine.idlerpm or idleRPM) or idleRPM
  electricsName = jd.electricsName or "twoStep"
  three.highT = jd.threeStepRpm or 5000
  three.cur = three.highT
  three.rampT = tonumber(jd.dropRpm) or 0.25
  three.state = "idle"
  boostTargetPsi = 10
  three.metLowRPM = false
  three.idleCD = 0
  setTwoRPM(jd.twoStepRpm or math.max(idleRPM, three.highT - 600))
  disp3()
end
local function resetThree()
  if engine then engine:resetTempRevLimiter() end
  three.state = "idle"
  three.metLowRPM = false
  three.idleCD = 0
end

local burnout = { state = "inactive", rpm = 3500 }
local function updateBurnout()
  if electrics.values.linelock == 1  then
    if burnout.state == "inactive" then
      burnout.state = "active"
      engine:setTempRevLimiter(burnout.rpm * rpm2av)
    end
    -- Keep limiter on as long as linelock is held
    engine:setTempRevLimiter(burnout.rpm * rpm2av)
  else
    if burnout.state == "active" then
      burnout.state = "inactive"
      engine:resetTempRevLimiter()
    end
  end
  electrics.values.burnoutState = burnout.state
  electrics.values.burnoutRPM = burnout.rpm
end
local function changeBurnoutStepRPM(d) burnout.rpm = math.max(idleRPM, burnout.rpm + d) end
M.changeBurnoutStepRPM = changeBurnoutStepRPM
local function changeTargetSens(d) sensitivity = math.min(25, math.max(5, sensitivity + d)) end
M.changeTargetSens = changeTargetSens
local function setStepMode(idx)
  currentStepMode = idx
  local mode = stepModes[currentStepMode]
  boostTargetEnabled = false
  brakeTargetEnabled = false
  if mode == "off" then
    selectedSystem = "2step"
    setThree(false)
  elseif mode == "rpm" then
    selectedSystem = "3step"
    setThree(true)
  elseif mode == "boost" then
    selectedSystem = "3step"
    boostTargetEnabled = true
    setThree(true)
  elseif mode == "brake" then
    selectedSystem = "3step"
    brakeTargetEnabled = true
    setThree(true)
  end
end
local function cycleStepMode(up)
  local newIdx = currentStepMode + (up and 1 or -1)
  if newIdx > #stepModes then newIdx = 1 elseif newIdx < 1 then newIdx = #stepModes end
  setStepMode(newIdx)
end
local function updateGFX(dt)
  if electrics.values.transbrake and electrics.values.linelock == 1 then
    if not linelockAutoOffLatched then
      for _, v in pairs(controller.getControllersByType('lineLock')) do
        if v.toggleLineLock then v.toggleLineLock() end
      end
      linelockAutoOffLatched = true
    end
  else linelockAutoOffLatched = false end

  -- Activate burnout limiter any time linelock is engaged, regardless of brake
  if electrics.values.linelock == 1 then
    engine:setTempRevLimiter(burnout.rpm * rpm2av)
  else
    if selectedSystem=="2step" then updateTwo(dt) else updateThree(dt) end
  end
  updateBurnout()
  electrics.values.targetSens = sensitivity
end
local function togglePressed()
  if selectedSystem=="2step" then setStepMode(2) else setStepMode(1) end
end
M.toggleTwoStepMode = togglePressed
local function setRampTime(t) three.rampT = math.max(0.05, tonumber(t) or 0.25) end
M.setRampTime = setRampTime
local function init(jd)
  initTwo(jd)
  initThree(jd)
  setStepMode(1)
end
local function reset(jd)
  if selectedSystem=="2step" then resetTwo() else resetThree(jd) end
end
local function setParams(p)
  if p.isEnabled~=nil then
    if p.isEnabled and selectedSystem=="2step" then setTwo(true)
    elseif not p.isEnabled and selectedSystem=="2step" then setTwo(false) end
    if p.isEnabled and selectedSystem~="2step" then setThree(true)
    elseif not p.isEnabled and selectedSystem~="2step" then setThree(false) end
  end
  if p.launchRPM~=nil then
    if selectedSystem=="2step" then setTwoRPM(p.launchRPM)
    else changeThreeRPM(p.launchRPM - three.highT) end
  end
end
M.init = init
M.reset = reset
M.updateGFX = updateGFX
M.toggleTwoStep = togglePressed
M.toggleTwoStepMode = togglePressed
M.cycleStepModeUp = function() cycleStepMode(true) end
M.cycleStepModeDown = function() cycleStepMode(false) end
M.changeTwoStepRPM = changeTwoRPM
M.changeThreeStepRPM = changeThreeRPM
M.changeBurnoutStepRPM = changeBurnoutStepRPM
M.changeTargetSens = changeTargetSens
M.changeBoostTarget = changeBoostTarget
M.setParameters = setParams
M.setRampTime = setRampTime
return M
