local M = {}
M.type = "auxiliary"
print"Gose TransbrakeSystem"
local gearbox, electricsName = nil, nil
local bumpTimeDefault, bumpTime, bumpTimer = 0.1, 0.1, 0
local isPulseMode, pwmState, pwmTimer, pwmOnTime, pwmOffTime = false, false, 0, 0.01, 0.01
local isHeld, isTransbrakeHeld = false, false
local hasBuiltPie = false

local function displayStatus()
  local state = gearbox and (gearbox.lockCoef == 0) and "enabled" or "disabled"
  guihooks.message("Transbrake is " .. state, 2, "vehicle.transbrake.status")
end

local function setTransbrake(value)
  if gearbox then gearbox:setLock(value) displayStatus() end
end

local function holdPressed()
  isHeld = true; isTransbrakeHeld = true
  if bumpTimer <= 0 and not isPulseMode then setTransbrake(true) end
end

local function holdReleased()
  isHeld = false; isTransbrakeHeld = false
  setTransbrake(false)
end

local function toggleTransbrake()
  if gearbox then
    if gearbox.lockCoef == 0 then holdReleased()
    else holdPressed() end
  end
end

local function bumpTransbrake()
  if gearbox and isHeld and bumpTimer <= 0 and not isPulseMode then
    if bumpTime == 0 then
      isPulseMode = true; pwmState = false; pwmTimer = 0; pwmOnTime = 0.01; pwmOffTime = 0.01; setTransbrake(false)
    elseif bumpTime == -0.01 then
      isPulseMode = true; pwmState = false; pwmTimer = 0; pwmOnTime = 0.02; pwmOffTime = 0.005; setTransbrake(false)
    else
      setTransbrake(false); bumpTimer = bumpTime
    end
  end
end

local function changeBumpTime(newTime)
  bumpTime = newTime
  electrics.values.bumpTime = bumpTime
end

local function bumpReleased()
  if isPulseMode then
    isPulseMode = false; pwmState = false; pwmTimer = 0; isTransbrakeHeld = isHeld
    setTransbrake(isHeld)
  end
end

local function updateGFX(dt)
  if isPulseMode then
    if not isHeld then
      isPulseMode = false; pwmState = false; pwmTimer = 0; isTransbrakeHeld = isHeld
      setTransbrake(isHeld)
    else
      pwmTimer = pwmTimer + dt
      if pwmState then
        if pwmTimer >= pwmOnTime then pwmTimer = pwmTimer - pwmOnTime; pwmState = false; setTransbrake(false) end
      else
        if pwmTimer >= pwmOffTime then pwmTimer = pwmTimer - pwmOffTime; pwmState = true; setTransbrake(true) end
      end
    end
  elseif bumpTimer > 0 then
    bumpTimer = bumpTimer - dt
    if bumpTimer <= 0 then if isHeld then setTransbrake(true) end bumpTimer = 0 end
  end
  if electricsName then electrics.values[electricsName] = isTransbrakeHeld or isPulseMode end
end

local function init(jbeamData)
  local gearboxName = jbeamData.gearboxName or "gearbox"
  electricsName = jbeamData.electricsName or "transbrake"
  gearbox = powertrain.getDevice(gearboxName)
  M.updateGFX = gearbox and updateGFX or nop
  electrics.values.bumpTime = bumpTime
  if not hasBuiltPie and gearbox then
    core_quickAccess.addEntry({
      level = "/root/playerVehicle/vehicleFeatures/",
      generator = function(entries)
        table.insert(entries, {
          title = "Transbrake", priority = 40, icon = "powerOnOff", uniqueID = "transbrakeToggle",
          onSelect = function() M.toggleTransbrake() return { "reload" } end,
        })
      end,
    })
    hasBuiltPie = true
  end
end

local function onGameplayEvent(event, ...)
  local splits = split(event, ":")
  if splits[1] == "controller" and splits[2] == M.typeName then
    local params = {...}
    if params[1] == "setTransbrake" then
      if params[2] then holdPressed() else holdReleased() end
    end
  end
end

M.init = init
M.updateGFX = nop
M.toggleTransbrake = toggleTransbrake
M.setTransbrake = setTransbrake
M.holdPressed = holdPressed
M.holdReleased = holdReleased
M.bumpTransbrake = bumpTransbrake
M.bumpReleased = bumpReleased
M.changeBumpTime = changeBumpTime
M.onGameplayEvent = onGameplayEvent

return M
