'use strict';
angular.module('beamng.apps')
.directive('sgrHolleyprodash', ['$log', '$timeout', function ($log, $timeout) {
  return {
    template:
      `<div style="width: 100%; height: 100%; position: relative;">
        <object style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/SGRHolleyprodash/SGRHolleyprodash.svg"></object>
      </div>`,
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      let svg;
      let lastRPMUpdateTime = 0;
      let lastMPHUpdateTime = 0;
      let lastGPSUpdateTime = 0;
      let lastWaterTempUpdateTime = 0;
      let lastOilTempUpdateTime = 0;
      let lastTransOilTempUpdateTime = 0;
      let lastFuelLevelUpdateTime = 0;
      let lastBoostPressureUpdateTime = 0;
      let lastAFRUpdateTime = 0;
      let lastFuelPressUpdateTime = 0;
      let lastVoltsUpdateTime = 0;
      let lastTimingUpdateTime = 0;
      let uiBlackout, uiSplashScreen, uiLoadingBarOutline, uiLoadingBar;
      let previousIgnitionLevel = null;
      let loadingTimeoutPromise = null;
      let currentOilPressure = 65;
      let currentVoltage = 14.7;
      const updateInterval = 50;
      let maxRPM = 8000;
      const minRPM = 1000;
      const voltageSmoothFactor = 0.05;
      const baseOpacity = 0.5;
      const afrDecelValue = 11.2;
      const afrAccelValue = 12.8;
      const afrIdleValue = 14.5;
      const afrThreshold = 11.3;
      const idleFuelPressure = 70;
      const maxRPMIncrease = 5;
      const boostMultiplier = 1;
      const fuelPressThreshold = 40;
      const voltLowRPM = 13.2;
      const voltIdle = 14.7;
      const voltMax = 15.0;
      const idleTimingMin = 11;
      const idleTimingMax = 13;
      const throttleTimingMin = 29;
      const throttleTimingMax = 31;
      const oilTempThresholdF = 250;
      const waterTempThresholdF = 250;
      const fuelLevelThreshold = 3.0;
      const oilPressThreshold = 40;
      const streamsList = ['electrics', 'engineInfo', 'engineThermalData', 'sensors'];
      StreamsManager.add(streamsList);
      function getRandomAFR(base, variation) {
        return (base + (Math.random() * variation - variation / 2)).toFixed(2);
      }
      function getRandomIntInRange(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
      }
      function smoothTransition(target, current, smoothFactor) {
        return current + (target - current) * smoothFactor;
      }
      function showHideRect(rectId, shouldShow) {
        if (!svg) return;
        const rect = svg.getElementById(rectId);
        if (!rect) return;
        rect.style.display = shouldShow ? 'block' : 'none';
      }
      function calculateOilPressure(tempCelsius, rpm, oilMass, gForce, starvingXY, starvingZ, maxSafeG) {
        let targetPressure;
        if (oilMass < 1.0 || rpm <= 0 || starvingXY > 0 || starvingZ > 0 || gForce > maxSafeG) {
          targetPressure = 0;
        } else {
          const tempLow = 15.6;
          const tempHigh = 165.6;
          let basePressure;
          if (tempCelsius <= tempLow) {
            basePressure = 60;
          } else if (tempCelsius >= tempHigh) {
            basePressure = 0;
          } else {
            basePressure = 60 * (1 - (tempCelsius - tempLow) / (tempHigh - tempLow));
          }
          let rpmFactor = Math.min(rpm / 3000, 1);
          let pressure = basePressure + (25 * rpmFactor);
          let gForceReduction = Math.min(gForce / 2, 15);
          pressure -= gForceReduction;
          targetPressure = Math.max(0, Math.min(pressure, 200));
        }
        return targetPressure;
      }
      function updateOilPressure(tempCelsius, rpm, oilMass, gForce, starvingXY, starvingZ, maxSafeG) {
        const oilPressElement = svg.getElementById('oilPressval');
        if (!oilPressElement) return;
        let targetPressure = calculateOilPressure(tempCelsius, rpm, oilMass, gForce, starvingXY, starvingZ, maxSafeG);
        currentOilPressure = smoothTransition(targetPressure, currentOilPressure, 0.02);
        const roundedPressure = Math.round(currentOilPressure);
        oilPressElement.textContent = roundedPressure.toString();
        showHideRect('oilPressRect', (roundedPressure < oilPressThreshold));
      }
      function injectGlowFilter() {
        const defs = svg.querySelector('defs') || document.createElementNS("http://www.w3.org/2000/svg", "defs");
        const glowFilter = document.createElementNS("http://www.w3.org/2000/svg", "filter");
        glowFilter.setAttribute("id", "glowFilter");
        const gaussianBlur = document.createElementNS("http://www.w3.org/2000/svg", "feGaussianBlur");
        gaussianBlur.setAttribute("in", "SourceGraphic");
        gaussianBlur.setAttribute("stdDeviation", "15");
        gaussianBlur.setAttribute("result", "blur");
        const feMerge = document.createElementNS("http://www.w3.org/2000/svg", "feMerge");
        const feMergeNode1 = document.createElementNS("http://www.w3.org/2000/svg", "feMergeNode");
        feMergeNode1.setAttribute("in", "blur");
        const feMergeNode2 = document.createElementNS("http://www.w3.org/2000/svg", "feMergeNode");
        feMergeNode2.setAttribute("in", "SourceGraphic");
        feMerge.appendChild(feMergeNode1);
        feMerge.appendChild(feMergeNode2);
        glowFilter.appendChild(gaussianBlur);
        glowFilter.appendChild(feMerge);
        defs.appendChild(glowFilter);
        const styleElement = document.createElement('style');
        styleElement.textContent = `
          @font-face {
            font-family: 'DS-Digital';
            src: url('/ui/common/roboto-regular.ttf') format('truetype');
          }
          text {
            font-family: 'DS-Digital', sans-serif;
          }
        `;
        defs.appendChild(styleElement);
        if (!svg.querySelector('defs')) {
          svg.querySelector('svg').insertBefore(defs, svg.querySelector('svg').firstChild);
        }
      }
      function updateOrbs(rpm) {
        const numOrbs = 15;
        let maxLitOrbs = 0;
        if (rpm >= minRPM) {
          const effectiveRPM = Math.min(rpm, maxRPM);
          const rpmRange = maxRPM - minRPM;
          const rpmAboveMin = effectiveRPM - minRPM;
          const proportion = rpmRange > 0 ? rpmAboveMin / rpmRange : 1;
          maxLitOrbs = Math.floor(proportion * numOrbs);
          maxLitOrbs = Math.max(1, maxLitOrbs);
        }
        for (let i = 1; i <= numOrbs; i++) {
          const orb = svg.getElementById(`circle${i}`);
          if (orb) {
            if (i <= maxLitOrbs) {
              orb.setAttribute('fill-opacity', '1');
              orb.setAttribute('filter', 'url(#glowFilter)');
            } else {
              orb.setAttribute('fill-opacity', '0.3');
              orb.removeAttribute('filter');
            }
          }
        }
      }
      function handleIgnitionState(ignitionLevel) {
        if (!svg) return;
        if (ignitionLevel === 0) {
          uiBlackout.style.display = 'block';
          uiSplashScreen.style.display = 'none';
          uiLoadingBarOutline.style.display = 'none';
          uiLoadingBar.style.display = 'none';
          if (loadingTimeoutPromise) {
            $timeout.cancel(loadingTimeoutPromise);
            loadingTimeoutPromise = null;
          }
        } else {
          if (previousIgnitionLevel === 0 && (ignitionLevel === 1 || ignitionLevel === 3)) {
            uiBlackout.style.display = 'block';
            uiSplashScreen.style.display = 'block';
            uiLoadingBarOutline.style.display = 'block';
            uiLoadingBar.style.display = 'block';
            uiLoadingBar.setAttribute('width', '0');
            const animationDuration = 2770;
            const animationSteps = 60;
            const stepDuration = animationDuration / animationSteps;
            const stepWidthIncrement = 1000 / animationSteps;
            let currentStep = 0;
            function animateLoadingBar() {
              if (currentStep <= animationSteps) {
                const newWidth = stepWidthIncrement * currentStep;
                uiLoadingBar.setAttribute('width', newWidth.toString());
                currentStep++;
                loadingTimeoutPromise = $timeout(animateLoadingBar, stepDuration);
              } else {
                uiSplashScreen.style.display = 'none';
                uiLoadingBarOutline.style.display = 'none';
                uiLoadingBar.style.display = 'none';
                uiBlackout.style.display = 'none';
                loadingTimeoutPromise = null;
              }
            }
            animateLoadingBar();
          }
        }
        previousIgnitionLevel = ignitionLevel;
      }
      function updateGear(gear) {
        const gearElement = svg.getElementById('gearval');
        if (gearElement) {
          if (gear === -1) {
            gearElement.textContent = 'R';
          } else {
            gearElement.textContent = gear.toString();
          }
        }
      }
      function updateVolts(rpm, ignitionLevel) {
        const voltsElement = svg.getElementById('voltsval');
        if (!voltsElement) return;
        let targetVoltage;
        if (ignitionLevel === 3) {
          targetVoltage = 11.9;
        } else {
          if (rpm < 0) rpm = 0;
          if (rpm < 1000) {
            const factor = rpm / 1000;
            targetVoltage = voltLowRPM + (voltIdle - voltLowRPM) * factor;
          } else if (rpm < 5000) {
            const factor = (rpm - 1000) / 4000;
            targetVoltage = voltIdle + (voltMax - voltIdle) * factor;
            if (targetVoltage > voltMax) targetVoltage = voltMax;
          } else {
            targetVoltage = voltMax;
          }
        }
        currentVoltage = smoothTransition(targetVoltage, currentVoltage, voltageSmoothFactor);
        voltsElement.textContent = currentVoltage.toFixed(1);
      }
      function updateMPH(speed) {
        const mphElement = svg.getElementById('mphval');
        if (mphElement) {
          const mphValue = Math.round(speed * 2.23694);
          mphElement.textContent = mphValue.toString();
        }
      }
      function updateGPS(airspeed) {
        const gpsElement = svg.getElementById('gpsSpeedval');
        if (gpsElement) {
          const gpsValue = Math.round(airspeed * 2.23694);
          gpsElement.textContent = gpsValue.toString();
        }
      }
      function updateWaterTemp(temp) {
        const waterTempElement = svg.getElementById('waterval');
        if (waterTempElement) {
          const tempFahrenheit = (temp * 9 / 5 + 32).toFixed(0);
          waterTempElement.textContent = tempFahrenheit;
          showHideRect('waterRect', (parseFloat(tempFahrenheit) > waterTempThresholdF));
        }
      }
      function updateOilTemp(temp) {
        const oilTempElement = svg.getElementById('OilTempval');
        if (oilTempElement) {
          const tempFahrenheit = (temp * 9 / 5 + 32).toFixed(1);
          oilTempElement.textContent = tempFahrenheit;
          const overThreshold = (parseFloat(tempFahrenheit) > oilTempThresholdF);
          showHideRect('oilTempRect', overThreshold);
        }
      }
      function updateTransOilTemp(temp) {
        const transOilTempElement = svg.getElementById('transOilTempval');
        if (transOilTempElement) {
          const transOilTempFahrenheit = ((temp - 30) * 9 / 5 + 32).toFixed(1);
          transOilTempElement.textContent = transOilTempFahrenheit;
        }
      }
      function updateFuelLevel(level) {
        const fuelLevelElement = svg.getElementById('fuelLevelval');
        if (fuelLevelElement) {
          const fuelPct = (level * 100).toFixed(0);
          fuelLevelElement.textContent = fuelPct + "%";
          showHideRect('fuelLevelRect', (fuelPct < fuelLevelThreshold));
        }
      }
      function updateBoostPressure(pressure) {
        const boostElement = svg.getElementById('Boostval');
        if (boostElement) {
          const boostValue = Math.round(pressure);
          boostElement.textContent = boostValue.toString();
        }
      }
      function updateFuelPressure(rpm, boost) {
        const fuelPressElement = svg.getElementById('fuelPressval');
        if (!fuelPressElement) return;
        const baseIdlePressure = idleFuelPressure + (Math.random() * 5);
        let pressure;
        if (rpm <= 0) rpm = 0;
        if (rpm < 200) {
          const factor = rpm / 1000;
          pressure = baseIdlePressure * factor;
        } else {
          const rpmPressure = (rpm / 10000) * maxRPMIncrease;
          const boostPressure = boost * boostMultiplier;
          pressure = baseIdlePressure + rpmPressure + boostPressure;
        }
        const roundedPressure = Math.round(pressure);
        fuelPressElement.textContent = roundedPressure.toString();
        showHideRect('fuelPressRect', (roundedPressure < fuelPressThreshold));
      }
      function updateAFR(tps, rpm, speed) {
        const afrLeftElement = svg.getElementById('afrLeftval');
        const afrRightElement = svg.getElementById('afrRightval');
        if (!afrLeftElement || !afrRightElement) return;
        if (rpm < 200) {
          afrLeftElement.textContent = "0";
          afrRightElement.textContent = "0";
          showHideRect('afrLeftRect', true);
          showHideRect('afrRightRect', true);
          return;
        }
        let afrLeft, afrRight;
        if (tps >= 70) {
          afrLeft = getRandomAFR(afrAccelValue, 0.1);
          afrRight = getRandomAFR(afrAccelValue, 0.1);
        } else if (tps < 70 && speed >= 10) {
          afrLeft = getRandomAFR(afrDecelValue, 0.1);
          afrRight = getRandomAFR(afrDecelValue, 0.1);
        } else {
          afrLeft = getRandomAFR(afrIdleValue, 0.1);
          afrRight = getRandomAFR(afrIdleValue, 0.1);
        }
        afrLeftElement.textContent = afrLeft;
        afrRightElement.textContent = afrRight;
        showHideRect('afrLeftRect', (parseFloat(afrLeft) < afrThreshold));
        showHideRect('afrRightRect', (parseFloat(afrRight) < afrThreshold));
      }
      function updateTiming(rpm, tps) {
        const timingElement = svg.getElementById('Timingval');
        if (!timingElement) return;
        let timing;
        if (rpm < 200) {
          timing = 12;
        } else if (tps < 10) {
          timing = getRandomIntInRange(idleTimingMin, idleTimingMax);
        } else {
          timing = getRandomIntInRange(throttleTimingMin, throttleTimingMax);
        }
        timingElement.textContent = timing.toString();
      }
      function updateTwoStepLight(isTwoStepActive) {
        const twoStepLight = svg.getElementById('twostepLight');
        if (!twoStepLight) return;
        if (isTwoStepActive) {
          twoStepLight.setAttribute('fill-opacity', '1');
          twoStepLight.setAttribute('filter', 'url(#glowFilter)');
        } else {
          twoStepLight.setAttribute('fill-opacity', '0.3');
          twoStepLight.removeAttribute('filter');
        }
      }
      function handleMissingThermalData() {
        showHideRect('waterRect', false);
        showHideRect('oilTempRect', false);
        showHideRect('transOilTempRect', false);
        showHideRect('oilPressRect', false);
        const waterTempElement = svg.getElementById('waterval');
        const oilTempElement = svg.getElementById('OilTempval');
        const transOilTempElement = svg.getElementById('transOilTempval');
        const oilPressElement = svg.getElementById('oilPressval');
        if (waterTempElement) {
          waterTempElement.textContent = "180";
        }
        if (oilTempElement) {
          oilTempElement.textContent = "180";
        }
        if (transOilTempElement) {
          transOilTempElement.textContent = "180";
        }
        if (oilPressElement) {
          oilPressElement.textContent = "65";
        }
      }
      function setDefaultWaterTemp() {
        const waterTempElement = svg.getElementById('waterval');
        if (waterTempElement) {
          waterTempElement.textContent = "180";
        }
        showHideRect('waterRect', false);
      }
      function setDefaultOilTemp() {
        const oilTempElement = svg.getElementById('OilTempval');
        const transOilTempElement = svg.getElementById('transOilTempval');
        if (oilTempElement) {
          oilTempElement.textContent = "180";
        }
        if (transOilTempElement) {
          transOilTempElement.textContent = "180";
        }
        showHideRect('oilTempRect', false);
        showHideRect('transOilTempRect', false);
      }
      function setDefaultOilPressure() {
        const oilPressElement = svg.getElementById('oilPressval');
        if (oilPressElement) {
          oilPressElement.textContent = "65";
        }
        showHideRect('oilPressRect', false);
      }
      function isCompleteThermalData(data) {
        return data.coolantTemperature !== undefined &&
               data.oilTemperature !== undefined &&
               data.oilMass !== undefined &&
               data.oilStarvingSevernessXY !== undefined &&
               data.oilStarvingSevernessZ !== undefined &&
               data.maximumSafeG !== undefined;
      }
      element[0].querySelector('object').addEventListener('load', function () {
        $timeout(function () {
          svg = element[0].querySelector('object').contentDocument;
          if (!svg) return;
          injectGlowFilter();
          uiBlackout = svg.getElementById('uiBlackout');
          uiSplashScreen = svg.getElementById('uiSplashScreen');
          uiLoadingBarOutline = svg.getElementById('uiLoadingBarOutline');
          uiLoadingBar = svg.getElementById('uiLoadingBar');
          if (!uiBlackout || !uiSplashScreen || !uiLoadingBarOutline || !uiLoadingBar) return;
          uiBlackout.style.display = 'none';
          uiSplashScreen.style.display = 'none';
          uiLoadingBarOutline.style.display = 'none';
          uiLoadingBar.style.display = 'none';
          showHideRect('transOilTempRect', false);
          showHideRect('rpmRect', false);
          setDefaultOilPressure();
          setDefaultWaterTemp();
          setDefaultOilTemp();
          function updateRPM(rpm) {
            const rpmElement = svg.getElementById('rpmval');
            if (rpmElement) {
              rpmElement.textContent = Math.floor(rpm).toString();
              updateOrbs(rpm);
            }
            const rpmRect = svg.getElementById('rpmRect');
            if (rpmRect) {
              if (rpm > maxRPM) {
                rpmRect.style.display = 'block';
              } else {
                rpmRect.style.display = 'none';
              }
            }
          }
          scope.$on('streamsUpdate', function (event, data) {
            const currentTime = Date.now();
            if (!svg || !data.engineInfo || !data.electrics) {
              handleMissingThermalData();
              return;
            }
            const ignitionLevel = data.electrics.ignitionLevel || 0;
            handleIgnitionState(ignitionLevel);
            if (data.electrics.maxrpm) {
              maxRPM = data.electrics.maxrpm;
            } else {
              maxRPM = 8000;
            }
            const gear = data.electrics.gear || 'N';
            updateGear(gear);
            const rpm = data.engineInfo[4] || 0;
            const wheelSpeed = data.electrics.wheelspeed || 0;
            const airspeed = data.electrics.airspeed || 0;
            const waterTemp = data.engineThermalData ? data.engineThermalData.coolantTemperature : undefined;
            const oilTempCelsius = data.engineThermalData ? data.engineThermalData.oilTemperature : undefined;
            const fuelLevel = (data.engineInfo[11] / data.engineInfo[12]) || 0;
            const boostPressure = data.electrics.boost || 0;
            const tps = (data.electrics.throttle || 0) * 100;
            let gx2 = 0, gy2 = 0, gz2 = 0;
            if (data.sensors) {
              gx2 = data.sensors.gx2 || 0;
              gy2 = data.sensors.gy2 || 0;
              gz2 = data.sensors.gz2 || 0;
            }
            let gForce = Math.sqrt(gx2*gx2 + gy2*gy2 + (gz2 + 9.81)*(gz2 + 9.81)) / 9.81;
            let oilStarvingXY = data.engineThermalData ? data.engineThermalData.oilStarvingSevernessXY : 0;
            let oilStarvingZ  = data.engineThermalData ? data.engineThermalData.oilStarvingSevernessZ : 0;
            let maxSafeG      = data.engineThermalData ? data.engineThermalData.maximumSafeG : 9999;
            let oilMass = data.engineThermalData && data.engineThermalData.oilMass !== undefined ? data.engineThermalData.oilMass : 5.0;
            if (currentTime - lastRPMUpdateTime >= updateInterval) {
              lastRPMUpdateTime = currentTime;
              updateRPM(rpm);
              updateVolts(rpm, ignitionLevel);
            }
            if (currentTime - lastMPHUpdateTime >= updateInterval) {
              lastMPHUpdateTime = currentTime;
              updateMPH(wheelSpeed);
            }
            if (currentTime - lastGPSUpdateTime >= updateInterval) {
              lastGPSUpdateTime = currentTime;
              updateGPS(airspeed);
            }
            if (data.engineThermalData) {
              if (isCompleteThermalData(data.engineThermalData)) {
                if (currentTime - lastWaterTempUpdateTime >= updateInterval) {
                  lastWaterTempUpdateTime = currentTime;
                  updateWaterTemp(waterTemp);
                }
                if (currentTime - lastOilTempUpdateTime >= updateInterval) {
                  lastOilTempUpdateTime = currentTime;
                  updateOilTemp(oilTempCelsius);
                  updateTransOilTemp(oilTempCelsius);
                }
                updateOilPressure(oilTempCelsius, rpm, oilMass, gForce, oilStarvingXY, oilStarvingZ, maxSafeG);
              } else {
                if (currentTime - lastWaterTempUpdateTime >= updateInterval) {
                  lastWaterTempUpdateTime = currentTime;
                  setDefaultWaterTemp();
                }
                if (currentTime - lastOilTempUpdateTime >= updateInterval) {
                  lastOilTempUpdateTime = currentTime;
                  setDefaultOilTemp();
                }
                setDefaultOilPressure();
              }
            } else {
              if (currentTime - lastWaterTempUpdateTime >= updateInterval) {
                lastWaterTempUpdateTime = currentTime;
                setDefaultWaterTemp();
              }
              if (currentTime - lastOilTempUpdateTime >= updateInterval) {
                lastOilTempUpdateTime = currentTime;
                setDefaultOilTemp();
              }
              setDefaultOilPressure();
            }
            if (currentTime - lastFuelLevelUpdateTime >= updateInterval) {
              lastFuelLevelUpdateTime = currentTime;
              updateFuelLevel(fuelLevel);
            }
            if (currentTime - lastBoostPressureUpdateTime >= updateInterval) {
              lastBoostPressureUpdateTime = currentTime;
              updateBoostPressure(boostPressure);
            }
            if (currentTime - lastFuelPressUpdateTime >= updateInterval) {
              lastFuelPressUpdateTime = currentTime;
              updateFuelPressure(rpm, boostPressure);
            }
            if (currentTime - lastVoltsUpdateTime >= updateInterval) {
              lastVoltsUpdateTime = currentTime;
            }
            if (currentTime - lastAFRUpdateTime >= updateInterval) {
              lastAFRUpdateTime = currentTime;
              updateAFR(tps, rpm, wheelSpeed);
            }
            if (currentTime - lastTimingUpdateTime >= updateInterval) {
              lastTimingUpdateTime = currentTime;
              updateTiming(rpm, tps);
            }
            if (data.engineThermalData && isCompleteThermalData(data.engineThermalData)) {
              updateOilPressure(oilTempCelsius, rpm, oilMass, gForce, oilStarvingXY, oilStarvingZ, maxSafeG);
            }
            if (data.electrics.twoStep !== undefined) {
              const isTwoStepActive = data.electrics.twoStep;
              updateTwoStepLight(isTwoStepActive);
            }
          });
        }, 500);
      });
      scope.$on('$destroy', function () {
        StreamsManager.remove(streamsList);
        if (loadingTimeoutPromise) {
          $timeout.cancel(loadingTimeoutPromise);
        }
      });
    }
  };
}]);
