--==============================================================
-- SBGNX Nitrous Controller (Final version with UI-safe timing)
--==============================================================
local M = {}

local isActive = false
local isArmed = false
local tankRatio = 1.0
local usageRate = 0.0005

local function toggleActive()
  if not isArmed then
    print("[SBGNX_N2O] Tried to activate but system not armed!")
    return
  end
  isActive = not isActive
  print("[SBGNX_N2O] Nitrous Active: " .. tostring(isActive))
end

local function toggleArm()
  isArmed = not isArmed
  print("[SBGNX_N2O] System Armed: " .. tostring(isArmed))
end

local function updateGFX(dt)
  if isActive and tankRatio > 0 then
    tankRatio = math.max(0, tankRatio - usageRate * dt * 60)
  end
end

function M.init(jbeamData)
  print("[SBGNX_N2O] Controller initialized successfully!")

  -- Wait a few frames before adding quick access buttons (fixes [filter:notarray])
  local delayFrames = 30
  local framesPassed = 0

  M.onUpdate = function(dt)
    framesPassed = framesPassed + 1
    if framesPassed >= delayFrames then
      be:queueCallback(function()
        core_quickAccess.addEntry({
          level = "/root/playerVehicle/vehicleFeatures/",
          generator = function(entries)
            table.insert(entries, {
              title = "Toggle Nitrous",
              priority = 40,
              color = "#00AAFF",
              icon = "n2o",
              onSelect = function()
                toggleActive()
                return {"reload"}
              end
            })

            table.insert(entries, {
              title = "Arm Nitrous",
              priority = 39,
              color = "#FF6600",
              icon = "n2o",
              onSelect = function()
                toggleArm()
                return {"reload"}
              end
            })
          end
        })
      end)
      -- Stop running the delay after registration
      M.onUpdate = nil
    end
  end
end

M.updateGFX = updateGFX
M.toggleActive = toggleActive
M.toggleArm = toggleArm

return M
