angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window, $timeout) {
    $scope.data = {
        gear: "Bork",
        rpm: "Bork",
        boostVal: "Bork",
        oilTempVal: "Bork",
        waterVal: "Bork",
        voltsVal: "Bork",
        fuelPressVal: "Bork",
        gpsSpeedVal: "Bork",
        blackout: false,
        showSplashScreen: false,
        showVoltsRec: false,
        maxRpm: 8000,       // default max RPM if not provided
        rpmBarWidth: 0,     // Width for RPM bar (2610 max)
        tpsBarWidth: 0,     // Width for TPS bar (838 max)
        oilpBarHeight: 0,   // Height for oil pressure bar fill (max: 385)
        oilpBarY: 1325,     // Y coordinate for oil pressure bar fill (bottom fixed at 1325)
        fuelpBarHeight: 0,  // Height for fuel pressure bar fill (max: 385)
        fuelpBarY: 1325,    // Y coordinate for fuel pressure bar fill (bottom fixed at 1325)
        oilpBarColor: "#FFFFFF",  // Default color for oil pressure bar
        fuelpBarColor: "#FFFFFF"  // Default color for fuel pressure bar
    };

    // Constants used for fuel pressure and oil pressure calculations.
    const idleFuelPressure = 60,
          maxRPMIncrease = 10,
          coldOilTempF = 70,
          warmOilTempF = 190,
          hotOilTempF = 250,
          coldOilPressure = 104,
          warmOilPressure = 73,
          hotOilPressure = 5,
          coldRPMPressureIncrease = 20,
          warmRPMPressureIncrease = 10,
          lowRPMThreshold = 500,
          nearZeroRPMThreshold = 25;

    $window.updateData = (data) => {
        $scope.$evalAsync(function () {
            const previousIgnState = $scope.data.ign || 0;
            $scope.data.ign = data.ign;
            if (previousIgnState === 0 && (data.ign === 1 || data.ign === 3)) {
                // Show splash screen when ignition turns on.
                $scope.data.showSplashScreen = true;
                $timeout(() => { $scope.data.showSplashScreen = false; }, 3000);
            }
            $scope.data.blackout = data.ign <= 0.1;
            if ($scope.data.blackout) {
                $scope.data.gear = "00";
                $scope.data.rpm = "00";
                $scope.data.boostVal = "00";
                $scope.data.oilTempVal = "00";
                $scope.data.waterVal = "00";
                $scope.data.voltsVal = "00";
                $scope.data.fuelPressVal = "00";
                $scope.data.gpsSpeedVal = "00";
                $scope.data.rpmBarWidth = 0;
                $scope.data.tpsBarWidth = 0;
                $scope.data.oilpBarHeight = 0;
                $scope.data.oilpBarY = 1325;
                $scope.data.fuelpBarHeight = 0;
                $scope.data.fuelpBarY = 1325;
                return;
            }

            // Update gear. (Gear: -1 becomes "R", 0 becomes "N", otherwise the number.)
            $scope.data.gear = data.gear === -1 ? "R" : data.gear === 0 ? "N" : data.gear;

            // Update boost.
            $scope.data.boostVal = data.boost.toFixed(0);

            // --- Fuel Pressure Calculation (Original Logic) ---
            let baseFuelPressure = idleFuelPressure + (Math.random() * 4 - 2),
                rpmFuelPressure = (data.ripems / 10000) * maxRPMIncrease;
            if (data.ripems < lowRPMThreshold) {
                let pressureDropFactor = data.ripems < nearZeroRPMThreshold ? 0 : data.ripems / lowRPMThreshold;
                baseFuelPressure *= pressureDropFactor;
                rpmFuelPressure *= pressureDropFactor;
            }
            let fuelPressure = baseFuelPressure + rpmFuelPressure;
            // Save the numeric fuel pressure value (including boost)
            let numericFuelPressure = fuelPressure + data.boost;
            $scope.data.fuelPressVal = numericFuelPressure.toFixed(0);

            // Update RPM.
            $scope.data.rpm = data.ripems;

            // Capture the max RPM value.
            $scope.data.maxRpm = data.maxRpm || 8000;

            // Calculate the RPM bar width (2610 max).
            let rpmFraction = data.ripems / $scope.data.maxRpm;
            rpmFraction = Math.max(0, Math.min(1, rpmFraction));
            $scope.data.rpmBarWidth = rpmFraction * 2610;

            // Calculate the TPS bar width (838 max).
            // Assume data.tps is a fraction between 0 and 1.
            let tpsFraction = data.tps;
            tpsFraction = Math.max(0, Math.min(1, tpsFraction));
            $scope.data.tpsBarWidth = tpsFraction * 838;

            // Update GPS speed (converted from m/s to mph).
            $scope.data.gpsSpeedVal = (data.gps * 2.23694).toFixed(0);

            // Convert oil temperature to Fahrenheit and update.
            let oilTempF = (data.oiltemp * 1.8) + 32;
            $scope.data.oilTempVal = oilTempF.toFixed(0);

            // Convert coolant temperature to Fahrenheit and update.
            let coolantTempF = (data.watertemp * 1.8) + 32;
            $scope.data.waterVal = coolantTempF.toFixed(0);

            // Update volts.
            $scope.data.voltsVal = data.voltsVal ? data.voltsVal.toFixed(1) : "00";
            $scope.data.showVoltsRec = parseFloat($scope.data.voltsVal) < 14.5;

            // --- Oil Pressure Calculation (Original Logic) ---
            let oilPressure = 0;
            if (oilTempF <= 70) {
                oilPressure = coldOilPressure + (data.ripems / 10000) * coldRPMPressureIncrease;
            } else if (oilTempF > 70 && oilTempF < 190) {
                const transitionFactor = (oilTempF - 70) / (190 - 70);
                const basePressure = coldOilPressure * (1 - transitionFactor) + warmOilPressure * transitionFactor;
                const rpmPressureIncrease = (data.ripems / 10000) * (coldRPMPressureIncrease * (1 - transitionFactor) + warmRPMPressureIncrease * transitionFactor);
                oilPressure = basePressure + rpmPressureIncrease;
            } else {
                oilPressure = warmOilPressure + ((oilTempF - warmOilTempF) / (hotOilTempF - warmOilTempF)) * (hotOilPressure - warmOilPressure) + (data.ripems / 10000) * warmRPMPressureIncrease;
            }
            if (data.ripems < lowRPMThreshold) {
                let pressureDropFactor = data.ripems < nearZeroRPMThreshold ? 0 : data.ripems / lowRPMThreshold;
                oilPressure *= pressureDropFactor;
            }
            if (data.ripems !== 0) oilPressure += Math.random() * 2 - 1;
            // Clamp oil pressure to zero (do not allow negatives)
            oilPressure = Math.max(0, oilPressure);
            $scope.data.oilPressVal = oilPressure.toFixed(0);

            // --- Oil Pressure Bar Calculations ---
            // Map oil pressure on a 0-100 scale.
            const minOilPressureScale = 0,
                  maxOilPressureScale = 100;
            let oilPressureFraction = (oilPressure - minOilPressureScale) / (maxOilPressureScale - minOilPressureScale);
            oilPressureFraction = Math.max(0, Math.min(1, oilPressureFraction));
            let newOilpBarHeight = oilPressureFraction * 385;
            let newOilpBarY = 1325 - newOilpBarHeight;
            $scope.data.oilpBarHeight = newOilpBarHeight;
            $scope.data.oilpBarY = newOilpBarY;

            // --- Determine Oil Pressure Bar Color ---
            // If oil pressure is 40 or above, color is green.
            // Below 40, we interpolate from red (at 0) to green (at 40).
            if (oilPressure >= 40) {
                $scope.data.oilpBarColor = "#0edd0e";  // green
            } else {
                let factor = oilPressure / 40;  // 0 at 0, 1 at 40
                let r = Math.round(255 * (1 - factor));  // from 255 (red) to 0
                let g = Math.round(255 * factor);          // from 0 to 255
                let b = 0;
                $scope.data.oilpBarColor = "rgb(" + r + "," + g + "," + b + ")";
            }

            // --- Fuel Pressure Bar Calculations ---
            // Map fuel pressure (fuelPressureVal) on a 0-150 scale.
            const minFuelPressureScale = 0,
                  maxFuelPressureScale = 150;
            let fuelPressureFraction = (numericFuelPressure - minFuelPressureScale) / (maxFuelPressureScale - minFuelPressureScale);
            fuelPressureFraction = Math.max(0, Math.min(1, fuelPressureFraction));
            let newFuelpBarHeight = fuelPressureFraction * 385;
            let newFuelpBarY = 1325 - newFuelpBarHeight;
            $scope.data.fuelpBarHeight = newFuelpBarHeight;
            $scope.data.fuelpBarY = newFuelpBarY;

            // --- Determine Fuel Pressure Bar Color ---
            // If fuel pressure is 55 or above, color is green.
            // Below 55, we interpolate from red (at 0) to green (at 55).
            if (numericFuelPressure >= 55) {
                $scope.data.fuelpBarColor = "#0edd0e";  // green
            } else {
                let factor = numericFuelPressure / 55;
                let r = Math.round(255 * (1 - factor));
                let g = Math.round(255 * factor);
                let b = 0;
                $scope.data.fuelpBarColor = "rgb(" + r + "," + g + "," + b + ")";
            }
        });
    };
});
