angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window, $timeout) {
    $scope.data = {
        gear: "Bork",
        rpm: "Bork",
        boostVal: "Bork",
        oilTempVal: "Bork",
        waterVal: "Bork",
        voltsVal: "Bork",
        fuelPressVal: "Bork",
        gpsSpeedVal: "Bork",
        blackout: false,
        showSplashScreen: false,
        showVoltsRec: false,
        maxRpm: 8000,
        rpmBarWidth: 0,
        tpsBarWidth: 0,
        oilpBarHeight: 0,
        oilpBarY: 1325,
        fuelpBarHeight: 0,
        fuelpBarY: 1325,
        oilpBarColor: "#FFFFFF",
        fuelpBarColor: "#FFFFFF",
        showxqc: false,
        rpmTicks: [],
        // New properties for the g-force orb and REC element
        gforceOrbX: 974,  // default base x coordinate
        gforceOrbY: 734,  // default base y coordinate
        recOpacity: "1"   // initial opacity for REC element (will blink)
    };

    const idleFuelPressure = 60,
          maxRPMIncrease = 10,
          coldOilTempF = 70,
          warmOilTempF = 190,
          hotOilTempF = 250,
          coldOilPressure = 104,
          warmOilPressure = 73,
          hotOilPressure = 5,
          coldRPMPressureIncrease = 20,
          warmRPMPressureIncrease = 10,
          lowRPMThreshold = 500,
          nearZeroRPMThreshold = 25;

    // Start REC blinking – toggles recOpacity every 500ms.
    function blinkREC() {
        $scope.data.recOpacity = ($scope.data.recOpacity === "1") ? "0" : "1";
        $timeout(blinkREC, 500);
    }
    blinkREC();

    $window.updateData = (data) => {
        $scope.$evalAsync(function () {
            const previousIgnState = $scope.data.ign || 0;
            $scope.data.ign = data.ign;
            if (previousIgnState === 0 && (data.ign === 1 || data.ign === 3)) {
                // Show splash screen when ignition turns on.
                $scope.data.showSplashScreen = true;
                $timeout(() => {
                    $scope.data.showSplashScreen = false;
                }, 3000);
            }
            $scope.data.blackout = data.ign <= 0.1;
            if ($scope.data.blackout) {
                $scope.data.gear = "00";
                $scope.data.rpm = "00";
                $scope.data.boostVal = "00";
                $scope.data.oilTempVal = "00";
                $scope.data.waterVal = "00";
                $scope.data.voltsVal = "00";
                $scope.data.fuelPressVal = "00";
                $scope.data.gpsSpeedVal = "00";
                $scope.data.rpmBarWidth = 0;
                $scope.data.tpsBarWidth = 0;
                $scope.data.oilpBarHeight = 0;
                $scope.data.oilpBarY = 1325;
                $scope.data.fuelpBarHeight = 0;
                $scope.data.fuelpBarY = 1325;
                return;
            }

            $scope.data.gear = data.gear === -1 ? "R" : data.gear === 0 ? "N" : data.gear;

            $scope.data.boostVal = data.boost.toFixed(0);

            let baseFuelPressure = idleFuelPressure + (Math.random() * 4 - 2),
                rpmFuelPressure = (data.ripems / 10000) * maxRPMIncrease;
            if (data.ripems < lowRPMThreshold) {
                let pressureDropFactor = data.ripems < nearZeroRPMThreshold ? 0 : data.ripems / lowRPMThreshold;
                baseFuelPressure *= pressureDropFactor;
                rpmFuelPressure *= pressureDropFactor;
            }
            let fuelPressure = baseFuelPressure + rpmFuelPressure;
            let numericFuelPressure = fuelPressure + data.boost;
            $scope.data.fuelPressVal = numericFuelPressure.toFixed(0);

            $scope.data.rpm = data.ripems;

            $scope.data.maxRpm = data.maxRpm || 8000;

            var ticks = [];
            var maxTick = Math.floor($scope.data.maxRpm / 1000);
            for (var i = 0; i <= maxTick; i++) {
                var xPos = 540 + (i * 1000 / $scope.data.maxRpm) * 2500 + 40;
                ticks.push({ label: i, x: xPos });
            }
            $scope.data.rpmTicks = ticks;

            let rpmFraction = data.ripems / $scope.data.maxRpm;
            rpmFraction = Math.max(0, Math.min(1, rpmFraction));
            $scope.data.rpmBarWidth = rpmFraction * 2610;

            let tpsFraction = data.tps;
            tpsFraction = Math.max(0, Math.min(1, tpsFraction));
            $scope.data.tpsBarWidth = tpsFraction * 838;

            $scope.data.gpsSpeedVal = (data.gps * 2.23694).toFixed(0);

            let oilTempF = (data.oiltemp * 1.8) + 32;
            $scope.data.oilTempVal = oilTempF.toFixed(0);

            let coolantTempF = (data.watertemp * 1.8) + 32;
            $scope.data.waterVal = coolantTempF.toFixed(0);

            $scope.data.voltsVal = data.voltsVal ? data.voltsVal.toFixed(1) : "00";
            $scope.data.showVoltsRec = parseFloat($scope.data.voltsVal) < 14.5;

            let oilPressure = 0;
            if (oilTempF <= 70) {
                oilPressure = coldOilPressure + (data.ripems / 10000) * coldRPMPressureIncrease;
            } else if (oilTempF > 70 && oilTempF < 190) {
                const transitionFactor = (oilTempF - 70) / (190 - 70);
                const basePressure = coldOilPressure * (1 - transitionFactor) + warmOilPressure * transitionFactor;
                const rpmPressureIncrease = (data.ripems / 10000) * (coldRPMPressureIncrease * (1 - transitionFactor) + warmRPMPressureIncrease * transitionFactor);
                oilPressure = basePressure + rpmPressureIncrease;
            } else {
                oilPressure = warmOilPressure + ((oilTempF - warmOilTempF) / (hotOilTempF - warmOilTempF)) * (hotOilPressure - warmOilPressure) + (data.ripems / 10000) * warmRPMPressureIncrease;
            }
            if (data.ripems < lowRPMThreshold) {
                let pressureDropFactor = data.ripems < nearZeroRPMThreshold ? 0 : data.ripems / lowRPMThreshold;
                oilPressure *= pressureDropFactor;
            }
            if (data.ripems !== 0) oilPressure += Math.random() * 2 - 1;
            oilPressure = Math.max(0, oilPressure);
            $scope.data.oilPressVal = oilPressure.toFixed(0);

            const minOilPressureScale = 0,
                  maxOilPressureScale = 100;
            let oilPressureFraction = (oilPressure - minOilPressureScale) / (maxOilPressureScale - minOilPressureScale);
            oilPressureFraction = Math.max(0, Math.min(1, oilPressureFraction));
            let newOilpBarHeight = oilPressureFraction * 385;
            let newOilpBarY = 1325 - newOilpBarHeight;
            $scope.data.oilpBarHeight = newOilpBarHeight;
            $scope.data.oilpBarY = newOilpBarY;

            if (oilPressure >= 40) {
                $scope.data.oilpBarColor = "#0edd0e";
            } else {
                let factor = oilPressure / 40;
                let r = Math.round(255 * (1 - factor));
                let g = Math.round(255 * factor);
                $scope.data.oilpBarColor = "rgb(" + r + "," + g + ",0)";
            }

            const minFuelPressureScale = 0,
                  maxFuelPressureScale = 150;
            let fuelPressureFraction = (numericFuelPressure - minFuelPressureScale) / (maxFuelPressureScale - minFuelPressureScale);
            fuelPressureFraction = Math.max(0, Math.min(1, fuelPressureFraction));
            let newFuelpBarHeight = fuelPressureFraction * 385;
            let newFuelpBarY = 1325 - newFuelpBarHeight;
            $scope.data.fuelpBarHeight = newFuelpBarHeight;
            $scope.data.fuelpBarY = newFuelpBarY;

            if (numericFuelPressure >= 55) {
                $scope.data.fuelpBarColor = "#0edd0e";
            } else {
                let factor = numericFuelPressure / 55;
                let r = Math.round(255 * (1 - factor));
                let g = Math.round(255 * factor);
                $scope.data.fuelpBarColor = "rgb(" + r + "," + g + ",0)";
            }

            $scope.data.showxqc = data.ripems > ($scope.data.maxRpm - 400);

            // --- New logic for g-force orb ---
            if (data.sensors) {
                let gx2 = data.sensors.gx2 || 0;
                let gy2 = data.sensors.gy2 || 0;
                const gravity = 9.81;
                let normX = gx2 / gravity;
                let normY = gy2 / gravity;
                let magnitude = Math.sqrt(normX * normX + normY * normY);
                if (magnitude > 2) {
                    normX = normX * (2 / magnitude);
                    normY = normY * (2 / magnitude);
                }
                const baseX = 974;
                const baseY = 734;
                const offsetScale = 150;
                const offsetX = normX * offsetScale;
                const offsetY = -normY * offsetScale;
                $scope.data.gforceOrbX = baseX + offsetX;
                $scope.data.gforceOrbY = baseY + offsetY;
            }
        });
    };
});
