local M = {}

-- Track window states
local left_position = 0
local right_position = 0
local MOVE_SPEED = 0.5

local function updateGFX(dt)
    if not electrics then return end
    
    -- Get button states for both windows
    local left_up_state = electrics.values.windowLup or 0
    local left_down_state = electrics.values.windowLdown or 0
    local right_up_state = electrics.values.windowRup or 0
    local right_down_state = electrics.values.windowRdown or 0
    
    -- Left window control
    if left_up_state == 1 then
        left_position = left_position + MOVE_SPEED * dt
        if left_position > 1 then 
            left_position = 1
        end
    end
    
    if left_down_state == 1 then
        left_position = left_position - MOVE_SPEED * dt
        if left_position < 0 then 
            left_position = 0
        end
    end
    
    -- Right window control
    if right_up_state == 1 then
        right_position = right_position + MOVE_SPEED * dt
        if right_position > 1 then 
            right_position = 1
        end
    end
    
    if right_down_state == 1 then
        right_position = right_position - MOVE_SPEED * dt
        if right_position < 0 then 
            right_position = 0
        end
    end
    
    -- Update both window positions
    electrics.values.WindowLeft = left_position
    electrics.values.WindowRight = right_position
end

local function onReset()
    left_position = 0
    right_position = 0
    if electrics then
        electrics.values.WindowLeft = 0
        electrics.values.WindowRight = 0
    end
end

local function onVehicleActiveChanged(active)
    if active then
        electrics.registerHandler("updateGFX", updateGFX)
        electrics.values.WindowLeft = 0
        electrics.values.WindowRight = 0
    end
end

M.onVehicleActiveChanged = onVehicleActiveChanged
M.onReset = onReset
M.updateGFX = updateGFX

return M