local M = {}

local screenState = {
    panelOut = 0,
    screenUp = 0,
    screenRotation = 0,
    secondaryPanel = 0,
    isAnimating = false,
    currentPhase = 0,
    isClosing = false
}

local config = {
    panelSpeed = 1.0,
    screenUpSpeed = 0.5,
    rotationSpeed = 1.0,
    screenLowerAmount = 0.2,
    secondaryPanelSpeed = 1.0
}

local wasActive = false

function M.init()
    electrics.values.toggle_screen = 0
    electrics.values.toggle_screen_pressed = 0
    electrics.values.panel_out = 0
    electrics.values.screen_up = 0
    electrics.values.screen_rotate = 0
    electrics.values.secondary_panel = 0
    electrics.values.screen_opening = 0
    
    if wasActive then
        screenState.isAnimating = true
        screenState.currentPhase = 0
    end
end

function M.reset()
    wasActive = (screenState.currentPhase == 4)
    
    screenState.panelOut = 0
    screenState.screenUp = 0
    screenState.screenRotation = 0
    screenState.secondaryPanel = 0
    screenState.isAnimating = false
    screenState.currentPhase = 0
    screenState.isClosing = false
    
    electrics.values.toggle_screen = 0
    electrics.values.toggle_screen_pressed = 0
    electrics.values.panel_out = 0
    electrics.values.screen_up = 0
    electrics.values.screen_rotate = 0
    electrics.values.secondary_panel = 0
    electrics.values.screen_opening = 0
    
    if wasActive then
        screenState.isAnimating = true
        screenState.currentPhase = 0
    end
end

function M.updateGFX(dt)
    if electrics.values.toggle_screen_pressed == 1 and not screenState.isAnimating then
        screenState.isAnimating = true
        screenState.isClosing = (screenState.currentPhase == 4)
        if not screenState.isClosing and screenState.currentPhase == 0 then
            electrics.values.screen_opening = 1
        end
    end
    
    if screenState.isAnimating then
        if not screenState.isClosing then
            if screenState.currentPhase == 0 then
                screenState.panelOut = math.min(1, screenState.panelOut + config.panelSpeed * dt)
                if screenState.panelOut >= 1 then
                    screenState.currentPhase = 1
                end
            elseif screenState.currentPhase == 1 then
                screenState.screenUp = math.min(1, screenState.screenUp + config.screenUpSpeed * dt)
                if screenState.screenUp >= 1 then
                    screenState.currentPhase = 2
                end
            elseif screenState.currentPhase == 2 then
                screenState.screenRotation = math.min(1, screenState.screenRotation + config.rotationSpeed * dt)
                if screenState.screenRotation >= 1 then
                    screenState.currentPhase = 3
                end
            elseif screenState.currentPhase == 3 then
                screenState.screenUp = math.max(1 - config.screenLowerAmount, 
                                           screenState.screenUp - config.screenUpSpeed * dt)
                screenState.secondaryPanel = math.min(1, screenState.secondaryPanel + config.secondaryPanelSpeed * dt)
                
                if screenState.screenUp <= 1 - config.screenLowerAmount then
                    screenState.currentPhase = 4
                    screenState.isAnimating = false
                    electrics.values.screen_opening = 0
                end
            end
        else
            if screenState.currentPhase == 4 then
                screenState.screenUp = math.min(1, screenState.screenUp + config.screenUpSpeed * dt)
                screenState.secondaryPanel = math.max(0, screenState.secondaryPanel - config.secondaryPanelSpeed * dt)
                if screenState.screenUp >= 1 and screenState.secondaryPanel <= 0 then
                    screenState.currentPhase = 3
                end
            elseif screenState.currentPhase == 3 then
                screenState.screenRotation = math.max(0, screenState.screenRotation - config.rotationSpeed * dt)
                if screenState.screenRotation <= 0 then
                    screenState.currentPhase = 2
                end
            elseif screenState.currentPhase == 2 then
                screenState.screenUp = math.max(0, screenState.screenUp - config.screenUpSpeed * dt)
                if screenState.screenUp <= 0 then
                    screenState.currentPhase = 1
                end
            elseif screenState.currentPhase == 1 then
                screenState.panelOut = math.max(0, screenState.panelOut - config.panelSpeed * dt)
                if screenState.panelOut <= 0 then
                    screenState.currentPhase = 0
                    screenState.isAnimating = false
                    screenState.isClosing = false
                end
            end
        end
        
        electrics.values.panel_out = screenState.panelOut
        electrics.values.screen_up = screenState.screenUp
        electrics.values.screen_rotate = screenState.screenRotation
        electrics.values.secondary_panel = screenState.secondaryPanel
        electrics.values.screen_phase = screenState.currentPhase
        electrics.values.screen_closing = screenState.isClosing and 1 or 0
    end
end

return M