local M = {}

local audio = "rearwindowup"
local soundPlayed = false
local windowup = true
local windowdown = false

local function playSoundUp()
    -- name, nodeId, volume, pitch
    obj:playSFXOnce(audio, 282, 1, 1)
end

local function onInit(jbeamData)
    -- path, description, name, playOnAdd
    obj:createSFXSource("/vehicles/sdd_tour/sounds/screen.mp3", "AudioClosest3D", audio, -1)

    --[[ possible descriptions are:
        AudioDefault3D
        AudioSoft3D
        AudioClose3D
        AudioClosest3D
        AudioMusic3D

        AudioDefaultLoop3D
        AudioCloseLoop3D
        AudioClosestLoop3D
        AudioMusicLoop3D

        Audio2D
        AudioStream2D
        AudioMusic2D

        AudioLoop2D
        AudioStreamLoop2D
    ]]
end

local function updateGFX(dt)
	if electrics.values.screen_opening == 0 and soundPlayed == true then
		soundPlayed = false
		windowup = false
		print("Window down")
	end

    if electrics.values.screen_opening == 1 and soundPlayed == false then
        print("Window up")
        playSoundUp()
        soundPlayed = true
		windowdown = true
    end
end


M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

M.playSoundUp = playSoundUp

return M
