local M = {}

function M.init()
    electrics.values.enginePower = 0
end

function M.updateGFX(dt)
    local rpm = electrics.values.rpm or 0
    local throttle = electrics.values.throttle or 0
    local engineLoad = electrics.values.engineLoad or 0
    local maxRPM = electrics.values.maxrpm or 9000
    
    -- Calculate power using engine load and RPM
    local power = (engineLoad * maxRPM * rpm) / 5252
    
    -- Scale power to max 2000hp
    power = math.min(power, 8000)
    
    -- Add smoothing
    if not M.hp_smoothed then M.hp_smoothed = 0 end
    M.hp_smoothed = M.hp_smoothed + (power - M.hp_smoothed) * dt * 5
    
    -- Store result
    electrics.values.enginePower = M.hp_smoothed
end

return M