local M = {}

local serviceTimer = 0
local abs = math.abs
local function serviceRequired(dt)
    serviceTimer = serviceTimer + dt

    if serviceTimer >= 3 then
      if damageTracker.getDamage("engine", "oilRadiatorLeak") then return true
      elseif damageTracker.getDamage("engine", "headGasketDamaged") then return true
      elseif damageTracker.getDamage("engine", "pistonRingsDamaged") then return true
      elseif damageTracker.getDamage("engine", "rogBearingsDamaged") then return true
      elseif damageTracker.getDamage("engine", "blockMelted") then return true
      elseif damageTracker.getDamage("engine", "cylinderWallsMelted") then return true
      elseif damageTracker.getDamage("engine", "radiatorLeak") then return true
      elseif damageTracker.getDamage("engine", "exhaustBroken") then return true
      elseif damageTracker.getDamage("engine", "inductionSystemDamaged") then return true
      elseif damageTracker.getDamage("engine", "superchargerDamaged") then return true
      elseif damageTracker.getDamage("engine", "turbochargerDamaged") then return true
      elseif damageTracker.getDamage("engine", "engineTorqueReduced") then return true
      elseif damageTracker.getDamage("engine", "impactDamage") then return true
      elseif damageTracker.getDamage("engine", "catastrophicOverrevDamaged") then return true
      elseif damageTracker.getDamage("engine", "mildOverrevDamage") then return true
      elseif damageTracker.getDamage("engine", "engineDisabled") then return true
      elseif damageTracker.getDamage("engine", "engineLockedUp") then return true
      elseif damageTracker.getDamage("engine", "energyStorage") then return true
      end
      serviceTimer = 0
    end

    return false
end

local function updateGFX(dt)
    electrics.values.highBraketemp = 0
    for _, v in pairs(electrics.values.wheelThermals) do
        if v.brakeCoreTemperature >= 300 then
            electrics.values.highBraketemp = 1
        end
    end
	
	electrics.values.checkengineBetter = serviceRequired(dt)
	
	if electrics.values.oilLeak ~= 1 then
        if damageTracker.getDamage("engine", "oilLeak") then
            electrics.values.oilLeak = 1
        end
    end
end

local function onInit()
    electrics.values.checkengineBetter = false
	electrics.values.highBraketemp = 0
	electrics.values.oilLeak = 0
end

-- public interface
M.onInit = onInit
M.onReset = onInit
M.updateGFX = updateGFX

return M