// RU Код неполноценно создан: PoonJik (KDM | MODS) \ ENG The code is incomplete: PoonJik (KDM | MODS)
angular.module('gaugesScreen', [])
  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];
	var messageBox = {}
	var TextMPH = {}
	var TextKMH = {}

    var text = {  };
	var speedoDisplay = { gears: {} };
	var gauges = {fuel:{},temp:{}};
	var tacho = {  };
    var navDisplay = {};
    var infoDisplay = {};
    var consumGraph = {values:{current: 0,avg: 0}};
    var electrics = {lights:{}, dse:{} };
    var gForcesVisible = false;

    var backgroundGradient = {};
    var overlayGradient = {};
    var navMarkerGradient = {};
    // var backgroundClipGradient;

    var speedoInitialised = false;
    var currentGear = '';
    var prevspeedAng = 0;
	var prevRpmAng = 0;
	var prevBarAng = 0;
	var prevPowerAng = 0;
	var prevIcePowerAng = 0;

    var ready = false;

    var unit = "metric";
	var units = {uiUnitTemperature: "c"};
    var unitspeedratio = 2.57/260*Math.PI*1.5;

    function setTheme(hue) {
      // speedo

      // info
      infoDisplay.infoOverlay.css({'stroke': `hsl(${hue}, 100%, 30%)`, 'stroke-width': '0.5px'});

      // info
      navDisplay.overlay.css({'stroke': `hsl(${hue}, 100%, 30%)`, 'stroke-width': '0.5px'});

      // gradients
      overlayGradient.stop1.css({stopColor: `hsl(${hue}, 100%, 20%)`})
      overlayGradient.stop2.css({stopColor: `hsl(${hue}, 100%, 10%)`})

      backgroundGradient.stop1.css({"stop-color": `hsl(${hue}, 100%, 0%)`})
      backgroundGradient.stop2.css({"stop-color": `hsl(${hue}, 100%, 0%)`})

      navMarkerGradient.stop1.css({"stop-color": `hsl(${hue}, 100%, 50%)`})
      navMarkerGradient.stop2.css({"stop-color": `hsl(${hue}, 100%, 30%)`})

      // background color
      $element[0].style.backgroundColor = "black";
      //$element[0].style.backgroundColor = `hsl(${hue}, 70%, 20%)`;
    }

    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
      svg = $element[0].children[1].children[0];

      // speedometer
	  speedoDisplay.root = hu('#TachoTick', svg);
      speedoDisplay.root = hu('#speedometer', svg);
	  speedoDisplay.speedometerText = hu('#speedometerText', speedoDisplay.root)
      speedoDisplay.speedValue = hu('#speedValue', speedoDisplay.speedometerText);
	  speedoDisplay.speedValueShadow = hu('#speedValueShadow', speedoDisplay.speedometerText);
      speedoDisplay.speedUnit = hu('#speedUnit', speedoDisplay.speedometerText);
	  speedoDisplay.SpeedUnitShadow = hu('#SpeedUnitShadow', speedoDisplay.speedometerText);
      speedoDisplay.speedTicks = hu('#speedTicks', speedoDisplay.speedometerText).css({'stroke': '#00000000', 'stroke-width': '0.2px'});
	  speedoDisplay.speedTicksSecond = hu('#speedTicksSecond', speedoDisplay.speedometerText).css({'stroke': '#00000000', 'stroke-width': '0.4px'});
      speedoDisplay.speedTicksText  = hu('#speedTicksText', speedoDisplay.speedometerText);
      speedoDisplay.gears.P = hu('#gearP', speedoDisplay.speedometerText);
      speedoDisplay.gears.R = hu('#gearR', speedoDisplay.speedometerText);
      speedoDisplay.gears.N = hu('#gearN', speedoDisplay.speedometerText);
      speedoDisplay.gears.D = hu('#gearD', speedoDisplay.speedometerText);
      speedoDisplay.gears.S = hu('#gearS', speedoDisplay.speedometerText);
      speedoDisplay.needle = hu('#needle', speedoDisplay.root);
      speedoDisplay.needle.attr({class: "fade-in"}).css({'stroke': '#FFFFFF', 'stroke-width': '0.5px'});
      speedoDisplay.needle_bar = hu('#needle_bar', speedoDisplay.root);
      speedoDisplay.needle_bar.attr({class: "fade-in"}).css({'stroke': '#FFFFFF', 'stroke-width': '0.5px'});
	  speedoDisplay.needle_icePower = hu('#needle_icePower', speedoDisplay.root);
      speedoDisplay.needle_icePower.attr({class: "fade-in"}).css({'stroke': 'url(#radialGradient978)', 'stroke-width': '0.3px'});
	  speedoDisplay.needlebar_icePower = hu('#needlebar_icePower', speedoDisplay.root);
      speedoDisplay.needlebar_icePower.attr({class: "fade-in"}).css({'stroke': 'url(#radialGradient978)', 'stroke-width': '0.4px'});
	  speedoDisplay.needle_ePower = hu('#needle_ePower', speedoDisplay.root);
      speedoDisplay.needle_ePower.attr({class: "fade-in"}).css({'stroke': 'url(#radialGradient979)', 'stroke-width': '0.3px'});
	  speedoDisplay.needlebar_ePower = hu('#needlebar_ePower', speedoDisplay.root);
      speedoDisplay.needlebar_ePower.attr({class: "fade-in"}).css({'stroke': 'url(#radialGradient979)', 'stroke-width': '0.4px'});
	  speedoDisplay.needle_boost = hu('#needle_boost', speedoDisplay.root);
      speedoDisplay.needle_boost.attr({class: "fade-in"}).css({'stroke': 'url(#radialGradient977)', 'stroke-width': '0.3px'});
	  speedoDisplay.needlebar_boost = hu('#needlebar_boost', speedoDisplay.root);
      speedoDisplay.needlebar_boost.attr({class: "fade-in"}).css({'stroke': 'url(#radialGradient977)', 'stroke-width': '0.4px'});
	  
	  // MPH and KMH text
      TextMPH.root = hu('#layer6', svg);
	  TextMPH.root.attr({class: "fade-in"});
	  TextKMH.root = hu('#layer4', svg);
	  TextKMH.root.attr({class: "fade-in"});
	  
	  // message text
      messageBox.root = hu('#layer5', svg);
      messageBox.Capital = hu('#message_Capital', messageBox.root);
      messageBox.messageHTML = document.getElementById("message_text_html");
	  
	  text.temp_unit = hu('#temp_unit', speedoDisplay.root);
      text.outside_temp = hu('#outside_temp', speedoDisplay.root);
	  text.time = hu('#time', speedoDisplay.root);
	  text.no_message = hu('#no_message', speedoDisplay.root);
	  
	  gauges.fuel_needle = hu('#fuel_needle', speedoDisplay.root);
      gauges.fuel_needle.attr({class: "fade-in"}).css({'stroke': '#FFFFFF', 'stroke-width': '0.2px'});
	  gauges.fuel_needle_bar = hu('#fuel_needle_bar', speedoDisplay.root);
      gauges.fuel_needle_bar.attr({class: "fade-in"}).css({'stroke': '#FFFFFF', 'stroke-width': '0.3px'});
	  gauges.watertemp_needle = hu('#watertemp_needle', speedoDisplay.root);
      gauges.watertemp_needle.attr({class: "fade-in"}).css({'stroke': '#FFFFFF', 'stroke-width': '0.2px'});
	  gauges.watertemp_needle_bar = hu('#watertemp_needle_bar', speedoDisplay.root);
      gauges.watertemp_needle_bar.attr({class: "fade-in"}).css({'stroke': '#FFFFFF', 'stroke-width': '0.3px'});
	  
	  tacho.needle_tacho = hu('#needle_tacho', speedoDisplay.root);
      tacho.needle_tacho.attr({class: "fade-in"}).css({'stroke': 'url(#radialGradient964)', 'stroke-width': '0.3px'});
	  tacho.needlebar_tacho = hu('#needlebar_tacho', speedoDisplay.root);
      tacho.needlebar_tacho.attr({class: "fade-in"}).css({'stroke': 'url(#radialGradient964)', 'stroke-width': '0.4px'});

      // info
      infoDisplay.root = hu('#information', svg);
      infoDisplay.infoOverlay = hu('#infoOverlay', infoDisplay.root);
      infoDisplay.infoValues = hu('#infoValues', infoDisplay.root);
      // var ivbox = infoDisplay.root.n.getBBox()
      // console.log("infovalu", ((ivbox.y+ivbox.width/2)/svg.getBBox().width)*100,((ivbox.x+ivbox.height/2)/svg.getBBox().height)*100)

      infoDisplay.accelerometer = hu('#accelerometer', infoDisplay.root);
      infoDisplay.accelerometerMarker = hu('#accelerometerMarker', infoDisplay.accelerometer);
      infoDisplay.gXNegative = hu('#gXNegative', infoDisplay.root);
      infoDisplay.gXPositive = hu('#gXPositive', infoDisplay.root);
      infoDisplay.gYNegative = hu('#gYNegative', infoDisplay.root);
      infoDisplay.gYPositive = hu('#gYPositive', infoDisplay.root);

      consumGraph.root = hu('#consum_graph_layer', svg);
      // var cbox = consumGraph.root.n.getBBox()
      // console.log("consum_graph_layer", ((cbox.y+cbox.width/2)/svg.getBBox().width)*100,((cbox.x+cbox.height/2)/svg.getBBox().height)*100)
      consumGraph.graph_canvas = document.getElementById('consum_graph_canvas');
      consumGraph.graph_canvas_ctx = consumGraph.graph_canvas.getContext("2d");
      consumGraph.graph_canvas_gradiant_o = consumGraph.graph_canvas_ctx.createLinearGradient(0,0,0,consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_gradiant_o.addColorStop(0, 'rgba(0,204,153,0.5)');
      consumGraph.graph_canvas_gradiant_o.addColorStop(0.6, 'rgba(0,204,153,0)');
      consumGraph.graph_canvas_gradiant_o.addColorStop(1, 'rgba(0,204,153,0)');
      consumGraph.graph_canvas_gradiant_g = consumGraph.graph_canvas_ctx.createLinearGradient(0,0,0,consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_gradiant_g.addColorStop(0, 'rgba(51,51,255,0)');
      consumGraph.graph_canvas_gradiant_g.addColorStop(0.75, 'rgba(51,51,255,0)');
      consumGraph.graph_canvas_gradiant_g.addColorStop(1, 'rgba(51,51,255,0.5)');

      infoDisplay.accelerometer.css({opacity: 0})
      infoDisplay.infoValues.css({opacity: 0})
      infoDisplay.infoValuesTxt = { range: hu('#rangeTxt', infoDisplay.infoValues),
        now: hu('#nowTxt', infoDisplay.infoValues),
        avg: hu('#avgTxt', infoDisplay.infoValues),
        odo: hu('#odoTxt', infoDisplay.infoValues),
      };

      // nav
      navDisplay.root = hu('#navigation', svg);
      navDisplay.overlay = hu('#MapOverlay', navDisplay.root);

      // animations
      speedoDisplay.root.attr({class: "fade-in"}).on('webkitAnimationEnd', function (){
        //speedoDisplay.needle.attr({class: "rotate"});
      });
      speedoInitialised = true;
      speedoDisplay.needle.on('webkitAnimationEnd', function (){
        speedoInitialised = true;
      });

      speedoDisplay.speedometerText.attr({class: "grow"})
	  TextMPH.root.attr({class: "grow"})
	  TextKMH.root.attr({class: "grow"})
      infoDisplay.root.attr({class: "slide-right"});
      navDisplay.root.attr({class: "slide-left"});
      var background = hu('#background', svg);
      background.attr({class: 'map-fade'})

      // gradients
      overlayGradient.stop1 = hu('#overlayStop1', svg);
      overlayGradient.stop2 = hu('#overlayStop2', svg);
      backgroundGradient.stop1 = hu('#bgStop1', svg);
      backgroundGradient.stop2 = hu('#bgStop2', svg);
      navMarkerGradient.stop1 = hu('#navStop1', svg);
      navMarkerGradient.stop2 = hu('#navStop2', svg);
	  
	  electrics.dse.esc = hu("#light_escActive", electrics.root);

      electrics.root = hu('#lights_layer', svg);
	  electrics.root.attr({class: "fade-in"});
      electrics.lights.signal_L = hu("#light_signal_L", electrics.root);
      electrics.lights.signal_R = hu("#light_signal_R", electrics.root);
      electrics.lights.lights = hu("#light_lowbeam", electrics.root);
      electrics.lights.highbeam = hu("#light_highbeam", electrics.root);
      electrics.lights.fog = hu("#light_fog", electrics.root);
      electrics.lights.lowpressure = hu("#light_lowpressure", electrics.root);
	  electrics.abs = hu("#light_absActive", electrics.root);
      electrics.lights.parkingbrake = hu("#light_parkingbrake", electrics.root);
	  electrics.lights.oilLeak = hu("#light_oilPanLeak", electrics.root);
      electrics.lights.checkengine = hu("#light_checkengine", electrics.root);
	  electrics.lights.lowfuel = hu("#light_lowfuel", electrics.root);
	  electrics.battery = hu("#light_battery", electrics.root);
	  electrics.oiltemp = hu("#light_oiltemp", electrics.root);
      electrics.fuelTxt = hu("#fuel_pc", infoDisplay.root);
      electrics.fuelStops = [hu("#stop_fuel1", svg), hu("#stop_fuel2", svg)];

      if(new Date().getDate() ==1 && new Date().getMonth() == 3){
        var ellogo = hu('#imageLogo', svg);
        if(ellogo)ellogo.attr({href: "/core/art/missingTexture.png"});
      }
      setTheme(200);

      //default `Comfort` display graph and conso
      infoDisplay.accelerometer.css({opacity: 0});
      consumGraph.root.css({opacity: 1});
      consumGraph.graph_canvas.style.display = "inline";
      infoDisplay.infoValues.css({opacity: 1});
    }

    function updateGearIndicator(data) {
      // only update when gear is changed
      if (currentGear !== data.electrics.gear) {
        currentGear = data.electrics.gear;
        for (var key in speedoDisplay.gears) {
          if (key === data.electrics.gear) {
            speedoDisplay.gears[key].css({ fill: '#FFFFFF' })
          }
          else {
            speedoDisplay.gears[key].css({ fill: '#616161' })
          }
        }
      }
    }

    function updateSpeedDisplays(data) {
      if (speedoInitialised) {
        var speedAng = 226 + ((data.electrics.wheelspeed * 2.35));
        var startAngle=120.5*Math.PI/180, speedRad = (data.electrics.wheelspeed*unitspeedratio)+startAngle;
        var maxRad = (290*Math.PI/180) + startAngle;
        speedRad = Math.min(speedRad, maxRad);
        //console.log("maxRad",maxRad,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad-startAngle)*180/Math.PI);
        if(Math.abs(speedRad-prevspeedAng)<0.3){return;}
        speedoDisplay.speedValue.text((data.electrics.wheelspeed * (unit=="metric"?3.6:2.23694) ).toFixed(0));
		speedoDisplay.speedValueShadow.text((data.electrics.wheelspeed * (unit=="metric"?3.6:2.23694) ).toFixed(0));
        //speedoDisplay.needle.css({transform: `rotate(${speedAng}deg)` });

        var centerX=67.4, centerY=33, radiusInt=15.5, radiusExt=17.53, largeArcFlag= ((speedRad-startAngle)>Math.PI)? 1 : 0;
        //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);
        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(speedRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(speedRad) * radiusExt;

        var ex1 = (centerX) + Math.cos(speedRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(speedRad) * radiusInt;

        var mx1 = (centerX) + Math.cos(speedRad) * 8;
        var my1 = (centerY) + Math.sin(speedRad) * 8;

        speedoDisplay.needle_bar.attr({d: "M " + sx1 + "," + sy1 +
          " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
          " L " + ex1 + "," + ey1 +
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2});
        speedoDisplay.needle.attr({d: "M " + ex1 + "," + ey1 + " " +mx1+","+my1});

        for(var E in speedoDisplay.needle_gradients){
          speedoDisplay.needle_gradients[E].attr({cx:ex1,cy:ey1,fx:ex1,fy:ey1});
        }

        prevspeedAng = speedAng;
      }
    }
	
	function updateGaugeFuel(data) { 
    if (speedoInitialised) {
        // Расчет угла для поворота стрелки (By: PoonJik {KDM | MODS})
        let fuelLevel = data.electrics.fuel;
        let angle = limitVal(0, fuelLevel * 283, 283); // угол от 0 до 60, где 60 - полный бак, 0 - пустой

        // Установка поворота SVG-стрелки
        let startAngle = 124.8 * Math.PI / 180;
        let fuelRad = startAngle + angle * Math.PI / 180;

        let centerX = 88.6, centerY = 49, radiusInt = 3.1, radiusExt = 3.6, largeArcFlag = angle > 180 ? 1 : 0;
        let sx1 = centerX + Math.cos(startAngle) * radiusExt;
        let sy1 = centerY + Math.sin(startAngle) * radiusExt;

        let ex1 = centerX + Math.cos(fuelRad) * radiusInt;
        let ey1 = centerY + Math.sin(fuelRad) * radiusInt;

        let mx1 = centerX + Math.cos(fuelRad) * 3;
        let my1 = centerY + Math.sin(fuelRad) * 3;

        // Обновление пути SVG для отображения уровня топлива
        gauges.fuel_needle.attr({ d: "M " + ex1 + "," + ey1 + " " + mx1 + "," + my1 });
		
		// Обновление бара SVG для уровня топлива
        let ex2 = centerX + Math.cos(fuelRad) * radiusExt;
        let ey2 = centerY + Math.sin(fuelRad) * radiusExt;
        let sx2 = centerX + Math.cos(startAngle) * radiusInt;
        let sy2 = centerY + Math.sin(startAngle) * radiusInt;

        gauges.fuel_needle_bar.attr({
            d: "M " + sx1 + "," + sy1 +
                " A" + radiusExt + "," + radiusExt + " 0 " + largeArcFlag + ",1 " + ex2 + "," + ey2 +
                " L " + ex1 + "," + ey1 +
                " A" + radiusInt + "," + radiusInt + " 0 " + largeArcFlag + ",0 " + sx2 + "," + sy2
        });
    }
}
	
	function updateGaugeOilTemp(data, accelerationFactor = 4) {  
    if (speedoInitialised) {
        // Получаем температуру масла
        let watertemp = data.electrics.watertemp;
        let angle = limitVal(0, (watertemp - 59.5), 283)* 1 * accelerationFactor; // Рассчитываем угол с учетом ускорения (accelerationFactor)

        // Установка начального угла и радиана для поворота
        let startAngle = 124.8 * Math.PI / 180;
        let oilTempRad = startAngle + angle * Math.PI / 180;

        // Координаты центра и радиусы
        let centerX = 96.9, centerY = 49, radiusInt = 3.1, radiusExt = 3.6;
        let largeArcFlag = angle > 180 ? 1 : 0;

        // Вычисление начальных и конечных координат для SVG пути
        let sx1 = centerX + Math.cos(startAngle) * radiusExt;
        let sy1 = centerY + Math.sin(startAngle) * radiusExt;

        let ex1 = centerX + Math.cos(oilTempRad) * radiusInt;
        let ey1 = centerY + Math.sin(oilTempRad) * radiusInt;

        let mx1 = centerX + Math.cos(oilTempRad) * 3;
        let my1 = centerY + Math.sin(oilTempRad) * 3;

        // Обновление пути SVG для отображения температуры масла
        gauges.watertemp_needle.attr({ d: "M " + ex1 + "," + ey1 + " " + mx1 + "," + my1 });
		
		// Обновление бара SVG для температуры масла
        let ex2 = centerX + Math.cos(oilTempRad) * radiusExt;
        let ey2 = centerY + Math.sin(oilTempRad) * radiusExt;
        let sx2 = centerX + Math.cos(startAngle) * radiusInt;
        let sy2 = centerY + Math.sin(startAngle) * radiusInt;

        gauges.watertemp_needle_bar.attr({
            d: "M " + sx1 + "," + sy1 +
                " A" + radiusExt + "," + radiusExt + " 0 " + largeArcFlag + ",1 " + ex2 + "," + ey2 +
                " L " + ex1 + "," + ey1 +
                " A" + radiusInt + "," + radiusInt + " 0 " + largeArcFlag + ",0 " + sx2 + "," + sy2
        });
    }
}
	
	function limitVal(min, val,max){
        return Math.min(Math.max(min,val), max);
    }
	
	function updateTachoDisplays(data) { 
    if (speedoInitialised) {
        var rpmAng = 145 + (data.electrics.rpmTacho * 0.1);
        var startAngle = -163 * Math.PI / 180, rpmRad = (data.electrics.rpmTacho * 0.00031) + startAngle;
        var maxRad = (145 * Math.PI / 180) + startAngle;
        rpmRad = Math.min(rpmRad, maxRad);

        if (Math.abs(rpmRad - prevRpmAng) < 0.01) { 
            return; 
        }

        const minRadiusExtEnd = 11.22; 
        const maxRadiusExtEnd = 14.5; 
        const radiusExtEnd = minRadiusExtEnd + (maxRadiusExtEnd - minRadiusExtEnd) * (rpmRad - startAngle) / (maxRad - startAngle);

        var centerX = 67.5, centerY = 33;
        var radiusInt = 10.5;
        
        // Задаем минимальную и максимальную длину стрелки
        const minNeedleLength = 11.22; 
        const maxNeedleLength = 14.5; // Максимальная длина при полном нажатии на педаль газа
        const throttleLevel = data.electrics.throttle; // Используем data.electrics.throttle
        const needleLength = minNeedleLength + (maxNeedleLength - minNeedleLength) * throttleLevel;

        var largeArcFlag = ((rpmRad - startAngle) > Math.PI) ? 1 : 0;

        var sx2 = centerX + Math.cos(startAngle) * radiusInt;
        var sy2 = centerY + Math.sin(startAngle) * radiusInt;

        var sx1 = centerX + Math.cos(startAngle) * minNeedleLength;
        var sy1 = centerY + Math.sin(startAngle) * minNeedleLength;

        var ex2 = centerX + Math.cos(rpmRad) * minRadiusExtEnd;
        var ey2 = centerY + Math.sin(rpmRad) * minRadiusExtEnd;

        var ex3 = centerX + Math.cos(rpmRad) * minNeedleLength;
        var ey3 = centerY + Math.sin(rpmRad) * minNeedleLength;

        var ex1 = centerX + Math.cos(rpmRad) * radiusInt;
        var ey1 = centerY + Math.sin(rpmRad) * radiusInt;

        // Обновляем конечные координаты для самой стрелки, длина которой изменяется в зависимости от уровня нажатия на педаль газа
        const mx1 = centerX + Math.cos(rpmRad) * 8;
        const my1 = centerY + Math.sin(rpmRad) * 8;

        prevRpmAng = rpmRad;
		
		tacho.needlebar_tacho.attr({
            d: "M " + sx1 + "," + sy1 +
               " A" + minRadiusExtEnd + "," + minRadiusExtEnd + " 0 " + largeArcFlag + ",1 " + ex2 + "," + ey2 +
               " L " + ex1 + "," + ey1 +
               " A" + radiusInt + "," + radiusInt + " 0 " + largeArcFlag + ",0 " + sx2 + "," + sy2
        });
        tacho.needle_tacho.attr({
            d: "M " + ex1 + "," + ey1 + " " + mx1 + "," + my1
        });
    }
}
	
	function updatePowerDisplays2(data) {
    if (speedoInitialised) {
        // Определение углов и коэффициента для преобразования мощности (By: PoonJik {KDM | MODS})
        const minAngle = -217 * Math.PI / 180; // Начало шкалы E-Power в радианах
        const maxAngle = 145 * Math.PI / 180;  // Конец шкалы E-Power в радианах
        const powerCoefficient = 0.00075; // Коэффициент для перевода мощности в радианы
        
        // Преобразование мощности электромотора в угол
        let powerRad = (data.electrics.throttle * powerCoefficient) + minAngle;
        powerRad = Math.min(powerRad, maxAngle); // Ограничение угла до maxAngle

        // Проверка на минимальное изменение угла для обновления
        if (Math.abs(powerRad - prevPowerAng) < 0.01) {
            return;
        }

        // Центр и радиусы для отображения стрелки E-Power
        const centerX = 67.5, centerY = 33;
        const radiusInt = 13.5, radiusExt = 14.5;

        // Определение флага для дуги (если угол больше 180°)
        const largeArcFlag = ((powerRad - minAngle) > Math.PI) ? 1 : 0;

        // Начальные координаты дуг (внутренняя и внешняя) для стрелки
        const sx1 = centerX + Math.cos(minAngle) * radiusExt;
        const sy1 = centerY + Math.sin(minAngle) * radiusExt;
        const sx2 = centerX + Math.cos(minAngle) * radiusInt;
        const sy2 = centerY + Math.sin(minAngle) * radiusInt;

        // Конечные координаты дуг для стрелки на основе угла powerRad
        const ex1 = centerX + Math.cos(powerRad) * radiusInt;
        const ey1 = centerY + Math.sin(powerRad) * radiusInt;
        const ex2 = centerX + Math.cos(powerRad) * radiusExt;
        const ey2 = centerY + Math.sin(powerRad) * radiusExt;

        // Конечная точка наконечника стрелки
        const mx1 = centerX + Math.cos(powerRad) * 8;
        const my1 = centerY + Math.sin(powerRad) * 8;

        // Обновляем значение предыдущего угла
        prevPowerAng = powerRad;

        // Построение SVG пути для стрелки E-Power
        speedoDisplay.needlebar_ePower.attr({
            d: "M " + sx1 + "," + sy1 +
               " A" + radiusExt + "," + radiusExt + " 0 " + largeArcFlag + ",1 " + ex2 + "," + ey2 +
               " L " + ex1 + "," + ey1 +
               " A" + radiusInt + "," + radiusInt + " 0 " + largeArcFlag + ",0 " + sx2 + "," + sy2
        });
        
        // Обновление наконечника стрелки
        speedoDisplay.needle_ePower.attr({d: "M " + ex1 + "," + ey1 + " " +mx1+","+my1});
    }
}

function updateICEPowerDisplay(data) {
    if (speedoInitialised) {
        // Углы и коэффициенты для отображения стрелки ICE против часовой стрелки (By: PoonJik {KDM | MODS})
        const minAngle = 107 * Math.PI / 180;    // Начало шкалы Power (ICE) в радианах (максимум)
        const maxAngle = -163 * Math.PI / 180;   // Конец шкалы Power (ICE) в радианах (минимум)
        const icePowerCoefficient = 0.00025;     // Коэффициент для перевода мощности ICE в радианы (настройка при необходимости)

        // Преобразуем мощность ICE в угол, инвертируя значение
        let icePowerRad = minAngle - (data.customModules.combustionEngineData.currentPower * icePowerCoefficient);
        icePowerRad = Math.max(icePowerRad, maxAngle); // Ограничиваем угол до maxAngle

        // Проверка на минимальное изменение угла
        if (Math.abs(icePowerRad - prevIcePowerAng) < 0.01) {
            return;
        }

        // Центр и радиусы для отображения стрелки Power (ICE)
        const centerX = 67.5, centerY = 33;
        const radiusInt = 13.5, radiusExt = 14.5;

        // Флаг для дуги (если угол больше 180°)
        const largeArcFlag = ((icePowerRad - minAngle) < -Math.PI) ? 1 : 0;

        // Начальные координаты дуг (внутренняя и внешняя) для стрелки Power (ICE)
        const sx1 = centerX + Math.cos(minAngle) * radiusExt;
        const sy1 = centerY + Math.sin(minAngle) * radiusExt;
		
        const sx2 = centerX + Math.cos(minAngle) * radiusInt;
        const sy2 = centerY + Math.sin(minAngle) * radiusInt;

        // Конечные координаты дуг для стрелки на основе угла icePowerRad
        const ex1 = centerX + Math.cos(icePowerRad) * radiusInt;
        const ey1 = centerY + Math.sin(icePowerRad) * radiusInt;
		
        const ex2 = centerX + Math.cos(icePowerRad) * radiusExt;
        const ey2 = centerY + Math.sin(icePowerRad) * radiusExt;

        // Конечная точка наконечника стрелки
        const mx1 = centerX + Math.cos(icePowerRad) * 8;
        const my1 = centerY + Math.sin(icePowerRad) * 8;

        // Обновляем значение предыдущего угла
        prevIcePowerAng = icePowerRad;

        // Построение SVG пути для стрелки Power (ICE)
        speedoDisplay.needlebar_icePower.attr({
            d: "M " + sx1 + "," + sy1 +
               " A" + radiusExt + "," + radiusExt + " 0 " + largeArcFlag + ",0 " + ex2 + "," + ey2 + 
               " L " + ex1 + "," + ey1 +
               " A" + radiusInt + "," + radiusInt + " 0 " + largeArcFlag + ",1 " + sx2 + "," + sy2 
        });
        
        // Обновление наконечника стрелки
        speedoDisplay.needle_icePower.attr({
            d: "M " + ex1 + "," + ey1 + " " + mx1 + "," + my1
        });
    }
}
	
	function updatePowerDisplays(data) {
    if (speedoInitialised) {
        // Конвертация boost турбины (Bar) в угол для стрелки boost (By: PoonJik {KDM | MODS})
        var BarAng = 145 - (data.electrics.throttle * 0.2); // Изменено направление на положительное
        var startAngle = 143 * Math.PI / 180, ThrottleRad = startAngle + (data.electrics.throttle * 0.491); // Изменено направление на отрицательное
        var maxRad = (145 * Math.PI / 180) + startAngle;
        ThrottleRad = Math.min(ThrottleRad, maxRad); // Ограничение максимального угла

        // Если изменение угла минимально, то не обновляем
        if (Math.abs(ThrottleRad - prevBarAng) < 0.01) { 
            return; 
        }

        // Вычисляем координаты для отображения стрелки boost
        var centerX = 67.5, centerY = 33, radiusInt = 13.5, radiusExt = 14.5;
        var largeArcFlag = ((ThrottleRad - startAngle) > Math.PI) ? 1 : 0; // Изменено для против часовой стрелки
		
		// Вычисляем начальные координаты для дуг стрелки boost (начальная часть фиксированная)
        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;
		
		// Вычисляем конечные координаты для дуг стрелки boost (длина увеличивается)
        var ex2 = (centerX) + Math.cos(ThrottleRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(ThrottleRad) * radiusExt;
		
        var ex1 = (centerX) + Math.cos(ThrottleRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(ThrottleRad) * radiusInt;

        // Вычисляем конечную точку для самой стрелки (длина меняется в зависимости от bar)
        const mx1 = centerX + Math.cos(ThrottleRad) * 8;
        const my1 = centerY + Math.sin(ThrottleRad) * 8;

        // Обновляем значение предыдущего угла для предотвращения лишних обновлений
        prevBarAng = ThrottleRad;

        // Здесь можно добавить код для обновления визуальной части стрелки boost
        speedoDisplay.needlebar_ePower.attr({
            d: "M " + sx1 + "," + sy1 +
               " A" + radiusExt + "," + radiusExt + " 0 " + largeArcFlag + ",1 " + ex2 + "," + ey2 + // Изменено на 0
               " L " + ex1 + "," + ey1 +
               " A" + radiusInt + "," + radiusInt + " 0 " + largeArcFlag + ",0 " + sx2 + "," + sy2 // Изменено на 1
        });
        speedoDisplay.needle_ePower.attr({d: "M " + ex1 + "," + ey1 + " " +mx1+","+my1});
    }
}
	
	function updateBoostDisplays(data) {
    if (speedoInitialised) {
        // Конвертация boost турбины (Bar) в угол для стрелки boost (By: PoonJik {KDM | MODS})
        var BarAng = 145 - (data.electrics.turboBoost * 0.2); // Изменено направление на положительное
        var startAngle = 36 * Math.PI / 180, BarRad = startAngle - (data.electrics.turboBoost * 0.021); // Изменено направление на отрицательное
        var maxRad = (145 * Math.PI / 180) + startAngle;
        BarRad = Math.min(BarRad, maxRad); // Ограничение максимального угла

        // Если изменение угла минимально, то не обновляем
        if (Math.abs(BarRad - prevBarAng) < 0.01) { 
            return; 
        }

        // Вычисляем координаты для отображения стрелки boost
        var centerX = 67.5, centerY = 33, radiusInt = 13.5, radiusExt = 14.5;
        var largeArcFlag = ((BarRad - startAngle) < -Math.PI) ? 1 : 0; // Изменено для против часовой стрелки
		
		// Вычисляем начальные координаты для дуг стрелки boost (начальная часть фиксированная)
        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;
		
		// Вычисляем конечные координаты для дуг стрелки boost (длина увеличивается)
        var ex2 = (centerX) + Math.cos(BarRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(BarRad) * radiusExt;
		
        var ex1 = (centerX) + Math.cos(BarRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(BarRad) * radiusInt;

        // Вычисляем конечную точку для самой стрелки (длина меняется в зависимости от bar)
        const mx1 = centerX + Math.cos(BarRad) * 8;
        const my1 = centerY + Math.sin(BarRad) * 8;

        // Обновляем значение предыдущего угла для предотвращения лишних обновлений
        prevBarAng = BarRad;

        // Здесь можно добавить код для обновления визуальной части стрелки boost
        speedoDisplay.needlebar_boost.attr({
            d: "M " + sx1 + "," + sy1 +
               " A" + radiusExt + "," + radiusExt + " 0 " + largeArcFlag + ",0 " + ex2 + "," + ey2 + // Изменено на 0
               " L " + ex1 + "," + ey1 +
               " A" + radiusInt + "," + radiusInt + " 0 " + largeArcFlag + ",1 " + sx2 + "," + sy2 // Изменено на 1
        });
        speedoDisplay.needle_boost.attr({d: "M " + ex1 + "," + ey1 + " " +mx1+","+my1});
    }
}

    function updateAccelerometer(data) {
      infoDisplay.accelerometer.css({opacity: 1})
      infoDisplay.accelerometerMarker.css({transformOrigin: '50% 50%', transform: `translate(${limitVal(-10,data.customModules.accelerationData.xSmooth,10)/1.4}px, ${-limitVal(-10,data.customModules.accelerationData.ySmooth,10)/1.4}px`})
      var roundedGX2 = (data.customModules.accelerationData.xSmooth / 10).toFixed(1);
      var roundedGY2 = (-data.customModules.accelerationData.ySmooth / 10).toFixed(1);
      infoDisplay.gXPositive.text(roundedGX2 > 0 ? roundedGX2  : 0)
      infoDisplay.gXNegative.text(roundedGX2 < 0 ? -roundedGX2 : 0)
      infoDisplay.gYNegative.text(roundedGY2 > 0 ? roundedGY2  : 0)
      infoDisplay.gYPositive.text(roundedGY2 < 0 ? -roundedGY2 : 0)
    }

    $window.redrawSpeedoTicks = (lim,bigSep,smallSep) => {
      var startAngle=-227*Math.PI/180;
      var centerX=67.4, centerY=33, radiusInt=14, radiusExt=10.5, radiusIntBig=14;
      var tickD = "";
      for(var ib = 0; ib<= (lim/bigSep) ; ib++){
        for(var is = -25; is<= (bigSep/smallSep); is++){
          var curAng = (ib*335.2/(lim/bigSep)+335.2*(1/(lim/bigSep))*(is/(bigSep/smallSep))) *Math.PI/362;
          if(curAng > (1.5*Math.PI)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }
	  
	  var tickD2 = "";
	  radiusInt=0;
	  radiusExt=10.4;
	  radiusIntBig=15.5;
      for(var ib = -22; ib<= (lim/bigSep) ; ib++){
        for(var is = 0; is<= (bigSep/smallSep); is++){
          var curAng = (ib*67/(lim/bigSep)+67*(1/(lim/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng > (1.5*Math.PI)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusExt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusExt);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickD2 += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }
      var testStyle = {"font-style":"normal","font-weight":"bold","font-stretch":"normal","font-family":"Arial","fill":"#00000000","fill-opacity":1,"stroke-width":0.04861574,"text-align":"center","text-anchor":"middle"};
      for(var ib = 0; ib<=(lim/bigSep) ; ib++){
        var curAng = (ib*270/(lim/bigSep)) *Math.PI/180;
        var sx = (centerX) + Math.cos(startAngle+curAng) * 14;
        var sy = (centerY + 0.90) + Math.sin(startAngle+curAng) * 14;
        var ts = hu('<tspan>', speedoDisplay.speedTicksText)
        .attr({x: sx,y: sy})
        .text((ib*bigSep))
        .css(testStyle);
      }
    }

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      //console.log("setUnits", data.unit);
      unit = data.uiUnitLength;
      if( unit == "metric"){
        redrawSpeedoTicks(data.maxKPH,data.speedoMetricSepBig,data.speedoMetricSepSmall);
        unitspeedratio = 2.57/data.maxKPH*Math.PI*1.5;
        speedoDisplay.speedUnit.text("km/h");
		speedoDisplay.SpeedUnitShadow.text("km/h");
        TextMPH.root.css("display", "none");
		TextKMH.root.css("display", "inline");
      }
      else{
        redrawSpeedoTicks(data.maxMPH,data.speedoImperialSepBig,data.speedoImperialSepSmall);
        unitspeedratio = 1.31994/data.maxMPH*Math.PI*1.5;
        speedoDisplay.speedUnit.text("mph");
		speedoDisplay.SpeedUnitShadow.text("mph");
		TextMPH.root.css("display", "inline");
		TextKMH.root.css("display", "none");
      }
	  
	  units.uiUnitTemperature = data.uiUnitTemperature || ""
    }


    $window.initMap = (data) => {
      navDimensions = data.viewParams = [
        data.terrainOffset[0],
        data.terrainOffset[1],
        data.terrainSize[0],
        data.terrainSize[1]
      ];

      $scope.$apply(() => {
        vm.mapData = data;
      });

      navContainer.style.width = data.terrainSize[0] + "px";
      navContainer.style.height = data.terrainSize[1] + "px";
    }

    $window.updateMap = (data) => {
      var focusX = -data.x;
      var focusY = data.y;
      var origin = `${((navDimensions[0] * -1)) - focusX}px ${((navDimensions[1] * -1)) - focusY}px`;
      navContainer.style.transformOrigin = origin;
      var translateX = ((((navDimensions[0])) + 512) + focusX);
      var translateY = ((((navDimensions[1])) + 256) + focusY);
      navContainer.style.transform = `translate3d(${translateX}px,${translateY}px, 0px) rotateX(${55}deg) rotateZ(${180 + (data.rotation + 360)}deg) scale(1)`;
    }

    var hue = 0;

    function appendGraphConsumption(data)  {
      var newCurrent = data.customModules.combustionEngineData.averageConsumption
      if( newCurrent === undefined || newCurrent === null)
        return;
      newCurrent = newCurrent * 0.001
      var unitOffset = -300, unitY = 1200, stepPx=4;
      if( consumGraph.graph_canvas_ctx == undefined){
        console.error(consumGraph);
        return;
      }
      var colors = ["#00cc99", "#3333ff"];//consum, regen

      //var prevGraph = consumGraph.graph_canvas_ctx.createImageData(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_ctx.putImageData(consumGraph.graph_canvas_ctx.getImageData(stepPx, 0, consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height), 0, 0);
      //consumGraph.graph_canvas_ctx.drawImage(consumGraph.graph_canvas, -stepPx, 0);
      consumGraph.graph_canvas_ctx.clearRect(consumGraph.graph_canvas.width-stepPx, 0, stepPx, consumGraph.graph_canvas.height);
      //consumGraph.graph_canvas_ctx.fillRect(consumGraph.graph_canvas.width-stepPx, 0, stepPx, consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_ctx.strokeStyle = colors[0];
      consumGraph.graph_canvas_ctx.lineWidth = 2;
      consumGraph.graph_canvas_ctx.beginPath();
      if(consumGraph.values.current >0 && newCurrent>0){ //ALL ORANGE
        consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY );
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.stroke();
        consumGraph.graph_canvas_ctx.beginPath();
        consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY );
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.closePath();
        consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_o;
        consumGraph.graph_canvas_ctx.fill();
      }
      else if(consumGraph.values.current <=0 && newCurrent<=0){ //ALL GREEN
        consumGraph.graph_canvas_ctx.strokeStyle = colors[1];
        consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY );
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.stroke();
        consumGraph.graph_canvas_ctx.beginPath();
        consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY );
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.closePath();
        consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_g;
        consumGraph.graph_canvas_ctx.fill();
      }
      else{//TRANSITION
        var bp = stepPx*(consumGraph.values.current)/(consumGraph.values.current - newCurrent);
        if(consumGraph.values.current < newCurrent){ //UP
          consumGraph.graph_canvas_ctx.strokeStyle = colors[1];
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.stroke();
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.closePath();
          consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_g;
          consumGraph.graph_canvas_ctx.fill();

          consumGraph.graph_canvas_ctx.strokeStyle = colors[0];
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.stroke();
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.closePath();
          consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_o;
          consumGraph.graph_canvas_ctx.fill();
        }
        else{ //DW
          consumGraph.graph_canvas_ctx.strokeStyle = colors[0];
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.stroke();
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.closePath();
          consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_o;
          consumGraph.graph_canvas_ctx.fill();

          consumGraph.graph_canvas_ctx.strokeStyle = colors[1];
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.stroke();
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.closePath();
          consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_g;
          consumGraph.graph_canvas_ctx.fill();
        }
      }
      consumGraph.values.current = newCurrent;
    }

    function updateConsumption(data) {
      infoDisplay.infoValuesTxt.now.text( (data.customModules.combustionEngineData.currentPower / 1.35962).toFixed(0) + " kW" ); //PS to kW

      if(data.customModules.combustionEngineData.averagePower == undefined || data.customModules.combustionEngineData.remainingRange == undefined){return;}
      infoDisplay.infoValuesTxt.avg.text( (data.customModules.combustionEngineData.averagePower / 1.35962).toFixed(0) + " kW" ); //PS to kW
      infoDisplay.infoValuesTxt.range.text( (data.customModules.combustionEngineData.remainingRange).toFixed(0) + (unit==="metric"?" km":" mi") );
    }


    function setElec(val, state, key){
      if( val === undefined || val === null){/*console.error("setElec: svg element not found", key);*/ return;}
      if( state === undefined || state === null){/*console.error("setElec: state not found", key);*/ return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
      val.n.style.display = cssState;
    }

    $window.updateElectrics = (data) => {
      for(var k in electrics.lights){
        setElec(electrics.lights[k], data.electrics[k], k);
      }
	  if(units.uiUnitTemperature == "c" || units.uiUnitTemperature == "k"){
        let envTemp = data.customModules.environmentData.temperatureEnv
        text.outside_temp.text( envTemp.toFixed(0) );
        text.temp_unit.text( "°C" );
      }else{
        let envTemp = (data.customModules.environmentData.temperatureEnv * 9/5) + 32
        text.outside_temp.text( envTemp.toFixed(0) );
        text.temp_unit.text( "°F" );
      }
	  electrics.dse.esc.n.style.display = (data.electrics["escActive"] || data.electrics["esc"]==1 || data.electrics["tcsActive"] || data.electrics["tcs"]==1) ?"inline":"none";
      if( electrics.dse.esc.n.classList.contains("blink") !== (data.electrics["escActive"] || data.electrics["tcsActive"])){
        electrics.dse.esc.n.classList.toggle("blink", (data.electrics["escActive"] || data.electrics["tcsActive"]));
      }
	  electrics.abs.n.style.display = (data.electrics["absActive"] || data.electrics["abs"]==1) ?"inline":"none";
      if( electrics.abs.n.classList.contains("blink") !== (data.electrics["absActive"])){
        electrics.abs.n.classList.toggle("blink", (data.electrics["absActive"]));
      }
	  electrics.battery.n.style.display = (data.electrics.engineRunning<0.1&&data.electrics.startStopActive===0)?"inline":"none";
	  electrics.oiltemp.n.style.display = (data.electrics.oiltemp>150&&data.electrics.startStopActive===0)?"inline":"none";
    }
	
	$window.switchMessage = (data) => {
      if (data.hide) {
        messageBox.root.css("display", "none")
        messageBox.messageHTML.innerText = ""
      } else {
        messageBox.root.css("display", "inline")
        messageBox.Capital.text(data.messageCapital || "")
        //messageBox.message.text(data.messageText || "")
        //if (data.messageText2) {
        //  messageBox.messageTwo.text(data.messageText2 || "")
        //}
        messageBox.messageHTML.innerText = (data.messageText || "")
      }
    }
	
	function fixClock(v, fill="0"){
      return (v<10)? fill+v : v;
    }

    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        // console.log(data);
        //hue = (hue+.5) % 360;
        //setTheme(hue);

        // Update PRNDS display
        updateGearIndicator(data);
        // Update Speed displays
        updateSpeedDisplays(data);
		updateBoostDisplays(data);
		updatePowerDisplays(data);
		updateICEPowerDisplay(data);
		// Update Tacho displays
		updateTachoDisplays(data);
		// Update Gauge displays
		updateGaugeFuel(data);
		updateGaugeOilTemp(data);

        updateElectrics(data);
		
		const current_time = new Date(Date.now());
        text.time.text(fixClock(current_time.getHours()) + ":" + fixClock(current_time.getMinutes()));
      }
    }

    //https://stackoverflow.com/a/56266358
    function isColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color !== "";
    }

    function parseColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color;
    }

    function getHue(rgb){
      let sep = rgb.indexOf(",") > -1 ? "," : " ";
      rgb = rgb.substr(4).split(")")[0].split(sep);

      for (let R in rgb) {
        let r = rgb[R];
        if (r.indexOf("%") > -1)
          rgb[R] = Math.round(r.substr(0,r.length - 1) / 100 * 255);
      }

      // Make r, g, and b fractions of 1
      let r = rgb[0] / 255,
          g = rgb[1] / 255,
          b = rgb[2] / 255;


      // Find greatest and smallest channel values
      let cmin = Math.min(r,g,b),
          cmax = Math.max(r,g,b),
          delta = cmax - cmin,
          h = 0,
          s = 0,
          l = 0;

      // Calculate hue
      // No difference
      if (delta == 0)
        h = 0;
      // Red is max
      else if (cmax == r)
        h = ((g - b) / delta) % 6;
      // Green is max
      else if (cmax == g)
        h = (b - r) / delta + 2;
      // Blue is max
      else
        h = (r - g) / delta + 4;

      h = Math.round(h * 60);

      // Make negative hues positive behind 360°
      if (h < 0)
          h += 360;
      return h;
    }

    $window.updateMode = (data) => {
      if(!ready){
        console.log("calling updateMode while svg not fully loaded");
        setTimeout(function(){ $window.updateMode(data) }, 100);
        return;
      }
      if(data === null
      || data === undefined
      || data.modeName === null
      || data.modeName === undefined
      || typeof data.modeName !== "string"
      || data.modeColor === null
      || data.modeColor === undefined
      || typeof data.modeColor !== "string"){
        console.error("updateMode receive wrong arguments :", data);
        document.getElementById("layer_wip").style.display = "inline";
        document.getElementById("tspan995").innerHTML = "MODE";
        return;
      }
      if(!isColor(data.modeColor)){
        console.error("This mode color is not in html format :",data.modeColor)
        return;
      }
      //console.log(data.modeColor);
      let h = getHue(parseColor(data.modeColor));
      setTheme(h);

      gForcesVisible = data.modeName != "Comfort";

      if (gForcesVisible === true) {
        consumGraph.root.css({opacity: 0});
        infoDisplay.infoValues.css({opacity: 0});
        consumGraph.graph_canvas.style.display = "none";
      }
      else {
        infoDisplay.accelerometer.css({opacity: 0});
        consumGraph.root.css({opacity: 1});
        consumGraph.graph_canvas.style.display = "inline";
        infoDisplay.infoValues.css({opacity: 1});
      }

    }
    ready = true;
    //$window.updateConsumption({current:0, average:0, range:0});
  });