--[[
================================================================================================================================
										This code was modified by JSD
                                      -Original code was made by stein-
================================================================================================================================
]]--
local M = {}

local drivetrain4wdSmoother = newExponentialSmoothing(10)
local wiperValSmoother = newExponentialSmoothing(5)
local wiperStalkSmoother = newExponentialSmoothing(5)
local keySmoother = newExponentialSmoothing(10)
local gear_A_Smoother = newExponentialSmoothing(10)

local queueWiperSwing = false
local wiperSwing = false
local wipersEnabled = 0
local wiperForward = false
local wiperTimer = 0
local wiperMaxTimer = 150
local playSnd = true
local speed = 2

local function onInit()
    print("ANIMATED WIPERS MOD - Creating Sounds...")
    sounds.createSFXSource("vehicles/arbgtrackhawk/wiper_loop.ogg", 'AudioDefault3D', "WiperLoop", v.data.refNodes[0].ref)
    --sounds.createSFXSource("art/sound/wax_off.ogg", 'AudioDefault3D', "WiperOff", v.data.refNodes[0].ref)

    wiperTimer = 0

    electrics.values['wiperVal'] = 0

    speed = 2
end

local function reset()
  onInit()
end

local function updateGFX(dt)
    electrics.values['wipers'] = 1-(wipersEnabled / 2)
        if(wipersEnabled == 0 and input.keys.O == 1) then
            gui.message("Wipers: Slow", 5, "wiperMsg")
            wipersEnabled = 1
            wiperMaxTimer = 120
			wiperTimer = 0
				queueWiperSwing = true
				wiperForward = true
                speed = 2
        end
		
    if(wipersEnabled == 0 and input.keys.O == 0) then
            gui.message("Wipers: Off", 5, "wiperMsg")
            wipersEnabled = 0
			wiperTimer = 0
				queueWiperSwing = true
				wiperForward = false
                speed = 2
		end
		
		if(wipersEnabled == 1 and input.keys.O == 0) then
            gui.message("Wipers: Fast", 5, "wiperMsg")
            wipersEnabled = 2
            wiperMaxTimer = 30
			wiperTimer = 0
				queueWiperSwing = true
				wiperForward = true
                speed = 2
        end
		
		if(wipersEnabled == 2 and input.keys.O == 1) then
            gui.message("Wipers: Faster", 5, "wiperMsg")
            wipersEnabled = 3
            wiperMaxTimer = 25
			wiperTimer = 0
				queueWiperSwing = true
				wiperForward = true
                speed = 2.25
        end
		
		if(wipersEnabled == 3 and input.keys.O == 0) then
            gui.message("Wipers: Fastest", 5, "wiperMsg")
            wipersEnabled = 4
            wiperMaxTimer = 20
			wiperTimer = 0
				queueWiperSwing = true
				wiperForward = true
                speed = 3
        end
		
		if(wipersEnabled == 4 and input.keys.O == 1) then
            gui.message("Wipers: Off", 5, "wiperMsg")
            wipersEnabled = 0
			input.keys.O = 0
			wiperTimer = 0
				queueWiperSwing = true
				wiperForward = false
                speed = 2
        end
        
    if(not wiperForward and wipersEnabled > 0) then
        wiperTimer = wiperTimer + 1
        if(wiperTimer > wiperMaxTimer) then
            queueWiperSwing = true
            wiperForward = true
            wiperTimer = 0
        end
    end
    if(not queueWiperSwing) then
        electrics.values['wiperVal'] = 0
        playSnd = true
    end

    if(queueWiperSwing) then
        if(playSnd) then
            print("Sound!!")
            sounds.playSoundOnceAtNode("WiperLoop", v.data.refNodes[0].ref, 1)
            playSnd = false
        end
        local lerpVal = 10
        local spd = math.abs(electrics.values['wiperVal'] - 1) / lerpVal
        if(spd > 0.02) then spd = 0.02 end

        if(wiperForward) then
            electrics.values['wiperVal'] = electrics.values['wiperVal'] + spd*speed
            if(electrics.values['wiperVal'] >= 0.95) then wiperForward = false end
        else
            electrics.values['wiperVal'] = electrics.values['wiperVal'] - spd*speed
            if(electrics.values['wiperVal'] < 0) then 
                queueWiperSwing = false
                wiperForward = false
            end
        end
    end
	
	if electrics.values['wiperVal'] >= 1 then
		electrics.values['wiperVal'] = 1
	end
	
	if electrics.values['wiperVal'] <= 0 then
		electrics.values['wiperVal'] = 0
	end
	
end

-- public interface
M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M