local M = {}

local function onReset()
  electrics.values['toggle_multicolor'] = 0
  electrics.values['multicolor_input'] = 0
end

local function onInit()
  electrics.values['toggle_multicolor'] = 0
  electrics.values['multicolor_input'] = 0
end

local time = 1
local function getPositiveAngleDiff(a, b)
    return a < b and a+360-b or a-b
end
-- returns r, g and b
local function getRainbowRGB(num)
    local angle = num*360
    local components = {}
    for i = 1, 3 do
        local startAngle = ((i+1)*120)%360
        local diffFromStart = getPositiveAngleDiff(angle, startAngle)
        if diffFromStart < 60 then
            components[i] = diffFromStart/60*255
        elseif diffFromStart <= 180 then
            components[i] = 255
        elseif diffFromStart < 240 then
            components[i] = (240-diffFromStart)/60*255
        else
            components[i] = 0
        end
    end
    return components[1], components[2], components[3]
end

local function updateGFX(dt)
	if electrics.values['multicolor_input'] == 1 then
	  time = time + dt
	  local COLOR_1, COLOR_2, COLOR_3 = getRainbowRGB(time)
	  local Roughness = 1
	  obj:queueGameEngineLua("scripts_bastionrainbow_extension.rainbow_Mode(" .. COLOR_1 .. "," .. COLOR_2 .. "," .. COLOR_3 .. "," .. Roughness .. ")")
	  if time > 1 then
		time = 0
	  end
	end	
end



M.onInit    = onInit
M.onReset   = onReset
M.updateGFX = updateGFX
M.rainbow_Mode = rainbow_Mode
M.getRainbowRGB = getRainbowRGB


return M
