local M = {}

local current_window_sfx_L = nil
local current_window_sfx_R = nil

local LEFT_WINDOW_NODE = "d5l"
local RIGHT_WINDOW_NODE = "d5r"

local SOUNDS = {
  up = "/vehicles/RLA_A90/sounds/Window Up.ogg",
  down = "/vehicles/RLA_A90/sounds/Window Down.ogg"
}

local function resolveNodeIDs()
  local v = _G.v
  local nodeMap = {}
  if v and v.data and v.data.nodes then
    for _, node in pairs(v.data.nodes) do
      if node.name then
        nodeMap[node.name] = node.cid
      end
    end
  end
  return nodeMap[LEFT_WINDOW_NODE] or 0, nodeMap[RIGHT_WINDOW_NODE] or 0
end

local function sanitizeObjectName(path)
  return path:gsub("/", "_")
end

local function playWindowSound(sound_path, isRight)
  if sound_path then
    local current_sfx = isRight and current_window_sfx_R or current_window_sfx_L
    local leftNode, rightNode = resolveNodeIDs()
    local nodeID = isRight and rightNode or leftNode
    
    if not current_sfx then
      local safe_name = sanitizeObjectName(sound_path) .. (isRight and "_R" or "_L")
      local sfx_to_play = obj:createSFXSource(sound_path, "AudioDefault3D", safe_name, nodeID)
      obj:setVolumePitch(sfx_to_play, 3, 1)
      obj:playSFX(sfx_to_play)
      if isRight then
        current_window_sfx_R = sfx_to_play
      else
        current_window_sfx_L = sfx_to_play
      end
    end
  end
end

local function stopSound(isRight)
  if isRight then
    if current_window_sfx_R then
      obj:stopSFX(current_window_sfx_R)
      obj:deleteSFXSource(current_window_sfx_R)
      current_window_sfx_R = nil
    end
  else
    if current_window_sfx_L then
      obj:stopSFX(current_window_sfx_L)
      obj:deleteSFXSource(current_window_sfx_L)
      current_window_sfx_L = nil
    end
  end
end

local function updateGFX(dt)
  if not electrics then return end
  if electrics.values.ignitionLevel == 0 then return end

  if not electrics.values.RLA_A90_glass_L then
    electrics.values.RLA_A90_glass_L = 0
    electrics.values.RLA_A90_glass_L_down = 0
    electrics.values.RLA_A90_glass_L_up = 0
    electrics.values.RLA_A90_glass_R = 0
    electrics.values.RLA_A90_glass_R_down = 0
    electrics.values.RLA_A90_glass_R_up = 0
    electrics.values.RLA_A90_glass_LR_down = 0
    electrics.values.RLA_A90_glass_LR_up = 0
  end

  local speed = 0.00575 * (dt/0.016667)

  if electrics.values.RLA_A90_glass_LR_down == 1 then
    playWindowSound(SOUNDS.down, false)
    playWindowSound(SOUNDS.down, true)
    
    electrics.values.RLA_A90_glass_L = math.min(1, electrics.values.RLA_A90_glass_L + speed)
    electrics.values.RLA_A90_glass_R = math.min(1, electrics.values.RLA_A90_glass_R + speed)
    
    if electrics.values.RLA_A90_glass_L >= 1 then
      stopSound(false)
    end
    if electrics.values.RLA_A90_glass_R >= 1 then
      stopSound(true)
    end
  elseif electrics.values.RLA_A90_glass_LR_up == 1 then
    playWindowSound(SOUNDS.up, false)
    playWindowSound(SOUNDS.up, true)
    
    electrics.values.RLA_A90_glass_L = math.max(0, electrics.values.RLA_A90_glass_L - speed)
    electrics.values.RLA_A90_glass_R = math.max(0, electrics.values.RLA_A90_glass_R - speed)
    
    if electrics.values.RLA_A90_glass_L <= 0 then
      stopSound(false)
    end
    if electrics.values.RLA_A90_glass_R <= 0 then
      stopSound(true)
    end
  else
    if electrics.values.window_lock_R ~= 1 then
      if electrics.values.RLA_A90_glass_L_down == 1 then
        playWindowSound(SOUNDS.down, false)
        electrics.values.RLA_A90_glass_L = math.min(1, electrics.values.RLA_A90_glass_L + speed)
        if electrics.values.RLA_A90_glass_L >= 1 then
          stopSound(false)
        end
      elseif electrics.values.RLA_A90_glass_L_up == 1 then
        playWindowSound(SOUNDS.up, false)
        electrics.values.RLA_A90_glass_L = math.max(0, electrics.values.RLA_A90_glass_L - speed)
        if electrics.values.RLA_A90_glass_L <= 0 then
          stopSound(false)
        end
      else
        stopSound(false)
      end
    end

    if electrics.values.window_lock ~= 1 then
      if electrics.values.RLA_A90_glass_R_down == 1 then
        playWindowSound(SOUNDS.down, true)
        electrics.values.RLA_A90_glass_R = math.min(1, electrics.values.RLA_A90_glass_R + speed)
        if electrics.values.RLA_A90_glass_R >= 1 then
          stopSound(true)
        end
      elseif electrics.values.RLA_A90_glass_R_up == 1 then
        playWindowSound(SOUNDS.up, true)
        electrics.values.RLA_A90_glass_R = math.max(0, electrics.values.RLA_A90_glass_R - speed)
        if electrics.values.RLA_A90_glass_R <= 0 then
          stopSound(true)
        end
      else
        stopSound(true)
      end
    end
  end
end

local function onExtensionLoaded()
end

local function reset()
  guihooks.message("Official Mod From RedlineAuto", 1, nil, "verified_user")
  stopSound(false)
  stopSound(true)
  electrics.values.RLA_A90_glass_L = 0
  electrics.values.RLA_A90_glass_R = 0
end

local function onVehicleActiveChanged(active)
  if active then
    electrics.registerHandler("updateGFX", updateGFX)
  else
    stopSound(false)
    stopSound(true)
  end
end

local function destroy()
  stopSound(false)
  stopSound(true)
end

M.onVehicleActiveChanged = onVehicleActiveChanged
M.onReset = reset
M.updateGFX = updateGFX
M.onExtensionLoaded = onExtensionLoaded
M.destroy = destroy

return M
