local M = {}

local leftSignalActive = false
local leftSequenceTimer = 0
local leftSequenceStep = 0
local lastLeftSignalState = 0

local rightSignalActive = false
local rightSequenceTimer = 0
local rightSequenceStep = 0
local lastRightSignalState = 0

local stepDuration = 0.05

local function onInit()
    electrics.values.signal_L_1 = 0
    electrics.values.signal_L_2 = 0
    electrics.values.signal_L_3 = 0
    electrics.values.signal_L_4 = 0
    
    electrics.values.signal_R_1 = 0
    electrics.values.signal_R_2 = 0
    electrics.values.signal_R_3 = 0
    electrics.values.signal_R_4 = 0
end

local function updateGFX(dt)
    local currentLeftSignalState = electrics.values.signal_L or 0
    local currentRightSignalState = electrics.values.signal_R or 0
    
    if currentLeftSignalState == 1 and lastLeftSignalState == 0 then
        leftSignalActive = true
        leftSequenceTimer = 0
        leftSequenceStep = 0
        electrics.values.signal_L_1 = 0
        electrics.values.signal_L_2 = 0
        electrics.values.signal_L_3 = 0
        electrics.values.signal_L_4 = 0
    elseif currentLeftSignalState == 0 and lastLeftSignalState == 1 then
        leftSignalActive = false
        leftSequenceTimer = 0
        leftSequenceStep = 0
        electrics.values.signal_L_1 = 0
        electrics.values.signal_L_2 = 0
        electrics.values.signal_L_3 = 0
        electrics.values.signal_L_4 = 0
    end
    
    if currentRightSignalState == 1 and lastRightSignalState == 0 then
        rightSignalActive = true
        rightSequenceTimer = 0
        rightSequenceStep = 0
        electrics.values.signal_R_1 = 0
        electrics.values.signal_R_2 = 0
        electrics.values.signal_R_3 = 0
        electrics.values.signal_R_4 = 0
    elseif currentRightSignalState == 0 and lastRightSignalState == 1 then
        rightSignalActive = false
        rightSequenceTimer = 0
        rightSequenceStep = 0
        electrics.values.signal_R_1 = 0
        electrics.values.signal_R_2 = 0
        electrics.values.signal_R_3 = 0
        electrics.values.signal_R_4 = 0
    end
    
    if leftSignalActive and currentLeftSignalState == 1 then
        leftSequenceTimer = leftSequenceTimer + dt
        
        if leftSequenceTimer >= stepDuration then
            leftSequenceStep = leftSequenceStep + 1
            leftSequenceTimer = 0
            
            if leftSequenceStep == 1 then
                electrics.values.signal_L_1 = 1
            elseif leftSequenceStep == 2 then
                electrics.values.signal_L_2 = 1
            elseif leftSequenceStep == 3 then
                electrics.values.signal_L_3 = 1
            elseif leftSequenceStep == 4 then
                electrics.values.signal_L_4 = 1
            end
        end
    end
    
    if rightSignalActive and currentRightSignalState == 1 then
        rightSequenceTimer = rightSequenceTimer + dt
        
        if rightSequenceTimer >= stepDuration then
            rightSequenceStep = rightSequenceStep + 1
            rightSequenceTimer = 0
            
            if rightSequenceStep == 1 then
                electrics.values.signal_R_1 = 1
            elseif rightSequenceStep == 2 then
                electrics.values.signal_R_2 = 1
            elseif rightSequenceStep == 3 then
                electrics.values.signal_R_3 = 1
            elseif rightSequenceStep == 4 then
                electrics.values.signal_R_4 = 1
            end
        end
    end
    
    lastLeftSignalState = currentLeftSignalState
    lastRightSignalState = currentRightSignalState
end

M.onInit = onInit
M.updateGFX = updateGFX

return M