local M = {}

local pushState = 0
local lastPushState = 0
local brakeState = 0
local ignitionLevel = 0
local engineRunning = 0
local holdTimer = 0
local HOLD_THRESHOLD = 0.5

local brakeHintShown = false
local hintCooldown = 0
local firstUseHintShown = false
local HINT_COOLDOWN_TIME = 1.5

local autostartActive = false
local autostartTimer = 0
local AUTOSTART_MAX_TIME = 2.5

local autoRetry = false
local retryDelayTimer = 0
local RETRY_DELAY = 1.0

local function startCrank()
  autostartActive = true
  autostartTimer = 0
  electrics.setIgnitionLevel(3)
end

local function stopCrank()
  electrics.setIgnitionLevel(2)
  autostartActive = false
end

local function updateGFX(dt)
  pushState = electrics.values.push2start or 0
  brakeState = electrics.values.brake or 0
  ignitionLevel = electrics.values.ignitionLevel or 0
  engineRunning = electrics.values.engineRunning or 0

  hintCooldown = math.max(0, hintCooldown - dt)

  if pushState == 1 and lastPushState == 0 then
    holdTimer = 0
    brakeHintShown = false

    if not firstUseHintShown then
      guihooks.message("Tap to cycle ignition. Hold with brake to start.", 5, nil, "touch_app")
      firstUseHintShown = true
    end
  end

  if pushState == 1 then
    holdTimer = holdTimer + dt

    if brakeState == 1 and holdTimer >= HOLD_THRESHOLD and not autostartActive and not autoRetry and ignitionLevel < 3 then
      startCrank()
      autoRetry = true
      retryDelayTimer = 0
    elseif brakeState == 0 and holdTimer >= HOLD_THRESHOLD and not autostartActive and not autoRetry then
      if not brakeHintShown and hintCooldown <= 0 then
        guihooks.message("Depress brake pedal to start engine", 3, nil, "touch_app")
        brakeHintShown = true
        hintCooldown = HINT_COOLDOWN_TIME
      end
    end
  end

  if autostartActive then
    autostartTimer = autostartTimer + dt

    if engineRunning == 1 then
      stopCrank()
      autoRetry = false
    elseif autostartTimer >= AUTOSTART_MAX_TIME then
      stopCrank()
      retryDelayTimer = 0
    end
  end

  if autoRetry and not autostartActive and engineRunning == 0 then
    retryDelayTimer = retryDelayTimer + dt
    if retryDelayTimer >= RETRY_DELAY then
      startCrank()
    end
  end

  if pushState == 1 and lastPushState == 0 and autoRetry then
    autoRetry = false
    stopCrank()
  end

  if pushState == 0 and lastPushState == 1 then
    if holdTimer < HOLD_THRESHOLD and not autostartActive and not autoRetry then
      if ignitionLevel == 0 then
        electrics.setIgnitionLevel(1)
      elseif ignitionLevel == 1 then
        electrics.setIgnitionLevel(2)
      elseif ignitionLevel == 2 then
        electrics.setIgnitionLevel(0)
      end
    end
  end

  lastPushState = pushState
end

M.updateGFX = updateGFX
return M
