local M = {}

local last_door_is_locked = false
local current_fold_state = 0

local function updateGFX(dt)
  if not electrics or not electrics.values then return end

  if electrics.values.mirror_fold_enabled == nil then
    electrics.values.mirror_fold_enabled = mirror_fold_enabled
  end
  if electrics.values.running == nil then
    electrics.values.running = 0
  end
  if electrics.values.ignitionLevel == nil then
    electrics.values.ignitionLevel = 0
  end
  if electrics.values.door_is_locked == nil then
    electrics.values.door_is_locked = 0
  end
  if electrics.values.mirror_fold == nil then
    electrics.values.mirror_fold = 0
  end

  local door_is_locked = electrics.values.door_is_locked == 1
  local engine_running = electrics.values.running == 1
  local ignition_on = (electrics.values.ignitionLevel or 0) >= 2
  local fold_enabled = electrics.values.mirror_fold_enabled == 1
  local can_fold = not engine_running and not ignition_on

  if last_door_is_locked ~= door_is_locked then
    if door_is_locked then
      if fold_enabled and can_fold then
        current_fold_state = 1
        electrics.values.mirror_fold = 1
      end
    else
      if current_fold_state == 1 then
        current_fold_state = 0
        electrics.values.mirror_fold = 0
      end
    end

    last_door_is_locked = door_is_locked
  end

  if current_fold_state == 1 and (engine_running or ignition_on) then
    current_fold_state = 0
    electrics.values.mirror_fold = 0
  end
end

local function onExtensionLoaded() end

local function reset()
  last_door_is_locked = false
  current_fold_state = 0
  if electrics and electrics.values then
    electrics.values.mirror_fold = 0
    electrics.values.mirror_fold_enabled = mirror_fold_enabled
  end
end

local function onVehicleActiveChanged(active)
  if active then
    electrics.registerHandler("updateGFX", updateGFX)
  end
end

local function destroy() end

M.onVehicleActiveChanged = onVehicleActiveChanged
M.onReset = reset
M.updateGFX = updateGFX
M.onExtensionLoaded = onExtensionLoaded
M.destroy = destroy

return M
