local M = {}
local wasStopped = false
local engineIsOff = false
local lastEnabledState = nil
local stopDelayTimer = 0
local resetCooldownTimer = 0

local function init(jbeamData)
  resetCooldownTimer = 2.0
  stopDelayTimer = 0
  wasStopped = false
  engineIsOff = false
end

local function updateGFX(dt)
  resetCooldownTimer = math.max(resetCooldownTimer - dt, 0)

  local default = electrics.values.startstop_default or 0
  local input = electrics.values.startstop_input or 0

  local enabled = (default == 1)
  if input == 1 then
    enabled = not enabled
  end

  electrics.values.startstop_state = enabled and 0 or 1

  if lastEnabledState ~= nil and enabled ~= lastEnabledState then
    guihooks.message(
      enabled and "Auto Start/Stop System Enabled" or "Auto Start/Stop System Disabled",
      2, nil, "settings_backup_restore"
    )
  end
  lastEnabledState = enabled

  if not enabled then return end

  local brake = electrics.values.brake or 0
  local clutch = electrics.values.clutch or 0
  local gear = electrics.values.gear
  local wheelspeed = electrics.values.wheelspeed or 0
  local isAuto = type(gear) == "string"

  local shouldStop = false
  local shouldStart = false

if isAuto then
  shouldStop = brake == 1 and wheelspeed < 0.1 and (gear == "P")
shouldStart = engineIsOff and (
  wheelspeed > 0.1 or
  (gear ~= "P" and brake < 1) or
  (gear ~= "P" and gear ~= "N")
)
  else
    shouldStop = brake == 1 and clutch == 1 and gear == 0 and wheelspeed < 0.1
    shouldStart = engineIsOff and (clutch < 1 or gear ~= 0)
  end

  if shouldStop and resetCooldownTimer <= 0 then
    stopDelayTimer = stopDelayTimer + dt
    if stopDelayTimer >= 1.0 and not wasStopped then
      if electrics.values.ignitionLevel == 3 then
        electrics.setIgnitionLevel(2)
      else
        controller.getController("vehicleController").setEngineIgnition(false)
      end
      engineIsOff = true
      wasStopped = true
    end
  else
    stopDelayTimer = 0
  end

  if shouldStart and engineIsOff then
    electrics.setIgnitionLevel(3)
    engineIsOff = false
    wasStopped = false
  end
end

M.init = init
M.updateGFX = updateGFX

return M
