local M = {}
M.type = "auxiliary"

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 0
local textureHeight = 0
local textureFPS = 0
local updateTimer = 0
local invFPS = 1 / 15

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS and playerInfo.anyPlayerSeated then
    updateTimer = 0

    local updateData = {
      timestamp = os.time(),
      elapsedTime = os.clock()
    }

    htmlTexture.call(screenMaterialName, "updateStarlight", updateData)
  end
end

local function init(jbeamData)
  if not jbeamData then 
    print("starlight_headliner: jbeamData is nil")
    return 
  end
  
  if not jbeamData.configuration then
    print("starlight_headliner: configuration is nil")
    return
  end
  
  local config = jbeamData.configuration
  
  screenMaterialName = config.screenMaterialName
  htmlFilePath = config.htmlFilePath
  textureWidth = config.textureWidth or 1024
  textureHeight = config.textureHeight or 512
  textureFPS = config.textureFPS or 15

  if not screenMaterialName or not htmlFilePath then
    print("starlight_headliner: Missing screenMaterialName or htmlFilePath in configuration")
    return
  end

  htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
  
  local initData = {
    initialized = true,
    timestamp = os.time(),
    elapsedTime = os.clock()
  }
  
  htmlTexture.call(screenMaterialName, "updateStarlight", initData)
end

M.init = init
M.reset = nop
M.updateGFX = updateGFX

return M