local M = {}
M.type = "auxiliary"

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 0
local textureHeight = 0
local textureFPS = 0
local updateTimer = 0
local invFPS = 1 / 10
local gpsData = {x = 0, y = 0, rotation = 0, zoom = 1, ignitionLevel = 0}

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS and playerInfo.anyPlayerSeated then
    updateTimer = 0

    local pos = obj:getPosition()
    local rotation = math.deg(obj:getDirection()) + 180
    local speed = electrics.values.airspeed * 3.6
    local zoom = math.min(150 + speed * 1.5, 250)

    gpsData.x = pos.x
    gpsData.y = pos.y
    gpsData.rotation = rotation
    gpsData.speed = speed
    gpsData.zoom = zoom
    gpsData.ignitionLevel = electrics.values.ignitionLevel

    local data = {
      electrics = {
        radio_menu = electrics.values.radio_menu or 0,
        radio_back = electrics.values.radio_back or 0,
        radio_option = electrics.values.radio_option or 0,
        radio_up = electrics.values.radio_up or 0,
        radio_down = electrics.values.radio_down or 0,
        radio_left = electrics.values.radio_left or 0,
        radio_right = electrics.values.radio_right or 0,
        airspeed = electrics.values.airspeed or 0,
        fuelFlowRate = electrics.values.fuelFlowRate or 0,
        fuel = electrics.values.fuel or 0,
        fuelVolume = electrics.values.fuelVolume or 0,
        fuelLevel = electrics.values.fuelLevel or 0,
        fuelCapacity = electrics.values.fuelCapacity or 1,
        wheelspeed = electrics.values.wheelspeed or 0,
        rpm = electrics.values.rpm or 0,
        throttle = electrics.values.throttle or 0,
        odometer = electrics.values.odometer or 0,
        ignitionLevel = electrics.values.ignitionLevel or 0,
        
        daytimeLights = electrics.values.daytimeLights or 0,
        daytimeLightColorR = electrics.values.daytimeLightColorR or 255,
        daytimeLightColorG = electrics.values.daytimeLightColorG or 255,
        daytimeLightColorB = electrics.values.daytimeLightColorB or 255,
        
        footwellLights = electrics.values.footwellLights or 1,
        footwellLightColorR = electrics.values.footwellLightColorR or 255,
        footwellLightColorG = electrics.values.footwellLightColorG or 255,
        footwellLightColorB = electrics.values.footwellLightColorB or 255,
        
        doorHandleLighting = electrics.values.doorHandleLighting or 0,
        
        mirror_fold_enabled = electrics.values.mirror_fold_enabled or 0,
        flashLockUnlock = electrics.values.flashLockUnlock or 0,
        lockUnlockSoundEnabled = electrics.values.lockUnlockSoundEnabled or 0,
        
        saveChangesEnabled = electrics.values.saveChangesEnabled or 0
      },
      gps = gpsData,
      timestamp = os.time(),
      units = {
        uiUnitLength = settings.getValue('uiUnitLength') or 'metric',
        uiUnitConsumptionRate = settings.getValue('uiUnitConsumptionRate') or 'metric'
      }
    }

    htmlTexture.call(screenMaterialName, "updateData", data)
    htmlTexture.call(screenMaterialName, "map.updateData", gpsData)
  end
end

local function init(jbeamData)
  screenMaterialName = jbeamData.screenMaterialName
  htmlFilePath = jbeamData.htmlFilePath
  textureWidth = jbeamData.textureWidth
  textureHeight = jbeamData.textureHeight
  textureFPS = jbeamData.textureFPS

  htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
  
  obj:queueGameEngineLua(string.format("extensions.ui_uinavi.requestVehicleDashboardMap(%q, nil, %d)", screenMaterialName, obj:getID()))
  
  if jbeamData.bootscreenImage then
    htmlTexture.call(screenMaterialName, "map.setBootscreenImage", {url = jbeamData.bootscreenImage})
  end
  
  local unitSettings = {
    uiUnitLength = settings.getValue('uiUnitLength') or 'metric',
    uiUnitConsumptionRate = settings.getValue('uiUnitConsumptionRate') or 'metric'
  }
  
  obj:queueGameEngineLua(string.format([[
    local vehData = extensions.core_vehicle_manager.getPlayerVehicleData()
    if vehData and vehData.htmlTextures and vehData.htmlTextures[%q] then
      vehData.htmlTextures[%q]:call('setup', %s)
    end
  ]], screenMaterialName, screenMaterialName, serialize(unitSettings)))
end

M.init = init
M.reset = nop
M.updateGFX = updateGFX

return M