local M = {}
M.type = "auxiliary"

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 0
local textureHeight = 0
local textureFPS = 0
local updateTimer = 0
local invFPS = 1 / 30

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS and playerInfo.anyPlayerSeated then
    updateTimer = 0
    
    local data = {
      electrics = {
        airspeed = electrics.values.airspeed or electrics.values.wheelspeed,
        wheelspeed = electrics.values.wheelspeed,
        gear = electrics.values.gear,
        gear_A = electrics.values.gear_A,
        time = electrics.values.time,
        odometer = electrics.values.odometer or electrics.values.odometerKM,
        odometerKM = electrics.values.odometerKM,
        tripOdometer = electrics.values.tripOdometer or electrics.values.trip,
        trip = electrics.values.trip,
        uiUnits = electrics.values.uiUnits or settings.getValue("uiUnitLength")
      },
      customModules = {
        environmentData = {
          temperatureEnv = electrics.values.temperatureEnv,
          time = electrics.values.time
        }
      }
    }
    
    htmlTexture.call(screenMaterialName, "updateData", data)
  end
end

local function init(jbeamData)
  screenMaterialName = jbeamData.screenMaterialName or "RLA_A90_gauge_info"
  htmlFilePath = jbeamData.htmlFilePath or "local://local/vehicles/RLA_A90/gauge_info/gauge_info.html"
  textureWidth = jbeamData.textureWidth or 512
  textureHeight = jbeamData.textureHeight or 442
  textureFPS = jbeamData.textureFPS or 30

  htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
  
  local setupData = {
    uiUnitLength = settings.getValue("uiUnitLength") or "metric",
    uiUnitTemperature = settings.getValue("uiUnitTemperature") or "c"
  }
  htmlTexture.call(screenMaterialName, "setup", setupData)
end

M.init = init
M.reset = nop
M.updateGFX = updateGFX

return M