local M = {}

local lastSportModeState = nil
local originalGainOffset = 0
local originalMufflingOffset = 0
local sportModeApplied = false

local function applySportModeSound()
    if not powertrain then return false end
    
    local engines = powertrain.getDevicesByCategory("engine")
    if not engines or #engines == 0 then return false end
    
    local engine = engines[1]
    
    if not sportModeApplied then
        if engine.soundConfiguration then
            if engine.soundConfiguration.exhaust and engine.soundConfiguration.exhaust.params then
                originalGainOffset = engine.soundConfiguration.exhaust.params.gainOffset or 0
                originalMufflingOffset = engine.soundConfiguration.exhaust.params.mufflingOffset or 0
            end
        end
    end
    
    local success = false
    
    if engine.engineSoundIDExhaust then
        pcall(function()
            local currentParams = engine.soundConfiguration.exhaust.params
            local params = {
                base_gain = currentParams.base_gain or currentParams.main_gain or 0,
                gainOffset = 15,
                gainOffsetRevLimiter = currentParams.gainOffsetRevLimiter or 0,
                mufflingOffsetRevLimiter = currentParams.mufflingOffsetRevLimiter or 0,
                eq_a_freq = currentParams.eq_a_freq,
                eq_a_gain = currentParams.eq_a_gain,
                eq_b_freq = currentParams.eq_b_freq,
                eq_b_gain = currentParams.eq_b_gain,
                eq_c_freq = currentParams.eq_c_freq,
                eq_c_gain = currentParams.eq_c_gain,
                eq_c_reso = currentParams.eq_c_reso,
                eq_d_freq = currentParams.eq_d_freq,
                eq_d_gain = currentParams.eq_d_gain,
                eq_d_reso = currentParams.eq_d_reso,
                eq_e_gain = currentParams.eq_e_gain,
                base_muffled = currentParams.base_muffled or currentParams.muffled or 1,
                mufflingOffset = -0.6,
                fundamentalFrequencyRPMCoef = currentParams.fundamentalFrequencyRPMCoef,
                onLoadGain = currentParams.onLoadGain,
                offLoadGain = currentParams.offLoadGain,
            }
            engine:setEngineSoundParameterList(engine.engineSoundIDExhaust, params, "LOUD_EXHAUST")
            success = true
        end)
    end
    
    sportModeApplied = success
    return success
end

local function restoreSportModeSound()
    if not sportModeApplied or not powertrain then return end
    
    local engines = powertrain.getDevicesByCategory("engine")
    if not engines or #engines == 0 then return end
    
    local engine = engines[1]
    
    if engine.engineSoundIDExhaust then
        pcall(function()
            local currentParams = engine.soundConfiguration.exhaust.params
            local params = {
                base_gain = currentParams.base_gain or currentParams.main_gain or 0,
                gainOffset = originalGainOffset,
                gainOffsetRevLimiter = currentParams.gainOffsetRevLimiter or 0,
                mufflingOffsetRevLimiter = currentParams.mufflingOffsetRevLimiter or 0,
                eq_a_freq = currentParams.eq_a_freq,
                eq_a_gain = currentParams.eq_a_gain,
                eq_b_freq = currentParams.eq_b_freq,
                eq_b_gain = currentParams.eq_b_gain,
                eq_c_freq = currentParams.eq_c_freq,
                eq_c_gain = currentParams.eq_c_gain,
                eq_c_reso = currentParams.eq_c_reso,
                eq_d_freq = currentParams.eq_d_freq,
                eq_d_gain = currentParams.eq_d_gain,
                eq_d_reso = currentParams.eq_d_reso,
                eq_e_gain = currentParams.eq_e_gain,
                base_muffled = currentParams.base_muffled or currentParams.muffled or 1,
                mufflingOffset = originalMufflingOffset,
                fundamentalFrequencyRPMCoef = currentParams.fundamentalFrequencyRPMCoef,
                onLoadGain = currentParams.onLoadGain,
                offLoadGain = currentParams.offLoadGain,
            }
            engine:setEngineSoundParameterList(engine.engineSoundIDExhaust, params, "NORMAL_EXHAUST")
        end)
    end
    
    sportModeApplied = false
end

local function updateGFX(dt)
    if not electrics or not electrics.values then return end
    
    local currentSportMode = electrics.values.sportMode
    
    if currentSportMode ~= lastSportModeState then
        if currentSportMode and currentSportMode > 0 then
            applySportModeSound()
        else
            restoreSportModeSound()
        end
        
        lastSportModeState = currentSportMode
    end
end

local function init(jbeamData)
    lastSportModeState = nil
    originalGainOffset = 0
    originalMufflingOffset = 0
    sportModeApplied = false
end

local function reset()
    lastSportModeState = nil
    originalGainOffset = 0
    originalMufflingOffset = 0
    sportModeApplied = false
end

local function shutdown()
    if powertrain then
        restoreSportModeSound()
    end
end

M.init = init
M.reset = reset
M.shutdown = shutdown
M.updateGFX = updateGFX

return M