local M = {}
M.type = "auxiliary"

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 0
local textureHeight = 0
local textureFPS = 0
local updateTimer = 0
local invFPS = 1 / 10

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS and playerInfo.anyPlayerSeated then
    updateTimer = 0

    local r = electrics.values.daytimeLightColorR or 255
    local g = electrics.values.daytimeLightColorG or 255
    local b = electrics.values.daytimeLightColorB or 255
    local enabled = electrics.values.daytimeLights or 1

    local data = {
      electrics = {
        daytimeLights = enabled,
        daytimeLightColorR = r,
        daytimeLightColorG = g,
        daytimeLightColorB = b
      }
    }

    htmlTexture.call(screenMaterialName, "updateData", data)
  end
end

local function init(jbeamData)
  screenMaterialName = jbeamData.screenMaterialName
  htmlFilePath = jbeamData.htmlFilePath
  textureWidth = jbeamData.textureWidth or 512
  textureHeight = jbeamData.textureHeight or 512
  textureFPS = jbeamData.textureFPS or 30

  htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
end

local function reset()
  updateTimer = 0
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX

return M