local M = {}
M.type = "auxiliary"

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 0
local textureHeight = 0
local textureFPS = 0
local updateTimer = 0
local invFPS = 1 / 15

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS and playerInfo.anyPlayerSeated then
    updateTimer = 0
    
    -- Get the airbag data
    local data = {
      electrics = {
        airbag_fl = electrics.values.airbag_fl,
        airbag_fr = electrics.values.airbag_fr,
        airbag_rl = electrics.values.airbag_rl,
        airbag_rr = electrics.values.airbag_rr,
        tankPsi = electrics.values.tankPsi
      }
    }
    
    -- Update the screen with our data
    htmlTexture.call(screenMaterialName, "updateData", data)
  end
end

local function init(jbeamData)
  screenMaterialName = jbeamData.screenMaterialName
  htmlFilePath = jbeamData.htmlFilePath
  textureWidth = jbeamData.textureWidth
  textureHeight = jbeamData.textureHeight
  textureFPS = jbeamData.textureFPS

  htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
end

M.init = init
M.reset = nop
M.updateGFX = updateGFX

return M