angular.module('infotainmentScreen')
.controller('VehicleSettingsController', function($scope, $timeout) {
  $scope.vehicleSettingsOptions = [
    { name: "Lighting" },
    { name: "Doors/Key" },
    { name: "Toyota Supra Safety", disabled: true },
    { name: "Steering wheel vibration", disabled: true },
    { name: "Speed Assistant", disabled: true },
    { name: "Speed warning", disabled: true }
  ];

  $scope.selectedSettingsIndex = 0;
  $scope.settingsScrollOffset = 0;

  $scope.getSettingsScrollWheelRotation = function() {
    const visibleItems = 6;
    const relativeIndex = $scope.selectedSettingsIndex - $scope.settingsScrollOffset;
    
    if (relativeIndex >= 0 && relativeIndex < visibleItems) {
      return (relativeIndex + 1) * 25;
    } else {
      return Math.min(visibleItems, Math.max(1, relativeIndex + 1)) * 25;
    }
  };

  $scope.getSettingsScrollTransform = function() {
    return 'translateY(' + ($scope.settingsScrollOffset * -40) + 'px)';
  };

  $scope.getSettingsScrollbarThumbHeight = function() {
    const visibleItems = 6;
    const totalItems = $scope.vehicleSettingsOptions.length;
    const scrollbarHeight = 260;
    
    const thumbHeight = (visibleItems / totalItems) * scrollbarHeight;
    
    return Math.max(thumbHeight, 80);
  };

  $scope.getSettingsScrollbarThumbPosition = function() {
    const visibleItems = 6;
    const totalItems = $scope.vehicleSettingsOptions.length;
    const maxScroll = Math.max(0, totalItems - visibleItems);
    
    if (maxScroll === 0) return 0;
    
    const scrollbarHeight = 260;
    const thumbHeight = $scope.getSettingsScrollbarThumbHeight();
    const availableSpace = scrollbarHeight - thumbHeight;
    
    const scrollPercentage = $scope.settingsScrollOffset / maxScroll;
    return scrollPercentage * availableSpace;
  };

  $scope.findNextSelectableOption = function(direction, currentIndex) {
    let nextIndex = currentIndex;
    
    if (direction === 'up') {
      for (let i = currentIndex - 1; i >= 0; i--) {
        if (!$scope.vehicleSettingsOptions[i].disabled) {
          nextIndex = i;
          break;
        }
      }
    } else if (direction === 'down') {
      for (let i = currentIndex + 1; i < $scope.vehicleSettingsOptions.length; i++) {
        if (!$scope.vehicleSettingsOptions[i].disabled) {
          nextIndex = i;
          break;
        }
      }
    }
    
    return nextIndex;
  };

  $scope.navigateSettingsMenu = function(direction) {
    if (direction === 'up' && $scope.selectedSettingsIndex > 0) {
      const newIndex = $scope.findNextSelectableOption('up', $scope.selectedSettingsIndex);
      if (newIndex !== $scope.selectedSettingsIndex) {
        $scope.selectedSettingsIndex = newIndex;
        if ($scope.selectedSettingsIndex < $scope.settingsScrollOffset) {
          $scope.settingsScrollOffset = $scope.selectedSettingsIndex;
        }
      }
    } else if (direction === 'down' && $scope.selectedSettingsIndex < $scope.vehicleSettingsOptions.length - 1) {
      const newIndex = $scope.findNextSelectableOption('down', $scope.selectedSettingsIndex);
      if (newIndex !== $scope.selectedSettingsIndex) {
        $scope.selectedSettingsIndex = newIndex;
        const visibleItems = 6;
        if ($scope.selectedSettingsIndex >= $scope.settingsScrollOffset + visibleItems) {
          $scope.settingsScrollOffset = $scope.selectedSettingsIndex - visibleItems + 1;
        }
      }
    }
  };

  $scope.$on('settings-navigate-up', function() {
    $scope.navigateSettingsMenu('up');
  });

  $scope.$on('settings-navigate-down', function() {
    $scope.navigateSettingsMenu('down');
  });

  $scope.$on('settings-select-option', function() {
    const selectedOption = $scope.vehicleSettingsOptions[$scope.selectedSettingsIndex];
    if (selectedOption && !selectedOption.disabled) {
      if ($scope.selectedSettingsIndex === 0) {
        $scope.enteredFromIndex = $scope.selectedSettingsIndex;
        
        $timeout(function() {
          $scope.$parent.currentMenu = 'exteriorLighting';
        }, 0);
      } else if ($scope.selectedSettingsIndex === 1) {
        $scope.enteredFromIndex = $scope.selectedSettingsIndex;
        
        $timeout(function() {
          $scope.$parent.currentMenu = 'doorsKey';
        }, 0);
      }
    }
  });

  $scope.$watch('$parent.currentMenu', function(newMenu, oldMenu) {
    if (newMenu === 'vehicleSettings') {
      if ((oldMenu === 'exteriorLighting' || oldMenu === 'doorsKey') && $scope.enteredFromIndex !== undefined) {
        $scope.selectedSettingsIndex = $scope.enteredFromIndex;
        $scope.settingsScrollOffset = Math.max(0, $scope.selectedSettingsIndex - 2);
      } else {
        $scope.selectedSettingsIndex = 0;
        $scope.settingsScrollOffset = 0;
      }
    }
  });
});
