angular.module('gaugesScreen', [])
.directive('bngMapRenderUncompressed', function () {
  return {
    template: `<svg width="100%" height="100%" class="container"></svg>`,
    scope: {
      map: '<',
      color: '@?',
      width: '@?',
      drivability: '@?'
    },
    replace: true,
    restrict: 'E',
    link: function (scope, element, attrs) {
      "use strict";
      var svg = element[0]
        , mapScale = 1
        , domElems = {}
        , getColor = (rClass) => '#101010';

      function isEmpty (obj) {
        return Object.keys(obj).length === 0;
      }

      function calcRadius (radius) {
        return  Math.min(Math.max(radius, 0), 5) * 3
      }

      scope.$watch('map', function (newVal) {
        if (newVal && !isEmpty(newVal)) {
          setupMap(newVal, angular.element(svg));
        }
      })

      function _createLine(p1, p2, color) {
         return hu('<line>', svg).attr({
          x1: p1.x, y1: p1.y, x2: p2.x, y2: p2.y,
          stroke: color,
          strokeWidth: Math.max(p1.radius, p2.radius),
          strokeLinecap: "round",
        });
      }

      function drawRoads(nodes, drivabilityMin, drivabilityMax) {
        var drawn = {};
        for (var key in nodes) {
          var el = nodes[key];
          if (el.links !== undefined) {
            for (var key2 in el.links) {
              var el2 = nodes[key2];
              var drivability = el.links[key2].drivability;
              if (el2 !== undefined) {
                if (drivability >= drivabilityMin && drivability <= drivabilityMax) {
                  drawn[key + '.' + key2 + drivabilityMin + drivabilityMax] = true;
                  if (domElems[key + '.' + key2 + drivabilityMin + drivabilityMax] !== undefined) {
                    domElems[key + '.' + key2 + drivabilityMin + drivabilityMax].remove();
                  }
                  domElems[key + '.' + key2 + drivabilityMin + drivabilityMax] = _createLine({
                    x: el.pos[0] / mapScale,
                    y: -el.pos[1] / mapScale,
                    radius: calcRadius(el.radius)
                  }, {
                      x: el2.pos[0] / mapScale,
                      y: -el2.pos[1] / mapScale,
                      radius: calcRadius(el2.radius)
                    }, getColor(drivability)
                  );
                }
              }
            }
          }
        }

        for (var key in domElems) {
          if (!drawn[key] && key.endsWith('' + drivabilityMin + drivabilityMax)) {
            domElems[key].remove()
            domElems[key] = undefined;
          }
        }
      }

      function setupMap(data) {
        if (data != null) {
          svg.setAttribute('viewBox', data.viewParams.join(' '));

          if (scope.drivability !== 'false') {
            drawRoads(data.nodes, 0, 0.9);
            drawRoads(data.nodes, 0.9, 1);
          } else {
            drawRoads(data.nodes, 0, 1);
          }
        }
      }
    }
  };
})

.controller('GaugesScreenController', function ($scope, $element, $window) {
  "use strict";
  var vm = this;

  var navContainer = $element[0].children[0];
  var navDimensions = [];

  $window.initMap = (data) => {
    navDimensions = data.viewParams = [
      data.terrainOffset[0],
      data.terrainOffset[1],
      data.terrainSize[0],
      data.terrainSize[1]
    ];

    $scope.$apply(() => {
      vm.mapData = data;
    });

    navContainer.style.width = data.terrainSize[0] + "px";
    navContainer.style.height = data.terrainSize[1] + "px";
  }

  $window.updateMap = (data) => {
    var focusX = -data.x;
    var focusY = data.y;
    var origin = `${((navDimensions[0] * -1)) - focusX}px ${((navDimensions[1] * -1)) - focusY}px`;
    navContainer.style.transformOrigin = origin;
    var translateX = ((((navDimensions[0])) + 240) + focusX);
    var translateY = ((((navDimensions[1])) + 256) + focusY);
    navContainer.style.transform = `translate3d(${translateX}px,${translateY}px, 0px) rotateX(${0}deg) rotateZ(${180 + (data.rotation + 360)}deg) scale(2)`;
  }

  $window.updateData = (data) => {
  }

  $window.updateElectrics = (data) => {
  }

  $window.updateMode = (data) => {
  }

  $window.setup = (data) => {
  }
});