local M = {}

local audio = "rearwindow"
local soundPlayed = false

local function playSoundDown()
    -- name, nodeId, volume, pitch
    obj:playSFXOnce(audio, 282, 1, 1)
end

local function onInit(jbeamData)
    -- path, description, name, playOnAdd
    obj:createSFXSource("/vehicles/RLA_DelSol/sounds/rearwindow.mp3", "AudioClosest3D", audio, -1)

    --[[ possible descriptions are:
        AudioDefault3D
        AudioSoft3D
        AudioClose3D
        AudioClosest3D
        AudioMusic3D

        AudioDefaultLoop3D
        AudioCloseLoop3D
        AudioClosestLoop3D
        AudioMusicLoop3D

        Audio2D
        AudioStream2D
        AudioMusic2D

        AudioLoop2D
        AudioStreamLoop2D
    ]]
end

local function updateGFX(dt)
	if electrics.values.RLA_DelSol_rearwindow == 0 and soundPlayed == true then
		soundPlayed = false
	end

    if electrics.values.RLA_DelSol_rearwindow == 1 and soundPlayed == false then
        playSoundDown()
        soundPlayed = true
    end
end

M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

M.playSoundDown = playSoundDown

return M
