local M = {}

local lastEscInput = 0
local currentDriveState = "comfort"

local lastTcsInput = 0
local tcsHoldTime = 0
local tcsHoldThreshold = 1.5
local tcsTriggered = false
local lastNonOffMode = "comfort"
local sportHoldTime = 0
local sportHoldThreshold = 2.0
local sportTriggered = false
local lastEscMode = "comfort"

local controllerSystemDisabled = false
local driveModesController = nil
local controllerChecked = false

local function checkControllerAvailability()
  if controllerChecked then
    return driveModesController
  end

  controllerChecked = true

  local success, result = pcall(function()
    if not controller then return nil end
    if not controller.getControllerSafe then return nil end

    local ctrl = controller.getControllerSafe("driveModes")
    if ctrl and ctrl.setDriveMode and ctrl.getCurrentDriveModeKey then
      return ctrl
    end
    return nil
  end)

  if success and result then
    driveModesController = result
  else
    controllerSystemDisabled = true
    driveModesController = nil
  end

  return driveModesController
end

local function updateGFX(dt)
  if controllerSystemDisabled then
    return
  end

  local driveModes = checkControllerAvailability()
  if not driveModes then
    controllerSystemDisabled = true
    return
  end

  local escInput = electrics.values.escSport or 0

  if escInput == 1 then
    sportHoldTime = sportHoldTime + dt
    local current = driveModes.getCurrentDriveModeKey()
    if sportHoldTime >= sportHoldThreshold and not sportTriggered then
      driveModes.setDriveMode("sport+")
      sportTriggered = true
    end
  elseif lastEscInput == 1 then
    if sportHoldTime < sportHoldThreshold and not sportTriggered then
      local current = driveModes.getCurrentDriveModeKey()
      if current == "sport" then
        driveModes.setDriveMode("comfort")
        lastEscMode = "comfort"
      elseif current == "comfort" then
        driveModes.setDriveMode("sport")
        lastEscMode = "sport"
      elseif current == "sport+" then
        driveModes.setDriveMode(lastEscMode or "sport")
      end
    end
    sportHoldTime = 0
    sportTriggered = false
  end

  lastEscInput = escInput

  local tcsInput = electrics.values.tcs_toggle or 0

  if tcsInput == 1 then
    tcsHoldTime = tcsHoldTime + dt
    local current = driveModes.getCurrentDriveModeKey()
    if current == "off" and lastTcsInput == 0 then
      driveModes.setDriveMode(lastNonOffMode)
      tcsTriggered = true
    elseif current ~= "off" and not tcsTriggered and tcsHoldTime >= tcsHoldThreshold then
      lastNonOffMode = current
      driveModes.setDriveMode("off")
      tcsTriggered = true
    end
  elseif lastTcsInput == 1 then
    if tcsHoldTime < tcsHoldThreshold and not tcsTriggered then
      guihooks.message("Hold to disable traction control.", 3)
    end
    tcsHoldTime = 0
    tcsTriggered = false
  end

  lastTcsInput = tcsInput
end

local function reset()
  lastEscInput = 0
  currentDriveState = "comfort"
  lastTcsInput = 0
  tcsHoldTime = 0
  tcsTriggered = false
  lastNonOffMode = "comfort"
  sportHoldTime = 0
  sportTriggered = false
  lastEscMode = "comfort"
  controllerSystemDisabled = false
  driveModesController = nil
  controllerChecked = false
end

M.updateGFX = updateGFX
M.reset = reset
return M
