local M = {}

local audioFilterLevel = 1.0
local baseFilterStrength = 1.0
local filterUpdatePending = false

local occupantPresent = false

local function initialize(jbeamData)
    if jbeamData then
        baseFilterStrength = jbeamData.filterCoef or 1.0
    end

    audioFilterLevel = baseFilterStrength
    occupantPresent = false
end

local function resetState()
    audioFilterLevel = baseFilterStrength
    filterUpdatePending = true
    occupantPresent = false
end

local function applyAudioFilter(strength)
    audioFilterLevel = strength
    filterUpdatePending = true
end

local function calculateFilterStrength()
    if not electrics.values.doorLEnabled or not electrics.values.doorREnabled or 
       not electrics.values.doorGlassLEnabled or not electrics.values.doorGlassREnabled then
        return 0
    end

    local leftDoorOpen = (electrics.values.doorLCoupler_notAttached == 1) and 1 or 0
    local rightDoorOpen = (electrics.values.doorRCoupler_notAttached == 1) and 1 or 0
    local trunkOpen = (electrics.values.trunkCoupler_notAttached == 1) and 0.3 or 0

    local leftWindowValue = electrics.values.RLA_A90_glass_L or 0
    local rightWindowValue = electrics.values.RLA_A90_glass_R or 0

    local leftWindowOpen = (leftWindowValue ^ 0.3) * 0.7
    local rightWindowOpen = (rightWindowValue ^ 0.3) * 0.3

    local doorOpenness = (leftDoorOpen + rightDoorOpen) * 0.5
    local windowOpenness = leftWindowOpen + rightWindowOpen

    local totalOpenness = math.max(doorOpenness, windowOpenness, trunkOpen)

    return baseFilterStrength * (1 - totalOpenness)
end

local function updateGFX(dt)
    if not electrics then return end

    occupantPresent = playerInfo.anyPlayerSeated

    if not occupantPresent then
        return
    end

    if filterUpdatePending then
        obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", audioFilterLevel))
        filterUpdatePending = false
    end

    local targetFilterStrength = calculateFilterStrength()

    if math.abs(targetFilterStrength - audioFilterLevel) > 0.01 then
        applyAudioFilter(targetFilterStrength)
    end
end

local function onExtensionLoaded()
end

local function onVehicleActiveChanged(active)
    if active then
        electrics.registerHandler("updateGFX", updateGFX)
    end
end

M.init = initialize
M.reset = resetState
M.updateGFX = updateGFX
M.onExtensionLoaded = onExtensionLoaded
M.onVehicleActiveChanged = onVehicleActiveChanged

return M
