local M = {}

local leftDomeState = false
local rightDomeState = false
local doorOverride = false
local savedLeftState = false
local savedRightState = false
local doorDelayTimer = 0
local doorDelayActive = false
local initTimer = 0
local isInitializing = true

local prevDomeLInput = false
local prevDomeRInput = false
local prevDomeMasterInput = false
local prevDoorLOpen = false
local prevDoorROpen = false

local domeLDebounce = 0
local domeRDebounce = 0
local domeMasterDebounce = 0

local function updateGFX(dt)
    local domeLInput = electrics.values.dome_light_L_input or 0
    local domeRInput = electrics.values.dome_light_R_input or 0
    local domeMasterInput = electrics.values.dome_light_input or 0
    local doorLOpen = electrics.values.doorLCoupler_notAttached or 0
    local doorROpen = electrics.values.doorRCoupler_notAttached or 0

    local domeLPressed = domeLInput > 0.5
    local domeRPressed = domeRInput > 0.5
    local domeMasterPressed = domeMasterInput > 0.5
    local isLeftDoorOpen = doorLOpen > 0.5
    local isRightDoorOpen = doorROpen > 0.5
    local anyDoorOpen = isLeftDoorOpen or isRightDoorOpen

    if domeLDebounce > 0 then domeLDebounce = domeLDebounce - dt end
    if domeRDebounce > 0 then domeRDebounce = domeRDebounce - dt end
    if domeMasterDebounce > 0 then domeMasterDebounce = domeMasterDebounce - dt end
    if doorDelayTimer > 0 then doorDelayTimer = doorDelayTimer - dt end
    if initTimer > 0 then 
        initTimer = initTimer - dt
        if initTimer <= 0 then
            isInitializing = false
        end
    end

    if domeLPressed and not prevDomeLInput and domeLDebounce <= 0 then
        if not doorOverride and not doorDelayActive then
            leftDomeState = not leftDomeState
        end
        domeLDebounce = 0.2
    end

    if domeRPressed and not prevDomeRInput and domeRDebounce <= 0 then
        if not doorOverride and not doorDelayActive then
            rightDomeState = not rightDomeState
        end
        domeRDebounce = 0.2
    end

    if domeMasterPressed and not prevDomeMasterInput and domeMasterDebounce <= 0 then
        if not doorOverride and not doorDelayActive then
            if leftDomeState or rightDomeState then
                if not (leftDomeState and rightDomeState) then
                    leftDomeState = true
                    rightDomeState = true
                else
                    leftDomeState = false
                    rightDomeState = false
                end
            else
                leftDomeState = true
                rightDomeState = true
            end
        end
        domeMasterDebounce = 0.2
    end

    local doorStateChanged = (isLeftDoorOpen ~= prevDoorLOpen) or (isRightDoorOpen ~= prevDoorROpen)

    if doorStateChanged and not isInitializing then
        if anyDoorOpen and not doorOverride then
            savedLeftState = leftDomeState
            savedRightState = rightDomeState
            leftDomeState = true
            rightDomeState = true
            doorOverride = true
            doorDelayActive = false
            doorDelayTimer = 0
        elseif not anyDoorOpen and doorOverride then
            doorOverride = false
            doorDelayActive = true
            doorDelayTimer = 5.0
        end
    end

    if doorDelayActive and doorDelayTimer <= 0 then
        leftDomeState = savedLeftState
        rightDomeState = savedRightState
        doorDelayActive = false
    end

    prevDomeLInput = domeLPressed
    prevDomeRInput = domeRPressed
    prevDomeMasterInput = domeMasterPressed
    prevDoorLOpen = isLeftDoorOpen
    prevDoorROpen = isRightDoorOpen

    electrics.values.L_domelight = leftDomeState and 1 or 0
    electrics.values.R_domelight = rightDomeState and 1 or 0
end

local function init()
    leftDomeState = false
    rightDomeState = false
    doorOverride = false
    savedLeftState = false
    savedRightState = false
    doorDelayTimer = 0
    doorDelayActive = false
    initTimer = 1.0
    isInitializing = true

    prevDomeLInput = false
    prevDomeRInput = false
    prevDomeMasterInput = false
    prevDoorLOpen = false
    prevDoorROpen = false

    domeLDebounce = 0
    domeRDebounce = 0
    domeMasterDebounce = 0
end

local function reset()
    init()
end

M.updateGFX = updateGFX
M.init = init
M.reset = reset

return M
