local M = {}

local leftSignalActive = false
local leftSequenceTimer = 0
local leftSequenceStep = 0
local lastLeftSignalState = 0

local rightSignalActive = false
local rightSequenceTimer = 0
local rightSequenceStep = 0
local lastRightSignalState = 0

local stepDuration = 0.01

local function init(jbeamData)
    
end

local function reset()
    electrics.values.signalCSL_L_1 = 0
    electrics.values.signalCSL_L_2 = 0
    electrics.values.signalCSL_L_3 = 0
    electrics.values.signalCSL_L_4 = 0
    electrics.values.signalCSL_L_5 = 0
    electrics.values.signalCSL_L_6 = 0
    electrics.values.signalCSL_L_7 = 0
    
    electrics.values.signalCSL_R_1 = 0
    electrics.values.signalCSL_R_2 = 0
    electrics.values.signalCSL_R_3 = 0
    electrics.values.signalCSL_R_4 = 0
    electrics.values.signalCSL_R_5 = 0
    electrics.values.signalCSL_R_6 = 0
    electrics.values.signalCSL_R_7 = 0
    
    leftSignalActive = false
    leftSequenceTimer = 0
    leftSequenceStep = 0
    lastLeftSignalState = 0
    
    rightSignalActive = false
    rightSequenceTimer = 0
    rightSequenceStep = 0
    lastRightSignalState = 0
end

local function updateGFX(dt)
    local currentLeftSignalState = electrics.values.signal_L or 0
    local currentRightSignalState = electrics.values.signal_R or 0
    
    if currentLeftSignalState == 1 and lastLeftSignalState == 0 then
        leftSignalActive = true
        leftSequenceTimer = 0
        leftSequenceStep = 0
        electrics.values.signalCSL_L_1 = 0
        electrics.values.signalCSL_L_2 = 0
        electrics.values.signalCSL_L_3 = 0
        electrics.values.signalCSL_L_4 = 0
        electrics.values.signalCSL_L_5 = 0
        electrics.values.signalCSL_L_6 = 0
        electrics.values.signalCSL_L_7 = 0
    elseif currentLeftSignalState == 0 and lastLeftSignalState == 1 then
        leftSignalActive = false
        leftSequenceTimer = 0
        leftSequenceStep = 0
        electrics.values.signalCSL_L_1 = 0
        electrics.values.signalCSL_L_2 = 0
        electrics.values.signalCSL_L_3 = 0
        electrics.values.signalCSL_L_4 = 0
        electrics.values.signalCSL_L_5 = 0
        electrics.values.signalCSL_L_6 = 0
        electrics.values.signalCSL_L_7 = 0
    end
    
    if currentRightSignalState == 1 and lastRightSignalState == 0 then
        rightSignalActive = true
        rightSequenceTimer = 0
        rightSequenceStep = 0
        electrics.values.signalCSL_R_1 = 0
        electrics.values.signalCSL_R_2 = 0
        electrics.values.signalCSL_R_3 = 0
        electrics.values.signalCSL_R_4 = 0
        electrics.values.signalCSL_R_5 = 0
        electrics.values.signalCSL_R_6 = 0
        electrics.values.signalCSL_R_7 = 0
    elseif currentRightSignalState == 0 and lastRightSignalState == 1 then
        rightSignalActive = false
        rightSequenceTimer = 0
        rightSequenceStep = 0
        electrics.values.signalCSL_R_1 = 0
        electrics.values.signalCSL_R_2 = 0
        electrics.values.signalCSL_R_3 = 0
        electrics.values.signalCSL_R_4 = 0
        electrics.values.signalCSL_R_5 = 0
        electrics.values.signalCSL_R_6 = 0
        electrics.values.signalCSL_R_7 = 0
    end
    
    if leftSignalActive and currentLeftSignalState == 1 then
        leftSequenceTimer = leftSequenceTimer + dt
        
        if leftSequenceTimer >= stepDuration then
            leftSequenceStep = leftSequenceStep + 1
            leftSequenceTimer = 0
            
            if leftSequenceStep == 1 then
                electrics.values.signalCSL_L_7 = 1
            elseif leftSequenceStep == 2 then
                electrics.values.signalCSL_L_6 = 1
            elseif leftSequenceStep == 3 then
                electrics.values.signalCSL_L_5 = 1
            elseif leftSequenceStep == 4 then
                electrics.values.signalCSL_L_4 = 1
            elseif leftSequenceStep == 5 then
                electrics.values.signalCSL_L_3 = 1
            elseif leftSequenceStep == 6 then
                electrics.values.signalCSL_L_2 = 1
            elseif leftSequenceStep == 7 then
                electrics.values.signalCSL_L_1 = 1
            end
        end
    end
    
    if rightSignalActive and currentRightSignalState == 1 then
        rightSequenceTimer = rightSequenceTimer + dt
        
        if rightSequenceTimer >= stepDuration then
            rightSequenceStep = rightSequenceStep + 1
            rightSequenceTimer = 0
            
            if rightSequenceStep == 1 then
                electrics.values.signalCSL_R_7 = 1
            elseif rightSequenceStep == 2 then
                electrics.values.signalCSL_R_6 = 1
            elseif rightSequenceStep == 3 then
                electrics.values.signalCSL_R_5 = 1
            elseif rightSequenceStep == 4 then
                electrics.values.signalCSL_R_4 = 1
            elseif rightSequenceStep == 5 then
                electrics.values.signalCSL_R_3 = 1
            elseif rightSequenceStep == 6 then
                electrics.values.signalCSL_R_2 = 1
            elseif rightSequenceStep == 7 then
                electrics.values.signalCSL_R_1 = 1
            end
        end
    end
    
    lastLeftSignalState = currentLeftSignalState
    lastRightSignalState = currentRightSignalState
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX

return M