local M = {}
M.type = "auxiliary"

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 0
local textureHeight = 0
local textureFPS = 0
local updateTimer = 0
local invFPS = 1 / 20
local gpsData = {x = 0, y = 0, rotation = 0, zoom = 1, ignitionLevel = 0}
local textureCreated = false

-- Retry logic
local setupPending = false
local setupAttempts = 0
local maxSetupAttempts = 10
local initDelay = 0.5 -- Priority 1: 0.5s delay
local initTimer = 0
local isInitialized = false
local mapRequested = false

local function updateGFX(dt)
  if not isInitialized then
    initTimer = initTimer + dt
    if initTimer >= initDelay and not textureCreated then
      -- Attempt texture creation
      local success = pcall(function()
        htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
      end)
      
      if success then
        textureCreated = true
        setupPending = true
        setupAttempts = 0
        mapRequested = false
      end
    end
    
    -- Retry setup calls
    if setupPending and setupAttempts < maxSetupAttempts then
      setupAttempts = setupAttempts + 1
      
      -- Request map data
      if not mapRequested then
        pcall(function()
          obj:queueGameEngineLua(string.format("extensions.ui_uinavi.requestVehicleDashboardMap(%q, nil, %d)", screenMaterialName, obj:getID()))
        end)
        mapRequested = true
      end
      
      local unitSettings = {
        uiUnitLength = settings.getValue('uiUnitLength') or 'metric',
        uiUnitConsumptionRate = settings.getValue('uiUnitConsumptionRate') or 'metric'
      }
      
      local setupSuccess = pcall(function()
        obj:queueGameEngineLua(string.format([[
          local vehData = extensions.core_vehicle_manager.getPlayerVehicleData()
          if vehData and vehData.htmlTextures and vehData.htmlTextures[%q] then
            vehData.htmlTextures[%q]:call('setup', %s)
          end
        ]], screenMaterialName, screenMaterialName, serialize(unitSettings)))
      end)
      
      if setupSuccess then
        setupPending = false
        isInitialized = true
      else
        if setupAttempts >= maxSetupAttempts then
          setupPending = false
          isInitialized = true
        end
      end
    end
    
    return
  end
  
  updateTimer = updateTimer + dt
  if updateTimer > invFPS and playerInfo.anyPlayerSeated then
    updateTimer = 0

    local pos = obj:getPosition()
    local rotation = math.deg(obj:getDirection()) + 180
    local speed = electrics.values.airspeed * 3.6
    local zoom = math.min(150 + speed * 1.5, 250)

    gpsData.x = pos.x
    gpsData.y = pos.y
    gpsData.rotation = rotation
    gpsData.speed = speed
    gpsData.zoom = zoom
    gpsData.ignitionLevel = electrics.values.ignitionLevel

    local data = {
      electrics = {
        radio_menu = electrics.values.radio_menu or 0,
        radio_back = electrics.values.radio_back or 0,
        radio_option = electrics.values.radio_option or 0,
        radio_up = electrics.values.radio_up or 0,
        radio_down = electrics.values.radio_down or 0,
        radio_left = electrics.values.radio_left or 0,
        radio_right = electrics.values.radio_right or 0,
        radio_media = electrics.values.radio_media or 0,
        radio_vol_up = electrics.values.radio_vol_up or 0,
        radio_vol_down = electrics.values.radio_vol_down or 0,
        musicVolume = electrics.values.musicVolume or 50,
        airspeed = electrics.values.airspeed or 0,
        fuelFlowRate = electrics.values.fuelFlowRate or 0,
        fuel = electrics.values.fuel or 0,
        fuelVolume = electrics.values.fuelVolume or 0,
        fuelLevel = electrics.values.fuelLevel or 0,
        fuelCapacity = electrics.values.fuelCapacity or 1,
        wheelspeed = electrics.values.wheelspeed or 0,
        rpm = electrics.values.rpm or 0,
        throttle = electrics.values.throttle or 0,
        odometer = electrics.values.odometer or 0,
        ignitionLevel = electrics.values.ignitionLevel or 0,
        
        -- EQUALIZER DATA
        equalizerFade = electrics.values.equalizerFade or 50,
        equalizerBalance = electrics.values.equalizerBalance or 50,
        equalizerBass = electrics.values.equalizerBass or 50,
        subwooferEquipped = electrics.values.subwooferEquipped or 0,
        
        -- MUSIC SYSTEM DATA
        playlistsJson = electrics.values.playlistsJson or "[]",
        playlistsReady = electrics.values.playlistsReady or 0,
        playlistCount = electrics.values.playlistCount or 0,
        
        playlistSongsJson = electrics.values.playlistSongsJson or "[]",
        playlistSongsReady = electrics.values.playlistSongsReady or 0,
        selectedPlaylistId = electrics.values.selectedPlaylistId or "",
        selectedPlaylistName = electrics.values.selectedPlaylistName or "",
        playlistSongsCount = electrics.values.playlistSongsCount or 0,
        currentSongAlbumArt = electrics.values.currentSongAlbumArt or "music_note_album_default.png",
        
        previewPlaylistSongsJson = electrics.values.previewPlaylistSongsJson or "[]",
        previewPlaylistSongsReady = electrics.values.previewPlaylistSongsReady or 0,
        previewPlaylistId = electrics.values.previewPlaylistId or "",
        previewPlaylistName = electrics.values.previewPlaylistName or "",
        previewPlaylistCover = electrics.values.previewPlaylistCover or "default_playlist.png",
        requestPreviewPlaylistSongs = electrics.values.requestPreviewPlaylistSongs or "",
        
        currentSongJson = electrics.values.currentSongJson or "{}",
        currentSongReady = electrics.values.currentSongReady or 0,
        currentSongId = electrics.values.currentSongId or "",
        currentSongName = electrics.values.currentSongName or "",
        currentSongArtist = electrics.values.currentSongArtist or "",
        currentSongDuration = electrics.values.currentSongDuration or 0,
        currentSongTime = electrics.values.currentSongTime or 0,
        currentSongIsPlaying = electrics.values.currentSongIsPlaying or 0,
        currentSongIsFavorited = electrics.values.currentSongIsFavorited or 0,
        
        musicControlCommand = electrics.values.musicControlCommand or "",
        selectedSongId = electrics.values.selectedSongId or "",
        selectedSongJson = electrics.values.selectedSongJson or "",
        favoriteSongId = electrics.values.favoriteSongId or "",
        seekToTime = electrics.values.seekToTime or 0,
        
        requestPlaylistSongs = electrics.values.requestPlaylistSongs or "",
        
        nowPlayingActive = electrics.values.nowPlayingActive or 0,
        
        -- LIGHTING SYSTEM DATA
        daytimeLights = electrics.values.daytimeLights or 0,
        daytimeLightColorR = electrics.values.daytimeLightColorR or 255,
        daytimeLightColorG = electrics.values.daytimeLightColorG or 255,
        daytimeLightColorB = electrics.values.daytimeLightColorB or 255,
        
        footwellLights = electrics.values.footwellLights or 1,
        footwellLightColorR = electrics.values.footwellLightColorR or 255,
        footwellLightColorG = electrics.values.footwellLightColorG or 255,
        footwellLightColorB = electrics.values.footwellLightColorB or 255,
        
        starlightsEnabled = electrics.values.starlightsEnabled or 1,
        starlightsMode = electrics.values.starlightsMode or 0,
        starlightsSpeed = electrics.values.starlightsSpeed or 1,
        starlightsBrightness = electrics.values.starlightsBrightness or 100,
        starlightsColorR = electrics.values.starlightsColorR or 102,
        starlightsColorG = electrics.values.starlightsColorG or 126,
        starlightsColorB = electrics.values.starlightsColorB or 234,
        starlightsCursorX = electrics.values.starlightsCursorX or 50,
        starlightsCursorY = electrics.values.starlightsCursorY or 50,
        
        doorHandleLighting = electrics.values.doorHandleLighting or 0,
        
        -- VEHICLE SETTINGS DATA
        mirror_fold_enabled = electrics.values.mirror_fold_enabled or 0,
        flashLockUnlock = electrics.values.flashLockUnlock or 0,
        lockUnlockSoundEnabled = electrics.values.lockUnlockSoundEnabled or 0,
        
        saveChangesEnabled = electrics.values.saveChangesEnabled or 0,
        
        infotainmentSaveTrigger = electrics.values.infotainmentSaveTrigger or 0,
        
        infotainmentSettingsJson = electrics.values.infotainmentSettingsJson or "",
        infotainmentSettingsReady = electrics.values.infotainmentSettingsReady or 0
      },
      gps = gpsData,
      timestamp = os.time(),
      units = {
        uiUnitLength = settings.getValue('uiUnitLength') or 'metric',
        uiUnitConsumptionRate = settings.getValue('uiUnitConsumptionRate') or 'metric'
      }
    }

    pcall(function()
      htmlTexture.call(screenMaterialName, "updateData", data)
      htmlTexture.call(screenMaterialName, "map.updateData", gpsData)
    end)
  end
end

local function init(jbeamData)
  screenMaterialName = jbeamData.screenMaterialName
  htmlFilePath = jbeamData.htmlFilePath
  textureWidth = jbeamData.textureWidth
  textureHeight = jbeamData.textureHeight
  textureFPS = jbeamData.textureFPS
  
  -- Priority 1: 0.5s delay
  initDelay = 0.5
  initTimer = 0
  isInitialized = false
  textureCreated = false
  setupPending = false
  setupAttempts = 0
  mapRequested = false
  
  -- Initialize starlight electric values if not already set
  if not electrics.values.starlightsEnabled then
    electrics.values.starlightsEnabled = 1
  end
  if not electrics.values.starlightsMode then
    electrics.values.starlightsMode = 0
  end
  if not electrics.values.starlightsSpeed then
    electrics.values.starlightsSpeed = 1
  end
  if not electrics.values.starlightsBrightness then
    electrics.values.starlightsBrightness = 100
  end
  if not electrics.values.starlightsColorR then
    electrics.values.starlightsColorR = 102
  end
  if not electrics.values.starlightsColorG then
    electrics.values.starlightsColorG = 126
  end
  if not electrics.values.starlightsColorB then
    electrics.values.starlightsColorB = 234
  end
  if not electrics.values.starlightsCursorX then
    electrics.values.starlightsCursorX = 50
  end
  if not electrics.values.starlightsCursorY then
    electrics.values.starlightsCursorY = 50
  end
  
  if not electrics.values.footwellLights then
    electrics.values.footwellLights = 1
  end
  if not electrics.values.daytimeLights then
    electrics.values.daytimeLights = 0
  end
  
  if not electrics.values.equalizerFade then
    electrics.values.equalizerFade = 50
  end
  if not electrics.values.equalizerBalance then
    electrics.values.equalizerBalance = 50
  end
  if not electrics.values.equalizerBass then
    electrics.values.equalizerBass = 50
  end
  
  if electrics.values.subwooferEquipped == nil then
    electrics.values.subwooferEquipped = 0
  end
end

M.init = init
M.reset = nop
M.updateGFX = updateGFX

return M
