local M = {}

local particleTimer = 0
local particleInterval = 0.1
local exhaustNodePairs = nil
local prevAfterfireFuel = 0
local isAfterfireActive = false
local flameDurationLeft = 0
local flameVelocity = -2
local flameParticleCount = 30
local flameChance = 0.3
local flameDuration = 0.3
local particleWidth = 0
local threshold = 20000

local function loadParameters()
    if v.data.exhaustFlameSettings and v.data.exhaustFlameSettings.tunable_flame then
        local settings = v.data.exhaustFlameSettings.tunable_flame
        flameVelocity = settings.flameVelocity or flameVelocity
        flameParticleCount = settings.flameParticleCount or flameParticleCount
        flameChance = settings.flameChance or flameChance
        flameDuration = settings.flameDuration or flameDuration
        particleWidth = settings.particleWidth or particleWidth
        threshold = settings.threshold or threshold
    end
end

local function isValidExhaustTipNode(nodeName)
    if not nodeName then return false end
    
    if string.sub(nodeName, 1, 3) == "exm" then
        return false
    end
    
    if string.match(nodeName, "^ex%d") then
        return true
    end
    
    return false
end

local function getNodeName(nodeId)
    if v.data.nodes and v.data.nodes[nodeId] then
        return v.data.nodes[nodeId].name or v.data.nodes[nodeId].cid
    end
    return nil
end

local function findExhaustNodePairs()
    if exhaustNodePairs then return exhaustNodePairs end
    
    exhaustNodePairs = {}
    
    if v.data.exhaustFlameSettings and v.data.exhaustFlameSettings.exhaustTips then
        for _, tip in pairs(v.data.exhaustFlameSettings.exhaustTips) do
            if tip.source and tip.ref then
                local sourceName = getNodeName(tip.source)
                if isValidExhaustTipNode(sourceName) then
                    table.insert(exhaustNodePairs, {source = tip.source, ref = tip.ref})
                end
            end
        end
    end
    
    if #exhaustNodePairs == 0 then
        local engine = powertrain.getDevice("mainEngine")
        if engine and engine.thermals and engine.thermals.exhaustEndNodes then
            for _, endNode in pairs(engine.thermals.exhaustEndNodes) do
                local source = endNode.finish
                local ref = endNode.start
                if source and ref then
                    local sourceName = getNodeName(source)
                    if isValidExhaustTipNode(sourceName) then
                        table.insert(exhaustNodePairs, {source = source, ref = ref})
                    end
                end
            end
        end
    end
    
    if #exhaustNodePairs == 0 then
        local beams = v.data.beams or {}
        for i, beam in pairs(beams) do
            if beam.isExhaust then
                local node0Name = getNodeName(beam.id0)
                local node1Name = getNodeName(beam.id1)
                
                if isValidExhaustTipNode(node1Name) then
                    table.insert(exhaustNodePairs, {source = beam.id1, ref = beam.id0})
                elseif isValidExhaustTipNode(node0Name) then
                    table.insert(exhaustNodePairs, {source = beam.id0, ref = beam.id1})
                end
            end
        end
    end
    
    return exhaustNodePairs
end

function M.updateGFX(dt)
    if not obj then return end
    
    local engine = powertrain.getDevice("mainEngine")
    if not engine then return end
    
    local nodePairs = findExhaustNodePairs()
    if #nodePairs == 0 then return end

    local afterfireFuel = engine.instantAfterFireFuel or 0
    if not isAfterfireActive and afterfireFuel > threshold and prevAfterfireFuel <= threshold then
        if math.random() < flameChance then
            isAfterfireActive = true
            flameDurationLeft = flameDuration
            particleTimer = 0
        end
    end
    prevAfterfireFuel = afterfireFuel
    
    if isAfterfireActive then
        particleTimer = particleTimer + dt
        while particleTimer >= particleInterval do
            particleTimer = particleTimer - particleInterval
            for _, pair in ipairs(nodePairs) do
                if pair.source and pair.ref then
                    obj:addParticleByNodes(pair.source, pair.ref, flameVelocity, 26, particleWidth, flameParticleCount)
                end
            end
            flameDurationLeft = flameDurationLeft - particleInterval
            if flameDurationLeft <= 0 then
                isAfterfireActive = false
            end
        end
    end
end

function M.reset()
    exhaustNodePairs = nil
    particleTimer = 0
    prevAfterfireFuel = 0
    isAfterfireActive = false
    flameDurationLeft = 0
end

function M.init(data)
    loadParameters()
end

return M