local M = {}
M.type = "auxiliary"

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 0
local textureHeight = 0
local textureFPS = 0
local updateTimer = 0
local invFPS = 1 / 10
local textureCreated = false

-- Retry logic
local setupPending = false
local setupAttempts = 0
local maxSetupAttempts = 10
local initDelay = 2.0 -- Priority 4: 2.0s delay
local initTimer = 0
local isInitialized = false

local function updateGFX(dt)
  if not isInitialized then
    initTimer = initTimer + dt
    if initTimer >= initDelay and not textureCreated then
      -- Attempt texture creation
      local success = pcall(function()
        htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
      end)
      
      if success then
        textureCreated = true
        setupPending = true
        setupAttempts = 0
      end
    end
    
    -- Retry setup calls (test if texture is responsive)
    if setupPending and setupAttempts < maxSetupAttempts then
      setupAttempts = setupAttempts + 1
      
      local testData = {
        electrics = {
          daytimeLights = 1,
          daytimeLightColorR = 255,
          daytimeLightColorG = 255,
          daytimeLightColorB = 255
        }
      }
      
      local setupSuccess = pcall(function()
        htmlTexture.call(screenMaterialName, "updateData", testData)
      end)
      
      if setupSuccess then
        setupPending = false
        isInitialized = true
      else
        if setupAttempts >= maxSetupAttempts then
          setupPending = false
          isInitialized = true
        end
      end
    end
    
    return
  end
  
  updateTimer = updateTimer + dt
  if updateTimer > invFPS and playerInfo.anyPlayerSeated then
    updateTimer = 0

    local r = electrics.values.daytimeLightColorR or 255
    local g = electrics.values.daytimeLightColorG or 255
    local b = electrics.values.daytimeLightColorB or 255
    local enabled = electrics.values.daytimeLights or 1

    local data = {
      electrics = {
        daytimeLights = enabled,
        daytimeLightColorR = r,
        daytimeLightColorG = g,
        daytimeLightColorB = b
      }
    }

    pcall(function()
      htmlTexture.call(screenMaterialName, "updateData", data)
    end)
  end
end

local function init(jbeamData)
  screenMaterialName = jbeamData.screenMaterialName
  htmlFilePath = jbeamData.htmlFilePath
  textureWidth = jbeamData.textureWidth or 512
  textureHeight = jbeamData.textureHeight or 512
  textureFPS = jbeamData.textureFPS or 30
  
  -- Priority 4: 2.0s delay
  initDelay = 2.0
  initTimer = 0
  isInitialized = false
  textureCreated = false
  setupPending = false
  setupAttempts = 0
end

local function reset()
  updateTimer = 0
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX

return M
