local M = {}
local NUM_CYLINDERS = 6
local EXPLOSION_DURATION = 0.025

local firingPositions = {}

local function initFiringPositions()
    -- Base cylinder offsets
    local cylinderOffsets = {
        10,      -- Cylinder 1
        500,    -- Cylinder 2
        260,    -- Cylinder 3
        620,    -- Cylinder 4
        140,    -- Cylinder 5
        380       -- Cylinder 6
    }
    
    for i = 1, NUM_CYLINDERS do
        firingPositions[i] = (1 + cylinderOffsets[i] + 180) % 720
    end
end

initFiringPositions()

local explosionTimers = {0, 0, 0, 0, 0, 0}
local wasReset = true
local engineCycle = 0

local function updateGFX(dt)
    local isEngineRunning = electrics.values.rpm > 100
        
    local degreeChange = dt * electrics.values.rpm * NUM_CYLINDERS
    engineCycle = (engineCycle + degreeChange) % 720
    
    for i = 1, NUM_CYLINDERS do
        if explosionTimers[i] > 0 then
            explosionTimers[i] = explosionTimers[i] - dt
        else
            electrics.values["RLA_A90_2jz_explosion" .. i] = 0
        end
    end
    
    for i = 1, NUM_CYLINDERS do
        local firingPosition = firingPositions[i]
        local previousPosition = (engineCycle - degreeChange) % 720
        
        if (previousPosition < firingPosition and engineCycle >= firingPosition) or 
           (previousPosition > engineCycle and (firingPosition >= 0 and firingPosition < engineCycle)) then
            explosionTimers[i] = EXPLOSION_DURATION
            electrics.values["RLA_A90_2jz_explosion" .. i] = 1
        end
    end
end

M.updateGFX = updateGFX
return M