angular.module('infotainmentScreen')
.controller('VehicleController', function($scope, $timeout) {
  $scope.vehicleMenuOptions = [
    { name: "Vehicle settings" },
    { name: "System settings" },
    { name: "Contents of main menu", disabled: true },
    { name: "Driver profiles", disabled: true },
    { name: "Vehicle status", disabled: true },
    { name: "Driving information", disabled: true },
    { name: "Sport displays", disabled: true }
  ];

  $scope.selectedVehicleIndex = 0;
  $scope.scrollOffset = 0;

  $scope.getScrollWheelRotation = function() {
    const visibleItems = 6;
    const relativeIndex = $scope.selectedVehicleIndex - $scope.scrollOffset;
    
    if (relativeIndex >= 0 && relativeIndex < visibleItems) {
      return (relativeIndex + 1) * 25;
    } else {
      return Math.min(visibleItems, Math.max(1, relativeIndex + 1)) * 25;
    }
  };

  $scope.getScrollTransform = function() {
    return 'translateY(' + ($scope.scrollOffset * -40) + 'px)';
  };

  $scope.getScrollbarThumbHeight = function() {
    const visibleItems = 6;
    const totalItems = $scope.vehicleMenuOptions.length;
    const scrollbarHeight = 260;
    
    const thumbHeight = (visibleItems / totalItems) * scrollbarHeight;
    
    return Math.max(thumbHeight, 80);
  };

  $scope.getScrollbarThumbPosition = function() {
    const visibleItems = 6;
    const totalItems = $scope.vehicleMenuOptions.length;
    const maxScroll = Math.max(0, totalItems - visibleItems);
    
    if (maxScroll === 0) return 0;
    
    const scrollbarHeight = 260;
    const thumbHeight = $scope.getScrollbarThumbHeight();
    const availableSpace = scrollbarHeight - thumbHeight;
    
    const scrollPercentage = $scope.scrollOffset / maxScroll;
    return scrollPercentage * availableSpace;
  };

  $scope.findNextSelectableOption = function(direction, currentIndex) {
    let nextIndex = currentIndex;
    
    if (direction === 'up') {
      for (let i = currentIndex - 1; i >= 0; i--) {
        if (!$scope.vehicleMenuOptions[i].disabled) {
          nextIndex = i;
          break;
        }
      }
    } else if (direction === 'down') {
      for (let i = currentIndex + 1; i < $scope.vehicleMenuOptions.length; i++) {
        if (!$scope.vehicleMenuOptions[i].disabled) {
          nextIndex = i;
          break;
        }
      }
    }
    
    return nextIndex;
  };

  $scope.navigateVehicleMenu = function(direction) {
    if (direction === 'up' && $scope.selectedVehicleIndex > 0) {
      const newIndex = $scope.findNextSelectableOption('up', $scope.selectedVehicleIndex);
      if (newIndex !== $scope.selectedVehicleIndex) {
        $scope.selectedVehicleIndex = newIndex;
        if ($scope.selectedVehicleIndex < $scope.scrollOffset) {
          $scope.scrollOffset = $scope.selectedVehicleIndex;
        }
      }
    } else if (direction === 'down' && $scope.selectedVehicleIndex < $scope.vehicleMenuOptions.length - 1) {
      const newIndex = $scope.findNextSelectableOption('down', $scope.selectedVehicleIndex);
      if (newIndex !== $scope.selectedVehicleIndex) {
        $scope.selectedVehicleIndex = newIndex;
        const visibleItems = 6;
        if ($scope.selectedVehicleIndex >= $scope.scrollOffset + visibleItems) {
          $scope.scrollOffset = $scope.selectedVehicleIndex - visibleItems + 1;
        }
      }
    }
  };

  $scope.$on('vehicle-navigate-up', function() {
    $scope.navigateVehicleMenu('up');
  });

  $scope.$on('vehicle-navigate-down', function() {
    $scope.navigateVehicleMenu('down');
  });

  $scope.$on('vehicle-select-option', function() {
    const selectedOption = $scope.vehicleMenuOptions[$scope.selectedVehicleIndex];
    if (selectedOption && !selectedOption.disabled) {
      if ($scope.selectedVehicleIndex === 0) {
        $scope.enteredFromIndex = $scope.selectedVehicleIndex;
        
        $timeout(function() {
          $scope.$parent.currentMenu = 'vehicleSettings';
        }, 0);
      } else if ($scope.selectedVehicleIndex === 1) {
        $scope.enteredFromIndex = $scope.selectedVehicleIndex;
        
        $timeout(function() {
          $scope.$parent.currentMenu = 'systemSettings';
        }, 0);
      }
    }
  });

  $scope.$on('radio_options', function() {
    const selectedOption = $scope.vehicleMenuOptions[$scope.selectedVehicleIndex];
    if (selectedOption && !selectedOption.disabled) {
      if ($scope.selectedVehicleIndex === 0) {
        $scope.enteredFromIndex = $scope.selectedVehicleIndex;
        
        $timeout(function() {
          $scope.$parent.currentMenu = 'vehicleSettings';
        }, 0);
      } else if ($scope.selectedVehicleIndex === 1) {
        $scope.enteredFromIndex = $scope.selectedVehicleIndex;
        
        $timeout(function() {
          $scope.$parent.currentMenu = 'systemSettings';
        }, 0);
      }
    }
  });

  $scope.$watch('$parent.currentMenu', function(newMenu, oldMenu) {
    if (newMenu === 'vehicle' && (oldMenu === 'vehicleSettings' || oldMenu === 'systemSettings') && $scope.enteredFromIndex !== undefined) {
      $scope.selectedVehicleIndex = $scope.enteredFromIndex;
      $scope.scrollOffset = Math.max(0, $scope.selectedVehicleIndex - 2);
    }
  });
});