angular.module('infotainmentScreen')
.controller('HowToAddMusicController', function($scope, $interval, $timeout) {
  // Scroll position
  $scope.scrollPosition = 0;
  $scope.scrollSpeed = 40; // pixels per scroll action
  $scope.contentHeight = 0;
  $scope.viewportHeight = 400; // Height of visible area
  
  // Continuous scrolling variables
  let scrollInterval = null;
  let scrollDirection = null;
  
  // Calculate total content height on initialization
  $scope.calculateContentHeight = function() {
    // Increased height to account for all content sections
    $scope.contentHeight = 1200; // Adjust based on content
  };
  
  // Get scrollbar thumb height
  $scope.getScrollbarThumbHeight = function() {
    const scrollbarHeight = 400;
    const ratio = $scope.viewportHeight / $scope.contentHeight;
    const thumbHeight = Math.max(50, scrollbarHeight * ratio); // Minimum 50px
    return thumbHeight;
  };
  
  // Get scrollbar thumb position
  $scope.getScrollbarThumbPosition = function() {
    const scrollbarHeight = 400;
    const thumbHeight = $scope.getScrollbarThumbHeight();
    const maxScroll = Math.max(0, $scope.contentHeight - $scope.viewportHeight);
    
    if (maxScroll === 0) return 0;
    
    const scrollPercentage = $scope.scrollPosition / maxScroll;
    const maxThumbPosition = scrollbarHeight - thumbHeight;
    
    return scrollPercentage * maxThumbPosition;
  };
  
  // Scroll functions
  $scope.scrollDown = function() {
    const maxScroll = Math.max(0, $scope.contentHeight - $scope.viewportHeight);
    $scope.scrollPosition = Math.min($scope.scrollPosition + $scope.scrollSpeed, maxScroll);
  };
  
  $scope.scrollUp = function() {
    $scope.scrollPosition = Math.max(0, $scope.scrollPosition - $scope.scrollSpeed);
  };
  
  // Start continuous scrolling
  $scope.startContinuousScroll = function(direction) {
    if (scrollInterval) return; // Already scrolling
    
    scrollDirection = direction;
    
    // Start scrolling after a delay to allow for single taps
    scrollInterval = $interval(function() {
      if (scrollDirection === 'down') {
        $scope.scrollDown();
      } else if (scrollDirection === 'up') {
        $scope.scrollUp();
      }
    }, 1); // Scroll every 100ms for smooth movement
  };
  
  // Stop continuous scrolling
  $scope.stopContinuousScroll = function() {
    if (scrollInterval) {
      $interval.cancel(scrollInterval);
      scrollInterval = null;
      scrollDirection = null;
    }
  };
  
  // Listen for navigation events
  $scope.$on('how-to-add-music-navigate-up', function() {
    $scope.scrollUp();
  });
  
  $scope.$on('how-to-add-music-navigate-down', function() {
    $scope.scrollDown();
  });
  
  // Reset scroll position when entering the menu
  $scope.$watch('$parent.currentMenu', function(newMenu, oldMenu) {
    if (newMenu === 'howToAddMusic' && oldMenu !== 'howToAddMusic') {
      $scope.scrollPosition = 0;
      
      // Better dynamic calculation based on actual content
      $timeout(function() {
        var contentElement = document.querySelector('.how-to-add-music-content');
        if (contentElement) {
          $scope.contentHeight = contentElement.offsetHeight + 20; // Add padding
        } else {
          $scope.contentHeight = 1200; // Fallback value
        }
      }, 100);
    }
  });
  
  // Clean up on destroy
  $scope.$on('$destroy', function() {
    $scope.stopContinuousScroll();
  });
  
  // Initialize
  $scope.calculateContentHeight();
});
