local M = {}

local current_position = 0
local MOVE_SPEED = 0.5
local animation_state = 0
local animation_timer = 0
local ANIMATION_DELAY = 0.6
local dance_active = false
local previous_position = 0
local auto_lights_active = false
local prev_popup_input = false
local popup_state = false

local function updateGFX(dt)
    if not electrics then return end
    
    local open_key = electrics.values.sleepy_eye or 0
    local close_key = electrics.values.sleepy_close or 0
    local headlight_dance = electrics.values.headlight_dance or 0
    local lights = electrics.values.lowhighbeam or 0
    local popup_input = electrics.values.popup_manual or 0
    
    -- Dance (highest priority)
    if headlight_dance > 0 and not dance_active then
        dance_active = true
        previous_position = current_position
    end
    
    if dance_active then
        if headlight_dance > 0 then
            animation_timer = animation_timer + dt
            if animation_timer >= ANIMATION_DELAY then
                animation_timer = 0
                animation_state = (animation_state + 1) % 2
            end
            
            if animation_state == 0 then
                electrics.values.popup_manual = 1
                electrics.values.popup_manual_R = 0
            else
                electrics.values.popup_manual = 0
                electrics.values.popup_manual_R = 1
            end
            return
        else
            dance_active = false
            current_position = previous_position
            electrics.values.popup_manual = current_position
            electrics.values.popup_manual_R = current_position
            return
        end
    end
    
    -- Gradual control
    if open_key > 0 or close_key > 0 then
        auto_lights_active = false
        if open_key > 0 then
            current_position = current_position + MOVE_SPEED * dt
            if current_position > 1 then current_position = 1 end
        else
            current_position = current_position - MOVE_SPEED * dt
            if current_position < 0 then current_position = 0 end
        end
    -- Auto headlights
    elseif lights > 0 and not auto_lights_active and current_position == 0 then
        auto_lights_active = true
        current_position = 1
    elseif lights == 0 and auto_lights_active then
        auto_lights_active = false
        current_position = 0
    -- Manual toggle (lowest priority)
    elseif not auto_lights_active then
        if popup_input > 0 and not prev_popup_input then
            if current_position > 0 then
                current_position = 0
            else
                current_position = 1
            end
        end
    end
    prev_popup_input = popup_input > 0
    
    electrics.values.popup_manual = current_position
    electrics.values.popup_manual_R = current_position
end

local function onReset()
    current_position = 0
    animation_state = 0
    animation_timer = 0
    dance_active = false
    previous_position = 0
    auto_lights_active = false
    popup_state = false
    prev_popup_input = false
    if electrics then
        electrics.values.popup_manual = 0
        electrics.values.popup_manual_R = 0
    end
end

local function onVehicleActiveChanged(active)
    if active then
        electrics.registerHandler("updateGFX", updateGFX)
        electrics.values.popup_manual = 0
        electrics.values.popup_manual_R = 0
    end
end

M.onVehicleActiveChanged = onVehicleActiveChanged
M.onReset = onReset
M.updateGFX = updateGFX

return M