local M = {}

function M.init(id)
    print("Sequential Shifter Gear Indicator initialized!")
end

function M.updateGFX(dt)
    -- Check ignition
    if electrics.values.ignitionLevel == 0 then
        -- Turn off all segments if ignition is off
        for _, seg in ipairs({'A','B','C','D','E','F','G'}) do
            electrics.values["RLA_180sx_sq_seg" .. seg] = 0
        end
        return
    end
    
    -- Get current gear
    local gear = electrics.values.gear_M
    
    -- Convert gear to display value
    local displayValue
    if gear == nil or gear == 0 then
        displayValue = 0  -- Neutral (now showing as 0)
    elseif gear == -1 then
        displayValue = 'R'  -- Reverse
    else
        displayValue = math.abs(gear)  -- Forward gears
    end
    
    -- Define digit and letter patterns
    local patterns = {
        [0] = {0,0,1,0,1,0,1},  -- 0 (Neutral)
        [1] = {0,1,1,0,0,0,0},  -- 1
        [2] = {1,1,0,1,1,0,1},  -- 2
        [3] = {1,1,1,1,0,0,1},  -- 3
        [4] = {0,1,1,0,0,1,1},  -- 4
        [5] = {1,0,1,1,0,1,1},  -- 5
        [6] = {1,0,1,1,1,1,1},  -- 6
        ['R'] = {1,1,1,0,1,1,1}   -- R
    }
    
    -- Set the segments based on the pattern
    local pattern = patterns[displayValue]
    if pattern then
        electrics.values["RLA_180sx_sq_segA"] = pattern[1]
        electrics.values["RLA_180sx_sq_segB"] = pattern[2]
        electrics.values["RLA_180sx_sq_segC"] = pattern[3]
        electrics.values["RLA_180sx_sq_segD"] = pattern[4]
        electrics.values["RLA_180sx_sq_segE"] = pattern[5]
        electrics.values["RLA_180sx_sq_segF"] = pattern[6]
        electrics.values["RLA_180sx_sq_segG"] = pattern[7]
    else
        -- If gear is out of range, turn off all segments
        for _, seg in ipairs({'A','B','C','D','E','F','G'}) do
            electrics.values["RLA_180sx_sq_seg" .. seg] = 0
        end
    end
end

return M